/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.service;

import java.util.Map;
import org.jboss.as.arquillian.service.SecurityActions;
import org.jboss.as.server.deployment.SetupAction;

final class TCCLSetup
implements SetupAction {
    private final ThreadLocal<ClassLoader> oldClassLoader = new ThreadLocal();
    private final ClassLoader classLoader;

    public TCCLSetup(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public int priority() {
        return 10000;
    }

    public void setup(Map<String, Object> properties) {
        this.oldClassLoader.set(SecurityActions.getContextClassLoader());
        SecurityActions.setContextClassLoader(this.classLoader);
    }

    public void teardown(Map<String, Object> properties) {
        ClassLoader old = this.oldClassLoader.get();
        this.oldClassLoader.remove();
        SecurityActions.setContextClassLoader(old);
    }
}

