/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.jboss.as.ee.component.AbstractComponent;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactoryContext;

public abstract class AbstractComponentInstance
implements ComponentInstance {
    private static final long serialVersionUID = -8099216228976950066L;
    private final AbstractComponent component;
    private final Object instance;
    private final List<Interceptor> preDestroyInterceptors;
    private Map<Method, Interceptor> methodMap;

    protected AbstractComponentInstance(AbstractComponent component, Object instance, List<Interceptor> preDestroyInterceptors, InterceptorFactoryContext factoryContext) {
        this.component = component;
        this.instance = instance;
        this.preDestroyInterceptors = preDestroyInterceptors;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public Object getInstance() {
        return this.instance;
    }

    @Override
    public Iterable<Interceptor> getPreDestroyInterceptors() {
        return this.preDestroyInterceptors;
    }

    @Override
    public Interceptor getInterceptor(Method method) throws IllegalStateException {
        Interceptor interceptor = this.methodMap.get(method);
        if (interceptor == null) {
            throw new IllegalStateException("Method does not exist");
        }
        return interceptor;
    }

    void setMethodMap(Map<Method, Interceptor> methodMap) {
        this.methodMap = methodMap;
    }
}

