/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.sun.net.httpserver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.jboss.sun.net.httpserver.HttpContextImpl;
import org.jboss.sun.net.httpserver.SSLStreams;
import org.jboss.sun.net.httpserver.ServerImpl;

class HttpConnection {
    HttpContextImpl context;
    SSLEngine engine;
    SSLContext sslContext;
    SSLStreams sslStreams;
    InputStream i;
    InputStream raw;
    OutputStream rawout;
    SocketChannel chan;
    SelectionKey selectionKey;
    String protocol;
    long time;
    int remaining;
    boolean closed = false;
    Logger logger;

    public String toString() {
        String s = null;
        if (this.chan != null) {
            s = this.chan.toString();
        }
        return s;
    }

    HttpConnection() {
    }

    void setChannel(SocketChannel c) {
        this.chan = c;
    }

    void setContext(HttpContextImpl ctx) {
        this.context = ctx;
    }

    void setParameters(InputStream in, OutputStream rawout, SocketChannel chan, SSLEngine engine, SSLStreams sslStreams, SSLContext sslContext, String protocol, HttpContextImpl context, InputStream raw) {
        this.context = context;
        this.i = in;
        this.rawout = rawout;
        this.raw = raw;
        this.protocol = protocol;
        this.engine = engine;
        this.chan = chan;
        this.sslContext = sslContext;
        this.sslStreams = sslStreams;
        this.logger = context.getLogger();
    }

    SocketChannel getChannel() {
        return this.chan;
    }

    synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.logger != null && this.chan != null) {
            this.logger.finest("Closing connection: " + this.chan.toString());
        }
        if (!this.chan.isOpen()) {
            ServerImpl.dprint("Channel already closed");
            return;
        }
        try {
            if (this.raw != null) {
                this.raw.close();
            }
        }
        catch (IOException e) {
            ServerImpl.dprint(e);
        }
        try {
            if (this.rawout != null) {
                this.rawout.close();
            }
        }
        catch (IOException e) {
            ServerImpl.dprint(e);
        }
        try {
            if (this.sslStreams != null) {
                this.sslStreams.close();
            }
        }
        catch (IOException e) {
            ServerImpl.dprint(e);
        }
        try {
            this.chan.close();
        }
        catch (IOException e) {
            ServerImpl.dprint(e);
        }
    }

    void setRemaining(int r) {
        this.remaining = r;
    }

    int getRemaining() {
        return this.remaining;
    }

    SelectionKey getSelectionKey() {
        return this.selectionKey;
    }

    InputStream getInputStream() {
        return this.i;
    }

    OutputStream getRawOutputStream() {
        return this.rawout;
    }

    String getProtocol() {
        return this.protocol;
    }

    SSLEngine getSSLEngine() {
        return this.engine;
    }

    SSLContext getSSLContext() {
        return this.sslContext;
    }

    HttpContextImpl getHttpContext() {
        return this.context;
    }
}

