/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.sun.net.httpserver;

import com.sun.net.httpserver.Headers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import org.jboss.sun.net.httpserver.SelectorCache;
import org.jboss.sun.net.httpserver.ServerConfig;
import org.jboss.sun.net.httpserver.ServerImpl;

class Request {
    static final int BUF_LEN = 2048;
    static final byte CR = 13;
    static final byte LF = 10;
    private String startLine;
    private SocketChannel chan;
    private InputStream is;
    private OutputStream os;
    char[] buf = new char[2048];
    int pos;
    StringBuffer lineBuf;
    Headers hdrs = null;

    Request(InputStream rawInputStream, OutputStream rawout) throws IOException {
        this.chan = this.chan;
        this.is = rawInputStream;
        this.os = rawout;
        do {
            this.startLine = this.readLine();
        } while (this.startLine != null && this.startLine.equals(""));
    }

    public InputStream inputStream() {
        return this.is;
    }

    public OutputStream outputStream() {
        return this.os;
    }

    public String readLine() throws IOException {
        boolean gotCR = false;
        boolean gotLF = false;
        this.pos = 0;
        this.lineBuf = new StringBuffer();
        while (!gotLF) {
            int c = this.is.read();
            if (c == -1) {
                return null;
            }
            if (gotCR) {
                if (c == 10) {
                    gotLF = true;
                    continue;
                }
                gotCR = false;
                this.consume(13);
                this.consume(c);
                continue;
            }
            if (c == 13) {
                gotCR = true;
                continue;
            }
            this.consume(c);
        }
        this.lineBuf.append(this.buf, 0, this.pos);
        return new String(this.lineBuf);
    }

    private void consume(int c) {
        if (this.pos == 2048) {
            this.lineBuf.append(this.buf);
            this.pos = 0;
        }
        this.buf[this.pos++] = (char)c;
    }

    public String requestLine() {
        return this.startLine;
    }

    /*
     * Enabled aggressive block sorting
     */
    Headers headers() throws IOException {
        if (this.hdrs != null) {
            return this.hdrs;
        }
        this.hdrs = new Headers();
        char[] s = new char[10];
        int firstc = this.is.read();
        while (true) {
            String k;
            int keyend;
            int len;
            block20: {
                int c;
                boolean inKey;
                if (firstc != 10 && firstc != 13 && firstc >= 0) {
                    len = 0;
                    keyend = -1;
                    inKey = firstc > 32;
                    s[len++] = (char)firstc;
                } else {
                    return this.hdrs;
                }
                while ((c = this.is.read()) >= 0) {
                    switch (c) {
                        case 58: {
                            if (inKey && len > 0) {
                                keyend = len;
                            }
                            inKey = false;
                            break;
                        }
                        case 9: {
                            c = 32;
                        }
                        case 32: {
                            inKey = false;
                            break;
                        }
                        case 10: 
                        case 13: {
                            firstc = this.is.read();
                            if (c == 13 && firstc == 10 && (firstc = this.is.read()) == 13) {
                                firstc = this.is.read();
                            }
                            if (firstc == 10 || firstc == 13 || firstc > 32) break block20;
                            c = 32;
                        }
                    }
                    if (len >= s.length) {
                        char[] ns = new char[s.length * 2];
                        System.arraycopy(s, 0, ns, 0, len);
                        s = ns;
                    }
                    s[len++] = (char)c;
                }
                firstc = -1;
            }
            while (len > 0 && s[len - 1] <= ' ') {
                --len;
            }
            if (keyend <= 0) {
                k = null;
                keyend = 0;
            } else {
                k = String.copyValueOf(s, 0, keyend);
                if (keyend < len && s[keyend] == ':') {
                    ++keyend;
                }
                while (keyend < len && s[keyend] <= ' ') {
                    ++keyend;
                }
            }
            String v = keyend >= len ? new String() : String.copyValueOf(s, keyend, len - keyend);
            this.hdrs.add(k, v);
        }
    }

    static class WriteStream
    extends OutputStream {
        SocketChannel channel;
        ByteBuffer buf;
        SelectionKey key;
        SelectorCache sc;
        Selector selector;
        boolean closed;
        byte[] one;
        ServerImpl server;
        static long writeTimeout = ServerConfig.getWriteTimeout();

        public WriteStream(ServerImpl server, SocketChannel channel) throws IOException {
            this.channel = channel;
            this.server = server;
            this.sc = SelectorCache.getSelectorCache();
            this.selector = this.sc.getSelector();
            this.key = channel.register(this.selector, 4);
            this.closed = false;
            this.one = new byte[1];
            this.buf = ByteBuffer.allocate(4096);
        }

        public synchronized void write(int b) throws IOException {
            this.one[0] = (byte)b;
            this.write(this.one, 0, 1);
        }

        public synchronized void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public synchronized void write(byte[] b, int off, int len) throws IOException {
            int n;
            int l = len;
            if (this.closed) {
                throw new IOException("stream is closed");
            }
            int cap = this.buf.capacity();
            if (cap < len) {
                int diff = len - cap;
                this.buf = ByteBuffer.allocate(2 * (cap + diff));
            }
            this.buf.clear();
            this.buf.put(b, off, len);
            this.buf.flip();
            while ((n = this.channel.write(this.buf)) < l) {
                if ((l -= n) == 0) {
                    return;
                }
                this.block();
            }
        }

        void block() throws IOException {
            long currtime = this.server.getTime();
            long maxtime = currtime + writeTimeout;
            while (currtime < maxtime) {
                if (this.selector.select(writeTimeout) == 1) {
                    this.selector.selectedKeys().clear();
                    return;
                }
                currtime = this.server.getTime();
            }
            throw new SocketTimeoutException("write blocked too long");
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.channel.close();
            this.selector.selectNow();
            this.sc.freeSelector(this.selector);
            this.closed = true;
        }
    }

    static class ReadStream
    extends InputStream {
        SocketChannel channel;
        SelectorCache sc;
        Selector selector;
        ByteBuffer chanbuf;
        SelectionKey key;
        int available;
        byte[] one;
        boolean closed = false;
        boolean eof = false;
        ByteBuffer markBuf;
        boolean marked;
        boolean reset;
        int readlimit;
        static long readTimeout = ServerConfig.getReadTimeout();
        ServerImpl server;

        public ReadStream(ServerImpl server, SocketChannel chan) throws IOException {
            this.channel = chan;
            this.server = server;
            this.sc = SelectorCache.getSelectorCache();
            this.selector = this.sc.getSelector();
            this.chanbuf = ByteBuffer.allocate(8192);
            this.key = chan.register(this.selector, 1);
            this.available = 0;
            this.one = new byte[1];
            this.reset = false;
            this.marked = false;
            this.closed = false;
        }

        public synchronized int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public synchronized int read() throws IOException {
            int result = this.read(this.one, 0, 1);
            if (result == 1) {
                return this.one[0] & 0xFF;
            }
            return -1;
        }

        public synchronized int read(byte[] b, int off, int srclen) throws IOException {
            int willreturn;
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (this.eof) {
                return -1;
            }
            if (this.reset) {
                int canreturn = this.markBuf.remaining();
                willreturn = canreturn > srclen ? srclen : canreturn;
                this.markBuf.get(b, off, willreturn);
                if (canreturn == willreturn) {
                    this.reset = false;
                }
            } else {
                int canreturn = this.available();
                while (canreturn == 0 && !this.eof) {
                    this.block();
                    canreturn = this.available();
                }
                if (this.eof) {
                    return -1;
                }
                willreturn = canreturn > srclen ? srclen : canreturn;
                this.chanbuf.get(b, off, willreturn);
                this.available -= willreturn;
                if (this.marked) {
                    try {
                        this.markBuf.put(b, off, willreturn);
                    }
                    catch (BufferOverflowException e) {
                        this.marked = false;
                    }
                }
            }
            return willreturn;
        }

        public synchronized int available() throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            if (this.eof) {
                return -1;
            }
            if (this.reset) {
                return this.markBuf.remaining();
            }
            if (this.available > 0) {
                return this.available;
            }
            this.chanbuf.clear();
            this.available = this.channel.read(this.chanbuf);
            if (this.available > 0) {
                this.chanbuf.flip();
            } else if (this.available == -1) {
                this.eof = true;
                this.available = 0;
            }
            return this.available;
        }

        private synchronized void block() throws IOException {
            long currtime = this.server.getTime();
            long maxtime = currtime + readTimeout;
            while (currtime < maxtime) {
                if (this.selector.select(readTimeout) == 1) {
                    this.selector.selectedKeys().clear();
                    this.available();
                    return;
                }
                currtime = this.server.getTime();
            }
            throw new SocketTimeoutException("no data received");
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.channel.close();
            this.selector.selectNow();
            this.sc.freeSelector(this.selector);
            this.closed = true;
        }

        public synchronized void mark(int readlimit) {
            if (this.closed) {
                return;
            }
            this.readlimit = readlimit;
            this.markBuf = ByteBuffer.allocate(readlimit);
            this.marked = true;
            this.reset = false;
        }

        public synchronized void reset() throws IOException {
            if (this.closed) {
                return;
            }
            if (!this.marked) {
                throw new IOException("Stream not marked");
            }
            this.marked = false;
            this.reset = true;
            this.markBuf.flip();
        }
    }
}

