/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.osgi.framework.bundle.AbstractBundle;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.plugin.ModuleManagerPlugin;
import org.jboss.osgi.framework.plugin.ResolverPlugin;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.resolver.XModuleBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public abstract class AbstractRevision {
    static final Logger log = Logger.getLogger(AbstractRevision.class);
    private final int revision;
    private final AbstractBundle bundleState;
    private final OSGiMetaData metadata;
    private XModule resolverModule;
    private boolean refreshAllowed;
    private final ModuleManagerPlugin moduleManager;
    private final ResolverPlugin resolverPlugin;

    AbstractRevision(AbstractBundle bundleState, OSGiMetaData metadata, XModule resModule, int revision) throws BundleException {
        if (bundleState == null) {
            throw new IllegalArgumentException("Null bundleState");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("Null metadata");
        }
        this.bundleState = bundleState;
        this.metadata = metadata;
        this.revision = revision;
        BundleManager bundleManager = this.getBundleManager();
        this.moduleManager = bundleManager.getPlugin(ModuleManagerPlugin.class);
        this.resolverPlugin = bundleManager.getPlugin(ResolverPlugin.class);
        if (resModule == null) {
            resModule = this.createResolverModule(bundleState, metadata);
            this.refreshAllowed = true;
        }
        resModule.addAttachment(AbstractRevision.class, (Object)this);
        resModule.addAttachment(Bundle.class, (Object)bundleState);
        this.refreshRevisionInternal(resModule);
        this.resolverModule = resModule;
    }

    void refreshRevision(OSGiMetaData metadata) throws BundleException {
        if (!this.refreshAllowed) {
            throw new IllegalStateException("External XModule, refresh not allowed");
        }
        this.resolverModule = this.createResolverModule(this.bundleState, metadata);
        this.refreshRevisionInternal(this.resolverModule);
    }

    XModule createResolverModule(AbstractBundle bundleState, OSGiMetaData metadata) throws BundleException {
        String symbolicName = metadata.getBundleSymbolicName();
        Version version = metadata.getBundleVersion();
        int modulerev = this.revision;
        BundleManager bundleManager = bundleState.getBundleManager();
        for (AbstractBundle aux : bundleManager.getBundles(symbolicName, version.toString())) {
            if (aux.getState() != 1) continue;
            XModule resModule = aux.getResolverModule();
            int auxrev = resModule.getModuleId().getRevision();
            modulerev = Math.max(modulerev + 100, auxrev + 100);
        }
        XModuleBuilder builder = this.resolverPlugin.getModuleBuilder();
        XModule resModule = builder.createModule(metadata, modulerev).getModule();
        resModule.addAttachment(AbstractRevision.class, (Object)this);
        resModule.addAttachment(Bundle.class, (Object)bundleState);
        return resModule;
    }

    abstract void refreshRevisionInternal(XModule var1);

    public int getRevisionId() {
        return this.revision;
    }

    public XModule getResolverModule() {
        return this.resolverModule;
    }

    public AbstractBundle getBundleState() {
        return this.bundleState;
    }

    public ModuleIdentifier getModuleIdentifier() {
        return this.moduleManager.getModuleIdentifier(this.resolverModule);
    }

    public ModuleClassLoader getModuleClassLoader() {
        ModuleIdentifier identifier = this.getModuleIdentifier();
        Module module = this.moduleManager.getModule(identifier);
        return module != null ? module.getClassLoader() : null;
    }

    BundleManager getBundleManager() {
        return this.bundleState.getBundleManager();
    }

    OSGiMetaData getOSGiMetaData() {
        return this.metadata;
    }

    String getSymbolicName() {
        return this.bundleState.getSymbolicName();
    }

    Version getVersion() {
        return this.metadata.getBundleVersion();
    }

    abstract Class<?> loadClass(String var1) throws ClassNotFoundException;

    abstract URL getResource(String var1);

    abstract Enumeration<URL> getResources(String var1) throws IOException;

    abstract Enumeration<String> getEntryPaths(String var1);

    abstract URL getEntry(String var1);

    abstract Enumeration<URL> findEntries(String var1, String var2, boolean var3);

    abstract String getLocation();

    abstract URL getLocalizationEntry(String var1);

    public String toString() {
        return "Revision[" + this.resolverModule.getModuleId() + "]";
    }
}

