/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.bundle.AbstractRevision;
import org.jboss.osgi.framework.bundle.AbstractUserBundle;
import org.jboss.osgi.framework.bundle.BundleStorageState;
import org.jboss.osgi.framework.bundle.EntriesProvider;
import org.jboss.osgi.framework.bundle.ModuleEntriesProvider;
import org.jboss.osgi.framework.bundle.RevisionContent;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.BundleException;

public abstract class AbstractUserRevision
extends AbstractRevision {
    static final Logger log = Logger.getLogger(AbstractUserRevision.class);
    private final Deployment deployment;
    private List<RevisionContent> contentList;
    private final EntriesProvider entriesProvider;

    AbstractUserRevision(AbstractUserBundle bundleState, Deployment dep) throws BundleException {
        super(bundleState, AbstractUserRevision.getOSGiMetaData(dep), AbstractUserRevision.getXModule(dep), AbstractUserRevision.getRevisionId(dep));
        this.deployment = dep;
        if (dep.getRoot() != null) {
            this.contentList = this.getBundleClassPath(dep.getRoot(), this.getOSGiMetaData());
            this.entriesProvider = this.getRootContent();
        } else {
            this.entriesProvider = new ModuleEntriesProvider((Module)dep.getAttachment(Module.class));
            this.contentList = Collections.emptyList();
        }
    }

    public static AbstractUserRevision assertUserRevision(AbstractRevision bundleRev) {
        if (bundleRev == null) {
            throw new IllegalArgumentException("Null bundleRev");
        }
        if (!(bundleRev instanceof AbstractUserRevision)) {
            throw new IllegalArgumentException("Not an AbstractUserRevision: " + bundleRev);
        }
        return (AbstractUserRevision)bundleRev;
    }

    private static OSGiMetaData getOSGiMetaData(Deployment dep) {
        return (OSGiMetaData)dep.getAttachment(OSGiMetaData.class);
    }

    private static XModule getXModule(Deployment dep) {
        return (XModule)dep.getAttachment(XModule.class);
    }

    private static int getRevisionId(Deployment dep) {
        BundleStorageState storageState = (BundleStorageState)dep.getAttachment(BundleStorageState.class);
        return storageState.getRevisionId();
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    @Override
    public String getLocation() {
        return this.deployment.getLocation();
    }

    public RevisionContent getRootContent() {
        return this.contentList.size() > 0 ? this.contentList.get(0) : null;
    }

    public List<RevisionContent> getContentList() {
        return this.contentList;
    }

    public RevisionContent getContentById(int contentId) {
        for (RevisionContent aux : this.contentList) {
            if (aux.getContentId() != contentId) continue;
            return aux;
        }
        return null;
    }

    void close() {
        for (RevisionContent aux : this.contentList) {
            aux.close();
        }
    }

    @Override
    public Enumeration<String> getEntryPaths(String path) {
        this.getBundleState().assertNotUninstalled();
        return this.entriesProvider.getEntryPaths(path);
    }

    @Override
    public URL getEntry(String path) {
        this.getBundleState().assertNotUninstalled();
        return this.entriesProvider.getEntry(path);
    }

    @Override
    public Enumeration<URL> findEntries(String path, String pattern, boolean recurse) {
        this.getBundleState().assertNotUninstalled();
        return this.entriesProvider.findEntries(path, pattern, recurse);
    }

    private List<RevisionContent> getBundleClassPath(VirtualFile rootFile, OSGiMetaData metadata) {
        if (rootFile == null) {
            throw new IllegalArgumentException("Null rootFile");
        }
        if (metadata.getBundleClassPath().size() == 0) {
            RevisionContent revContent = new RevisionContent(this, 0, rootFile);
            return Collections.singletonList(revContent);
        }
        ArrayList<RevisionContent> rootList = new ArrayList<RevisionContent>();
        for (String path : metadata.getBundleClassPath()) {
            if (path.equals(".")) {
                RevisionContent revContent = new RevisionContent(this, rootList.size(), rootFile);
                rootList.add(revContent);
                continue;
            }
            try {
                VirtualFile child = rootFile.getChild(path);
                if (child == null) continue;
                VirtualFile anotherRoot = AbstractVFS.toVirtualFile((URL)child.toURL());
                RevisionContent revContent = new RevisionContent(this, rootList.size(), anotherRoot);
                rootList.add(revContent);
            }
            catch (IOException ex) {
                log.errorf((Throwable)ex, "Cannot get class path element: %s", (Object)path);
            }
        }
        return Collections.unmodifiableList(rootList);
    }
}

