/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.util.HashSet;
import java.util.List;
import org.jboss.osgi.framework.bundle.AbstractBundle;
import org.jboss.osgi.framework.bundle.BundleValidator;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.PackageAttribute;
import org.jboss.osgi.metadata.ParameterizedAttribute;
import org.osgi.framework.BundleException;

class BundleValidatorR4
implements BundleValidator {
    BundleValidatorR4() {
    }

    @Override
    public void validateBundle(AbstractBundle bundleState) throws BundleException {
        List dynamicImports;
        List exportPackages;
        String packageName;
        OSGiMetaData osgiMetaData = bundleState.getOSGiMetaData();
        String symbolicName = osgiMetaData.getBundleSymbolicName();
        if (symbolicName == null) {
            throw new BundleException("Missing Bundle-SymbolicName in: " + bundleState);
        }
        int manifestVersion = osgiMetaData.getBundleManifestVersion();
        if (manifestVersion > 2) {
            throw new BundleException("Unsupported manifest version " + manifestVersion + " for " + bundleState);
        }
        List importPackages = osgiMetaData.getImportPackages();
        if (importPackages != null) {
            HashSet<String> packages = new HashSet<String>();
            for (PackageAttribute packageAttribute : importPackages) {
                packageName = packageAttribute.getAttribute();
                if (packages.contains(packageName)) {
                    throw new BundleException("Duplicate import of package " + packageName + " for " + bundleState);
                }
                packages.add(packageName);
                if (packageName.startsWith("java.")) {
                    throw new BundleException("Not allowed to import java.* for " + bundleState);
                }
                String version = (String)packageAttribute.getAttributeValue("version", String.class);
                String specificationVersion = (String)packageAttribute.getAttributeValue("specification-version", String.class);
                if (version == null || specificationVersion == null || version.equals(specificationVersion)) continue;
                throw new BundleException(packageName + " version and specification version should be the same in: " + bundleState);
            }
        }
        if ((exportPackages = osgiMetaData.getExportPackages()) != null) {
            for (PackageAttribute packageAttr : exportPackages) {
                packageName = packageAttr.getAttribute();
                if (packageName.startsWith("java.")) {
                    throw new BundleException("Not allowed to export java.* for " + bundleState);
                }
                String versionAttr = (String)packageAttr.getAttributeValue("version", String.class);
                String specificationAttr = (String)packageAttr.getAttributeValue("specification-version", String.class);
                if (versionAttr != null && specificationAttr != null && !versionAttr.equals(specificationAttr)) {
                    throw new BundleException(packageName + " version and specification version should be the same in: " + bundleState);
                }
                String symbolicNameAttr = (String)packageAttr.getAttributeValue("bundle-symbolic-name", String.class);
                if (symbolicNameAttr != null) {
                    throw new BundleException(packageName + " must not specify an explicit bundle symbolic name in: " + bundleState);
                }
                String bundleVersionAttr = (String)packageAttr.getAttributeValue("bundle-version", String.class);
                if (bundleVersionAttr == null) continue;
                throw new BundleException(packageName + " must not specify an explicit bundle version in: " + bundleState);
            }
        }
        if ((dynamicImports = osgiMetaData.getDynamicImports()) != null) {
            for (PackageAttribute packageAttr : dynamicImports) {
                String packageName2 = packageAttr.getAttribute();
                String versionAttr = (String)packageAttr.getAttributeValue("version", String.class);
                String specificationAttr = (String)packageAttr.getAttributeValue("specification-version", String.class);
                if (versionAttr == null || specificationAttr == null || versionAttr.equals(specificationAttr)) continue;
                throw new BundleException(packageName2 + " version and specification version should be the same in: " + bundleState);
            }
        }
        for (AbstractBundle aux : bundleState.getBundleManager().getBundles()) {
            if (!bundleState.getCanonicalName().equals(aux.getCanonicalName())) continue;
            throw new BundleException("Cannot install bundle, name and version already installed: " + aux);
        }
        if (bundleState.isFragment()) {
            ParameterizedAttribute hostAttr = osgiMetaData.getFragmentHost();
            String fragmentHost = hostAttr.getAttribute();
            String extension = (String)hostAttr.getDirectiveValue("extension", String.class);
            if (extension != null) {
                if (!"system.bundle".equals(fragmentHost)) {
                    throw new BundleException("Invalid Fragment-Host for extension fragment: " + bundleState);
                }
                if ("bootclasspath".equals(extension)) {
                    throw new UnsupportedOperationException("Boot classpath extension not supported");
                }
                if ("framework".equals(extension)) {
                    throw new UnsupportedOperationException("Framework extension not supported");
                }
            }
        }
    }
}

