/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Enumeration;
import java.util.Vector;
import org.jboss.logging.Logger;
import org.jboss.osgi.framework.bundle.AbstractBundle;
import org.jboss.osgi.framework.bundle.AbstractRevision;
import org.jboss.osgi.framework.bundle.AbstractUserRevision;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.bundle.EntriesProvider;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VFSUtils;
import org.jboss.osgi.vfs.VirtualFile;

public final class RevisionContent
implements EntriesProvider {
    static final Logger log = Logger.getLogger(RevisionContent.class);
    private final AbstractUserRevision userRev;
    private final VirtualFile virtualFile;
    private final String identity;
    private final int contentId;

    RevisionContent(AbstractUserRevision userRev, int contentId, VirtualFile rootFile) {
        if (userRev == null) {
            throw new IllegalArgumentException("Null userRev");
        }
        if (rootFile == null) {
            throw new IllegalArgumentException("Null rootFile");
        }
        this.userRev = userRev;
        this.virtualFile = rootFile;
        this.contentId = contentId;
        AbstractBundle bundleState = userRev.getBundleState();
        String symbolicName = bundleState.getSymbolicName();
        if (symbolicName != null) {
            symbolicName = symbolicName.replace(':', '.');
            symbolicName = symbolicName.replace('-', '.');
        } else {
            symbolicName = "anonymous";
        }
        long bundleId = bundleState.getBundleId();
        int revisionId = userRev.getRevisionId();
        this.identity = symbolicName + "-" + bundleId + "-" + revisionId + "-" + contentId;
    }

    public static RevisionContent findRevisionContent(BundleManager bundleManager, String identity) {
        if (identity == null) {
            throw new IllegalArgumentException("Null identity");
        }
        String[] parts = identity.split("-");
        if (parts.length != 4) {
            throw new IllegalArgumentException("Invalid identity: " + identity);
        }
        long bundleId = Long.parseLong(parts[1]);
        int revisionId = Integer.parseInt(parts[2]);
        int contentId = Integer.parseInt(parts[3]);
        AbstractBundle bundleState = bundleManager.getBundleById(bundleId);
        if (bundleState == null) {
            return null;
        }
        AbstractRevision bundleRev = bundleState.getRevisionById(revisionId);
        if (bundleRev == null) {
            return null;
        }
        AbstractUserRevision userRev = AbstractUserRevision.assertUserRevision(bundleRev);
        RevisionContent revContent = userRev.getContentById(contentId);
        return revContent;
    }

    public int getContentId() {
        return this.contentId;
    }

    public String getIdentity() {
        return this.identity;
    }

    public AbstractUserRevision getRevision() {
        return this.userRev;
    }

    public VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    @Override
    public URL getEntry(String path) {
        try {
            VirtualFile child = this.virtualFile.getChild(path);
            return child != null ? this.getBundleURL(child) : null;
        }
        catch (IOException ex) {
            log.errorf((Throwable)ex, "Cannot get entry: %s", (Object)path);
            return null;
        }
    }

    @Override
    public Enumeration<URL> findEntries(String path, String pattern, boolean recurse) {
        try {
            Enumeration urls = this.virtualFile.findEntries(path, pattern, recurse);
            return this.getBundleURLs(urls);
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public Enumeration<String> getEntryPaths(String path) {
        try {
            Enumeration entryPaths = this.virtualFile.getEntryPaths(path);
            if (entryPaths != null && entryPaths.hasMoreElements()) {
                return entryPaths;
            }
            return null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public void close() {
        VFSUtils.safeClose((Closeable)this.virtualFile);
    }

    private Enumeration<URL> getBundleURLs(Enumeration<URL> urls) throws IOException {
        if (urls == null) {
            return null;
        }
        if (!urls.hasMoreElements()) {
            return null;
        }
        Vector<URL> result = new Vector<URL>();
        while (urls.hasMoreElements()) {
            VirtualFile child = AbstractVFS.toVirtualFile((URL)urls.nextElement());
            result.add(this.getBundleURL(child));
        }
        return result.elements();
    }

    public URL getBundleURL(final VirtualFile child) throws IOException {
        final String orgPath = child.getPathName();
        URLStreamHandler streamHandler = new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL url) throws IOException {
                String path = url.getPath();
                VirtualFile real = orgPath.equals(path) ? child : RevisionContent.this.virtualFile.getChild(path);
                return real.toURL().openConnection();
            }
        };
        String rootPath = this.virtualFile.getPathName();
        String pathName = child.getPathName().substring(rootPath.length());
        StringBuilder path = new StringBuilder(pathName.length() + 2);
        if (!pathName.startsWith("/")) {
            path.append('/');
        }
        path.append(pathName);
        if (child.isDirectory() && path.charAt(path.length() - 1) != '/') {
            path.append('/');
        }
        return new URL("bundle", this.identity, -1, path.toString(), streamHandler);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RevisionContent)) {
            return false;
        }
        RevisionContent other = (RevisionContent)obj;
        return this.identity.equals(other.identity);
    }

    public String toString() {
        return "[id=" + this.identity + ",vfile=" + this.virtualFile + "]";
    }
}

