/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.loading;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.Resource;
import org.jboss.osgi.framework.bundle.AbstractBundle;
import org.jboss.osgi.framework.bundle.AbstractRevision;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.bundle.HostBundle;
import org.jboss.osgi.framework.loading.URLResource;
import org.jboss.osgi.framework.plugin.ModuleManagerPlugin;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.resolver.XPackageCapability;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.jboss.osgi.vfs.VFSUtils;

public class HostBundleFallbackLoader
implements LocalLoader {
    private static final Logger log = Logger.getLogger(HostBundleFallbackLoader.class);
    private static ThreadLocal<Map<String, AtomicInteger>> dynamicLoadAttempts;
    private final ModuleManagerPlugin moduleManager;
    private final BundleManager bundleManager;
    private final ModuleIdentifier identifier;
    private final Set<String> importedPaths;

    public HostBundleFallbackLoader(HostBundle hostBundle, ModuleIdentifier identifier, Set<String> importedPaths) {
        if (hostBundle == null) {
            throw new IllegalArgumentException("Null hostBundle");
        }
        if (identifier == null) {
            throw new IllegalArgumentException("Null identifier");
        }
        if (importedPaths == null) {
            throw new IllegalArgumentException("Null importedPaths");
        }
        this.identifier = identifier;
        this.importedPaths = importedPaths;
        this.bundleManager = hostBundle.getBundleManager();
        this.moduleManager = this.bundleManager.getPlugin(ModuleManagerPlugin.class);
    }

    public Class<?> loadClassLocal(String className, boolean resolve) {
        List<XPackageRequirement> matchingPatterns = this.findMatchingPatterns(className);
        if (matchingPatterns.isEmpty()) {
            return null;
        }
        String pathName = className.replace('.', '/') + ".class";
        Module module = this.findModuleDynamically(pathName, matchingPatterns);
        if (module == null) {
            return null;
        }
        ModuleClassLoader moduleClassLoader = module.getClassLoader();
        try {
            return moduleClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            log.tracef("Cannot load class [%s] from module: %s", (Object)className, (Object)module);
            return null;
        }
    }

    public List<Resource> loadResourceLocal(String resName) {
        List<XPackageRequirement> matchingPatterns;
        if (resName.startsWith("/")) {
            resName = resName.substring(1);
        }
        if ((matchingPatterns = this.findMatchingPatterns(resName)).isEmpty()) {
            return Collections.emptyList();
        }
        Module module = this.findModuleDynamically(resName, matchingPatterns);
        if (module == null) {
            return Collections.emptyList();
        }
        URL resURL = module.getExportedResource(resName);
        if (resURL == null) {
            log.tracef("Cannot load resource [%s] from module: %s", (Object)resName, (Object)module);
            return Collections.emptyList();
        }
        return Collections.singletonList(new URLResource(resURL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Module findModuleDynamically(String resName, List<XPackageRequirement> matchingPatterns) {
        String path = resName.substring(0, resName.lastIndexOf(47));
        if (this.importedPaths.contains(path)) {
            return null;
        }
        if (dynamicLoadAttempts == null) {
            dynamicLoadAttempts = new ThreadLocal();
        }
        Map<String, AtomicInteger> mapping = dynamicLoadAttempts.get();
        boolean removeThreadLocalMapping = false;
        try {
            AtomicInteger recursiveDepth;
            if (mapping == null) {
                mapping = new HashMap<String, AtomicInteger>();
                dynamicLoadAttempts.set(mapping);
                removeThreadLocalMapping = true;
            }
            if ((recursiveDepth = mapping.get(resName)) == null) {
                recursiveDepth = new AtomicInteger();
                mapping.put(resName, recursiveDepth);
            }
            if (recursiveDepth.incrementAndGet() == 1) {
                Module module = this.findInResolvedModules(resName, matchingPatterns);
                if (module != null && !module.getIdentifier().equals(this.identifier)) {
                    Module module2 = module;
                    return module2;
                }
                module = this.findInUnresolvedModules(resName, matchingPatterns);
                if (module != null && !module.getIdentifier().equals(this.identifier)) {
                    Module module3 = module;
                    return module3;
                }
            }
        }
        finally {
            if (removeThreadLocalMapping) {
                dynamicLoadAttempts.remove();
            } else {
                AtomicInteger recursiveDepth = mapping.get(resName);
                if (recursiveDepth.decrementAndGet() == 0) {
                    mapping.remove(resName);
                }
            }
        }
        return null;
    }

    private List<XPackageRequirement> findMatchingPatterns(String resName) {
        AbstractRevision bundleRev = this.moduleManager.getBundleRevision(this.identifier);
        XModule resModule = bundleRev.getResolverModule();
        List dynamicRequirements = resModule.getDynamicPackageRequirements();
        String pathName = VFSUtils.getPathFromClassName((String)resName);
        List packageCapabilities = resModule.getPackageCapabilities();
        for (XPackageCapability packageCap : packageCapabilities) {
            String packagePath = packageCap.getName().replace('.', '/');
            if (!pathName.equals(packagePath)) continue;
            return Collections.emptyList();
        }
        ArrayList<XPackageRequirement> foundMatch = new ArrayList<XPackageRequirement>();
        for (XPackageRequirement dynreq : dynamicRequirements) {
            String pattern = dynreq.getName();
            if (pattern.equals("*")) {
                foundMatch.add(dynreq);
                continue;
            }
            String patternPath = this.getPatternPath(pattern);
            if (!pathName.startsWith(patternPath)) continue;
            foundMatch.add(dynreq);
        }
        if (!foundMatch.isEmpty()) {
            log.tracef("Found match for path [%s] with Dynamic-ImportPackage pattern: %s", (Object)resName, foundMatch);
        } else {
            log.tracef("Class [%s] does not match Dynamic-ImportPackage patterns", (Object)resName);
        }
        return foundMatch;
    }

    private Module findInResolvedModules(String resName, List<XPackageRequirement> matchingPatterns) {
        log.tracef("Attempt to find path dynamically in resolved modules ...", new Object[0]);
        for (ModuleIdentifier candidateId : this.moduleManager.getModuleIdentifiers()) {
            Module candidate = this.moduleManager.getModule(candidateId);
            if (!this.isValidCandidate(resName, matchingPatterns, candidate)) continue;
            return candidate;
        }
        return null;
    }

    private Module findInUnresolvedModules(String resName, List<XPackageRequirement> matchingPatterns) {
        log.tracef("Attempt to find path dynamically in unresolved modules ...", new Object[0]);
        for (AbstractBundle aux : this.bundleManager.getBundles()) {
            ModuleIdentifier candidateId;
            Module candidate;
            AbstractBundle bundle;
            if (aux.getState() != 2 || !(bundle = AbstractBundle.assertBundleState(aux)).ensureResolved(false) || !this.isValidCandidate(resName, matchingPatterns, candidate = this.moduleManager.getModule(candidateId = bundle.getModuleIdentifier()))) continue;
            return candidate;
        }
        return null;
    }

    private boolean isValidCandidate(String resName, List<XPackageRequirement> matchingPatterns, Module candidate) {
        ModuleIdentifier candidateId = candidate.getIdentifier();
        if (candidateId.equals(this.identifier)) {
            return false;
        }
        log.tracef("Attempt to find path dynamically [%s] in %s ...", (Object)resName, (Object)candidateId);
        URL resURL = candidate.getExportedResource(resName);
        if (resURL == null) {
            return false;
        }
        log.tracef("Found path [%s] in %s", (Object)resName, (Object)candidate);
        AbstractRevision bundleRevision = this.moduleManager.getBundleRevision(candidateId);
        XModule resModule = bundleRevision.getResolverModule();
        for (XPackageRequirement pattern : matchingPatterns) {
            XPackageCapability candidateCap = this.getCandidateCapability(resModule, pattern);
            if (candidateCap == null) continue;
            return true;
        }
        return false;
    }

    private XPackageCapability getCandidateCapability(XModule resModule, XPackageRequirement packageReq) {
        for (XPackageCapability packageCap : resModule.getPackageCapabilities()) {
            if (!packageReq.match(packageCap)) continue;
            log.tracef("Matching package capability: %s", (Object)packageCap);
            return packageCap;
        }
        return null;
    }

    private String getPatternPath(String pattern) {
        String patternPath = pattern;
        if (pattern.endsWith(".*")) {
            patternPath = pattern.substring(0, pattern.length() - 2);
        }
        patternPath = patternPath.replace('.', '/');
        return patternPath;
    }
}

