/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.loading;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.logging.Logger;
import org.jboss.modules.ClassSpec;
import org.jboss.modules.PackageSpec;
import org.jboss.modules.Resource;
import org.jboss.modules.ResourceLoader;
import org.jboss.osgi.framework.loading.NativeLibraryProvider;

public class NativeResourceLoader
implements ResourceLoader {
    private static final Logger log = Logger.getLogger(NativeResourceLoader.class);
    private volatile List<NativeLibraryProvider> nativeLibraries;

    public void addNativeLibrary(NativeLibraryProvider libProvider) {
        if (this.nativeLibraries == null) {
            this.nativeLibraries = new CopyOnWriteArrayList<NativeLibraryProvider>();
        }
        this.nativeLibraries.add(libProvider);
    }

    public String getLibrary(String libname) {
        File libfile;
        List<NativeLibraryProvider> list = this.nativeLibraries;
        if (list == null) {
            return null;
        }
        NativeLibraryProvider libProvider = null;
        for (NativeLibraryProvider aux : list) {
            if (!libname.equals(aux.getLibraryName())) continue;
            libProvider = aux;
            break;
        }
        if (libProvider == null) {
            return null;
        }
        try {
            libfile = libProvider.getLibraryLocation();
        }
        catch (IOException ex) {
            log.errorf((Throwable)ex, "Cannot privide native library location for: %s", (Object)libname);
            return null;
        }
        return libfile.getAbsolutePath();
    }

    public String getRootName() {
        return "??osgi-native??";
    }

    public ClassSpec getClassSpec(String name) throws IOException {
        return null;
    }

    public PackageSpec getPackageSpec(String name) throws IOException {
        return null;
    }

    public Resource getResource(String name) {
        return null;
    }

    public Collection<String> getPaths() {
        return Collections.emptyList();
    }
}

