/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.plugin;

import java.util.Dictionary;
import java.util.Properties;
import org.jboss.osgi.deployment.deployer.DeployerService;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.plugin.AbstractPlugin;
import org.jboss.osgi.framework.plugin.DeployerServicePlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;

public abstract class AbstractDeployerServicePlugin
extends AbstractPlugin
implements DeployerServicePlugin {
    private DeployerService delegate;
    private ServiceRegistration registration;

    public AbstractDeployerServicePlugin(BundleManager bundleManager) {
        super(bundleManager);
    }

    @Override
    public void initPlugin() {
        BundleContext context = this.getBundleManager().getSystemContext();
        this.delegate = this.getDeployerService(context);
        Properties props = new Properties();
        props.put("provider", "system");
        this.registration = context.registerService(DeployerService.class.getName(), (Object)this, (Dictionary)props);
    }

    protected abstract DeployerService getDeployerService(BundleContext var1);

    @Override
    public void stopPlugin() {
        this.registration.unregister();
        this.registration = null;
        this.delegate = null;
    }

    public Bundle deploy(Deployment bundleDep) throws BundleException {
        this.assertServiceStarted();
        return this.delegate.deploy(bundleDep);
    }

    public Bundle undeploy(Deployment bundleDep) throws BundleException {
        this.assertServiceStarted();
        return this.delegate.undeploy(bundleDep);
    }

    public void deploy(Deployment[] bundleDeps) throws BundleException {
        this.assertServiceStarted();
        this.delegate.deploy(bundleDeps);
    }

    public void undeploy(Deployment[] bundleDeps) throws BundleException {
        this.assertServiceStarted();
        this.delegate.undeploy(bundleDeps);
    }

    private void assertServiceStarted() {
        if (this.delegate == null) {
            throw new IllegalStateException("DeployerService not started");
        }
    }
}

