/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.plugin.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.bundle.BundleStorageState;
import org.jboss.osgi.framework.plugin.AbstractPlugin;
import org.jboss.osgi.framework.plugin.BundleStoragePlugin;
import org.jboss.osgi.vfs.VFSUtils;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;

public class BundleStoragePluginImpl
extends AbstractPlugin
implements BundleStoragePlugin {
    final Logger log = Logger.getLogger(BundleStoragePluginImpl.class);
    private File storageArea;

    public BundleStoragePluginImpl(BundleManager bundleManager) {
        super(bundleManager);
    }

    @Override
    public BundleStorageState createStorageState(long bundleId, String location, VirtualFile rootFile) throws IOException {
        int revision;
        if (location == null) {
            throw new IllegalArgumentException("Null location");
        }
        String bundlePath = this.getStorageDir(bundleId).getAbsolutePath();
        File bundleDir = new File(bundlePath);
        bundleDir.mkdirs();
        Properties props = BundleStorageState.loadProperties(bundleDir);
        String previousRev = props.getProperty("BundleRev");
        int n = revision = previousRev != null ? Integer.parseInt(previousRev) + 1 : 0;
        if (rootFile != null) {
            File revFile = new File(bundlePath + "/bundle-" + bundleId + "-rev-" + revision + ".jar");
            FileOutputStream output = new FileOutputStream(revFile);
            VFSUtils.copyStream((InputStream)rootFile.openStream(), (OutputStream)output);
            output.close();
            props.put("BundleFile", revFile.getName());
        }
        props.put("Location", location);
        props.put("BundleId", new Long(bundleId).toString());
        props.put("BundleRev", new Integer(revision).toString());
        props.put("LastModified", new Long(System.currentTimeMillis()).toString());
        return BundleStorageState.createBundleStorageState(bundleDir, rootFile, props);
    }

    @Override
    public List<BundleStorageState> getBundleStorageStates() throws IOException {
        ArrayList<BundleStorageState> states = new ArrayList<BundleStorageState>();
        File[] storageDirs = this.getStorageArea().listFiles();
        if (storageDirs != null) {
            for (File bundleDir : storageDirs) {
                BundleStorageState storageState = BundleStorageState.createFromStorage(bundleDir);
                states.add(storageState);
            }
        }
        return Collections.unmodifiableList(states);
    }

    @Override
    public File getDataFile(Bundle bundle, String filename) {
        File bundleDir = this.getStorageDir(bundle.getBundleId());
        File dataFile = new File(bundleDir.getAbsolutePath() + "/" + filename);
        dataFile.getParentFile().mkdirs();
        String filePath = dataFile.getAbsolutePath();
        try {
            filePath = dataFile.getCanonicalPath();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return new File(filePath);
    }

    @Override
    public File getStorageDir(long bundleId) {
        File bundleDir = new File(this.getStorageArea() + "/bundle-" + bundleId);
        if (!bundleDir.exists()) {
            bundleDir.mkdirs();
        }
        String filePath = bundleDir.getAbsolutePath();
        try {
            filePath = bundleDir.getCanonicalPath();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return new File(filePath);
    }

    @Override
    public void cleanStorage() {
        File storage = this.getStorageArea();
        this.log.tracef("Deleting from storage: %s", (Object)storage.getAbsolutePath());
        try {
            this.deleteRecursively(storage);
        }
        catch (IOException ex) {
            this.log.errorf((Throwable)ex, "Cannot delete storage area", new Object[0]);
        }
    }

    private File getStorageArea() {
        if (this.storageArea == null) {
            String dirName = (String)this.getBundleManager().getProperty("org.osgi.framework.storage");
            if (dirName == null) {
                try {
                    File storageDir = new File("./osgi-store");
                    dirName = storageDir.getCanonicalPath();
                }
                catch (IOException ex) {
                    this.log.errorf((Throwable)ex, "Cannot create storage area", new Object[0]);
                    throw new IllegalStateException("Cannot create storage area");
                }
            }
            this.storageArea = new File(dirName).getAbsoluteFile();
        }
        return this.storageArea;
    }

    private void deleteRecursively(File file) throws IOException {
        if (file.isDirectory()) {
            for (File aux : file.listFiles()) {
                this.deleteRecursively(aux);
            }
        }
        file.delete();
    }
}

