/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.plugin.internal;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.logging.Logger;
import org.jboss.osgi.framework.bundle.AbstractBundle;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.bundle.ServiceState;
import org.jboss.osgi.framework.plugin.AbstractExecutorServicePlugin;
import org.jboss.osgi.framework.plugin.FrameworkEventsPlugin;
import org.jboss.osgi.framework.util.NoFilter;
import org.jboss.osgi.framework.util.RemoveOnlyCollection;
import org.jboss.osgi.spi.util.ConstantsHelper;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.hooks.service.EventHook;
import org.osgi.framework.hooks.service.ListenerHook;

public class FrameworkEventsPluginImpl
extends AbstractExecutorServicePlugin
implements FrameworkEventsPlugin {
    final Logger log = Logger.getLogger(FrameworkEventsPluginImpl.class);
    private boolean active;
    private final Map<AbstractBundle, List<BundleListener>> bundleListeners = new ConcurrentHashMap<AbstractBundle, List<BundleListener>>();
    private final Map<AbstractBundle, List<FrameworkListener>> frameworkListeners = new ConcurrentHashMap<AbstractBundle, List<FrameworkListener>>();
    private final Map<AbstractBundle, List<ServiceListenerRegistration>> serviceListeners = new ConcurrentHashMap<AbstractBundle, List<ServiceListenerRegistration>>();
    private Set<Integer> asyncBundleEvents = new HashSet<Integer>();
    private Set<String> infoEvents = new HashSet<String>();

    public FrameworkEventsPluginImpl(BundleManager bundleManager) {
        super(bundleManager, "Event");
        this.asyncBundleEvents.add(new Integer(1));
        this.asyncBundleEvents.add(new Integer(32));
        this.asyncBundleEvents.add(new Integer(2));
        this.asyncBundleEvents.add(new Integer(4));
        this.asyncBundleEvents.add(new Integer(8));
        this.asyncBundleEvents.add(new Integer(64));
        this.asyncBundleEvents.add(new Integer(16));
        this.infoEvents.add(ConstantsHelper.frameworkEvent((int)4));
        this.infoEvents.add(ConstantsHelper.frameworkEvent((int)2));
        this.infoEvents.add(ConstantsHelper.frameworkEvent((int)16));
        this.infoEvents.add(ConstantsHelper.frameworkEvent((int)32));
        this.infoEvents.add(ConstantsHelper.bundleEvent((int)1));
        this.infoEvents.add(ConstantsHelper.bundleEvent((int)2));
        this.infoEvents.add(ConstantsHelper.bundleEvent((int)4));
        this.infoEvents.add(ConstantsHelper.bundleEvent((int)16));
    }

    @Override
    public void destroyPlugin() {
        this.setActive(false);
        this.bundleListeners.clear();
        this.serviceListeners.clear();
        this.frameworkListeners.clear();
        super.destroyPlugin();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBundleListener(AbstractBundle bundleState, BundleListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        Map<AbstractBundle, List<BundleListener>> map = this.bundleListeners;
        synchronized (map) {
            List<BundleListener> listeners = this.bundleListeners.get(bundleState);
            if (listeners == null) {
                listeners = new CopyOnWriteArrayList<BundleListener>();
                this.bundleListeners.put(bundleState, listeners);
            }
            if (!listeners.contains(listener)) {
                listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBundleListener(AbstractBundle bundleState, BundleListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        Map<AbstractBundle, List<BundleListener>> map = this.bundleListeners;
        synchronized (map) {
            List<BundleListener> listeners = this.bundleListeners.get(bundleState);
            if (listeners != null) {
                if (listeners.size() > 1) {
                    listeners.remove(listener);
                } else {
                    this.removeBundleListeners(bundleState);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBundleListeners(AbstractBundle bundleState) {
        Map<AbstractBundle, List<BundleListener>> map = this.bundleListeners;
        synchronized (map) {
            this.bundleListeners.remove(bundleState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFrameworkListener(AbstractBundle bundleState, FrameworkListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        Map<AbstractBundle, List<FrameworkListener>> map = this.frameworkListeners;
        synchronized (map) {
            List<FrameworkListener> listeners = this.frameworkListeners.get(bundleState);
            if (listeners == null) {
                listeners = new CopyOnWriteArrayList<FrameworkListener>();
                this.frameworkListeners.put(bundleState, listeners);
            }
            if (!listeners.contains(listener)) {
                listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFrameworkListener(AbstractBundle bundleState, FrameworkListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        Map<AbstractBundle, List<FrameworkListener>> map = this.frameworkListeners;
        synchronized (map) {
            List<FrameworkListener> listeners = this.frameworkListeners.get(bundleState);
            if (listeners != null) {
                if (listeners.size() > 1) {
                    listeners.remove(listener);
                } else {
                    this.removeFrameworkListeners(bundleState);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFrameworkListeners(AbstractBundle bundleState) {
        Map<AbstractBundle, List<FrameworkListener>> map = this.frameworkListeners;
        synchronized (map) {
            this.frameworkListeners.remove(bundleState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServiceListener(AbstractBundle bundleState, ServiceListener listener, String filterstr) throws InvalidSyntaxException {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        Map<AbstractBundle, List<ServiceListenerRegistration>> map = this.serviceListeners;
        synchronized (map) {
            List<ServiceListenerRegistration> listeners = this.serviceListeners.get(bundleState);
            if (listeners == null) {
                listeners = new CopyOnWriteArrayList<ServiceListenerRegistration>();
                this.serviceListeners.put(bundleState, listeners);
            }
            this.removeServiceListener(bundleState, listener);
            Filter filter = filterstr != null ? FrameworkUtil.createFilter((String)filterstr) : NoFilter.INSTANCE;
            ServiceListenerRegistration slreg = new ServiceListenerRegistration(bundleState, listener, filter);
            for (ListenerHook hook : this.getServiceListenerHooks()) {
                try {
                    hook.added(Collections.singleton(slreg.getListenerInfo()));
                }
                catch (RuntimeException ex) {
                    this.log.errorf((Throwable)ex, "Error processing ListenerHook: %s", (Object)hook);
                }
            }
            listeners.add(slreg);
        }
    }

    @Override
    public Collection<ListenerHook.ListenerInfo> getServiceListenerInfos(AbstractBundle bundleState) {
        ArrayList<ListenerHook.ListenerInfo> listeners = new ArrayList<ListenerHook.ListenerInfo>();
        for (Map.Entry<AbstractBundle, List<ServiceListenerRegistration>> entry : this.serviceListeners.entrySet()) {
            if (bundleState != null && !bundleState.equals(entry.getKey())) continue;
            for (ServiceListenerRegistration aux : entry.getValue()) {
                ListenerHook.ListenerInfo info = aux.getListenerInfo();
                listeners.add(info);
            }
        }
        return Collections.unmodifiableCollection(listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServiceListener(AbstractBundle bundleState, ServiceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        Map<AbstractBundle, List<ServiceListenerRegistration>> map = this.serviceListeners;
        synchronized (map) {
            ServiceListenerRegistration slreg;
            int index;
            List<ServiceListenerRegistration> listeners = this.serviceListeners.get(bundleState);
            if (listeners != null && (index = listeners.indexOf(slreg = new ServiceListenerRegistration(bundleState, listener, NoFilter.INSTANCE))) >= 0) {
                slreg = listeners.remove(index);
                for (ListenerHook hook : this.getServiceListenerHooks()) {
                    try {
                        ListenerInfoImpl info = (ListenerInfoImpl)slreg.getListenerInfo();
                        info.setRemoved(true);
                        hook.removed(Collections.singleton(info));
                    }
                    catch (RuntimeException ex) {
                        this.log.errorf((Throwable)ex, "Error processing ListenerHook: %s", (Object)hook);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServiceListeners(AbstractBundle bundleState) {
        Map<AbstractBundle, List<ServiceListenerRegistration>> map = this.serviceListeners;
        synchronized (map) {
            Collection<ListenerHook.ListenerInfo> listenerInfos = this.getServiceListenerInfos(bundleState);
            this.serviceListeners.remove(bundleState);
            for (ListenerHook hook : this.getServiceListenerHooks()) {
                try {
                    hook.removed(listenerInfos);
                }
                catch (RuntimeException ex) {
                    this.log.errorf((Throwable)ex, "Error processing ListenerHook: %s", (Object)hook);
                }
            }
        }
    }

    private List<ListenerHook> getServiceListenerHooks() {
        BundleContext context = this.getBundleManager().getSystemContext();
        ServiceReference[] srefs = null;
        try {
            srefs = context.getServiceReferences(ListenerHook.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            // empty catch block
        }
        if (srefs == null) {
            return Collections.emptyList();
        }
        ArrayList<ListenerHook> hooks = new ArrayList<ListenerHook>();
        for (ServiceReference sref : srefs) {
            hooks.add((ListenerHook)context.getService(sref));
        }
        return Collections.unmodifiableList(hooks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireBundleEvent(final AbstractBundle bundleState, final int type) {
        final ArrayList<BundleListener> listeners = new ArrayList<BundleListener>();
        Map<AbstractBundle, List<BundleListener>> map = this.bundleListeners;
        synchronized (map) {
            for (Map.Entry<AbstractBundle, List<BundleListener>> entry : this.bundleListeners.entrySet()) {
                for (BundleListener listener : entry.getValue()) {
                    listeners.add(listener);
                }
            }
        }
        final BundleEventImpl event = new BundleEventImpl(type, bundleState);
        final String typeName = ConstantsHelper.bundleEvent((int)event.getType());
        this.log.tracef("AbstractBundle %s: %s", (Object)typeName, (Object)bundleState);
        if (!this.getBundleManager().isFrameworkActive()) {
            return;
        }
        if (listeners.isEmpty()) {
            return;
        }
        for (BundleListener listener : listeners) {
            try {
                if (!(listener instanceof SynchronousBundleListener)) continue;
                listener.bundleChanged((BundleEvent)event);
            }
            catch (Throwable th) {
                this.log.warnf(th, "Error while firing %s for bundleState: %s", (Object)typeName, (Object)bundleState);
            }
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (FrameworkEventsPluginImpl.this.asyncBundleEvents.contains(type)) {
                    for (BundleListener listener : listeners) {
                        try {
                            if (listener instanceof SynchronousBundleListener) continue;
                            listener.bundleChanged(event);
                        }
                        catch (Throwable th) {
                            FrameworkEventsPluginImpl.this.log.warnf(th, "Error while firing %s for bundleState: ", (Object)typeName, (Object)bundleState);
                        }
                    }
                }
            }
        };
        this.fireEvent(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireFrameworkEvent(final AbstractBundle bundleState, final int type, Throwable th) {
        final ArrayList<FrameworkListener> listeners = new ArrayList<FrameworkListener>();
        Map<AbstractBundle, List<FrameworkListener>> map = this.frameworkListeners;
        synchronized (map) {
            for (Map.Entry<AbstractBundle, List<FrameworkListener>> entry : this.frameworkListeners.entrySet()) {
                for (FrameworkListener listener : entry.getValue()) {
                    listeners.add(listener);
                }
            }
        }
        final FrameworkEventImpl event = new FrameworkEventImpl(type, bundleState, th);
        final String typeName = ConstantsHelper.frameworkEvent((int)event.getType());
        switch (event.getType()) {
            case 2: {
                this.log.errorf(th, "Framwork %s", (Object)typeName);
                break;
            }
            case 16: {
                this.log.warnf(th, "Framwork %s", (Object)typeName);
                break;
            }
            default: {
                this.log.tracef(th, "Framwork %s", (Object)typeName);
            }
        }
        if (!this.getBundleManager().isFrameworkActive()) {
            return;
        }
        if (listeners.isEmpty()) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (FrameworkListener listener : listeners) {
                    try {
                        listener.frameworkEvent(event);
                    }
                    catch (RuntimeException ex) {
                        FrameworkEventsPluginImpl.this.log.warnf((Throwable)ex, "Error while firing %s for framework", (Object)typeName);
                        if (type == 2) continue;
                        FrameworkEventsPluginImpl.this.fireFrameworkEvent(bundleState, 2, ex);
                    }
                    catch (Throwable th) {
                        FrameworkEventsPluginImpl.this.log.warnf(th, "Error while firing %s for framework", (Object)typeName);
                    }
                }
            }
        };
        this.fireEvent(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireServiceEvent(AbstractBundle bundleState, int type, ServiceState serviceState) {
        List<ServiceListenerRegistration> listenerRegs = new ArrayList<ServiceListenerRegistration>();
        Map<AbstractBundle, List<ServiceListenerRegistration>> map = this.serviceListeners;
        synchronized (map) {
            for (Map.Entry<AbstractBundle, List<ServiceListenerRegistration>> entry : this.serviceListeners.entrySet()) {
                for (ServiceListenerRegistration listener : entry.getValue()) {
                    BundleContext context = listener.getBundleContext();
                    if (context == null) continue;
                    listenerRegs.add(listener);
                }
            }
        }
        ServiceEventImpl event = new ServiceEventImpl(type, serviceState);
        String typeName = ConstantsHelper.serviceEvent((int)event.getType());
        this.log.tracef("Service %s: %s", (Object)typeName, (Object)serviceState);
        if (!this.getBundleManager().isFrameworkActive()) {
            return;
        }
        if ((listenerRegs = this.processEventHooks(listenerRegs, event)).isEmpty()) {
            return;
        }
        for (ServiceListenerRegistration listenerReg : listenerRegs) {
            if (!listenerReg.isAllServiceListener()) {
                String[] clazzes;
                boolean assignableToOwner = true;
                AbstractBundle owner = listenerReg.getBundleState();
                for (String clazz : clazzes = (String[])serviceState.getProperty("objectClass")) {
                    if (serviceState.isAssignableTo(owner, clazz)) continue;
                    assignableToOwner = false;
                    break;
                }
                if (!assignableToOwner) continue;
            }
            try {
                String filterstr = listenerReg.filter.toString();
                if (listenerReg.filter.match((ServiceReference)serviceState)) {
                    listenerReg.listener.serviceChanged((ServiceEvent)event);
                    continue;
                }
                if (filterstr == null || 2 != event.getType() || !listenerReg.filter.match(serviceState.getPreviousProperties())) continue;
                event = new ServiceEventImpl(8, serviceState);
                listenerReg.listener.serviceChanged((ServiceEvent)event);
            }
            catch (Throwable th) {
                this.log.warnf(th, "Error while firing %s for service: %s", (Object)typeName, (Object)serviceState);
            }
        }
    }

    private List<ServiceListenerRegistration> processEventHooks(List<ServiceListenerRegistration> listeners, ServiceEvent event) {
        Collection<BundleContext> contexts = new HashSet();
        for (ServiceListenerRegistration listener : listeners) {
            BundleContext context = listener.getBundleContext();
            if (context == null) continue;
            contexts.add(context);
        }
        contexts = new RemoveOnlyCollection(contexts);
        List<EventHook> eventHooks = this.getEventHooks();
        for (EventHook hook : eventHooks) {
            try {
                hook.event(event, contexts);
            }
            catch (Exception ex) {
                this.log.warnf((Throwable)ex, "Error while calling EventHook: %s", (Object)hook);
            }
        }
        if (contexts.size() != listeners.size()) {
            Iterator<ServiceListenerRegistration> it = listeners.iterator();
            while (it.hasNext()) {
                ServiceListenerRegistration slreg = it.next();
                if (contexts.contains(slreg.getBundleContext())) continue;
                it.remove();
            }
        }
        return listeners;
    }

    private List<EventHook> getEventHooks() {
        ArrayList<EventHook> hooks = new ArrayList<EventHook>();
        BundleContext context = this.getBundleManager().getSystemContext();
        ServiceReference[] srefs = null;
        try {
            srefs = context.getServiceReferences(EventHook.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            // empty catch block
        }
        if (srefs != null) {
            ArrayList<ServiceReference> sortedRefs = new ArrayList<ServiceReference>(Arrays.asList(srefs));
            Collections.reverse(sortedRefs);
            for (ServiceReference sref : sortedRefs) {
                hooks.add((EventHook)context.getService(sref));
            }
        }
        return hooks;
    }

    private void fireEvent(Runnable runnable) {
        this.getExecutorService().execute(runnable);
    }

    static class ServiceEventImpl
    extends ServiceEvent {
        private static final long serialVersionUID = 62018288275708239L;

        public ServiceEventImpl(int type, ServiceState serviceState) {
            super(type, serviceState.getReference());
        }

        public String toString() {
            return "ServiceEvent[type=" + ConstantsHelper.serviceEvent((int)this.getType()) + ",source=" + this.getSource() + "]";
        }
    }

    static class BundleEventImpl
    extends BundleEvent {
        private static final long serialVersionUID = -2705304702665185935L;

        public BundleEventImpl(int type, AbstractBundle bundleState) {
            super(type, bundleState.getBundleWrapper());
        }

        public String toString() {
            return "BundleEvent[type=" + ConstantsHelper.bundleEvent((int)this.getType()) + ",source=" + this.getSource() + "]";
        }
    }

    static class FrameworkEventImpl
    extends FrameworkEvent {
        private static final long serialVersionUID = 6505331543651318189L;

        public FrameworkEventImpl(int type, AbstractBundle bundleState, Throwable throwable) {
            super(type, bundleState.getBundleWrapper(), throwable);
        }

        public String toString() {
            return "FrameworkEvent[type=" + ConstantsHelper.frameworkEvent((int)this.getType()) + ",source=" + this.getSource() + "]";
        }
    }

    static class ListenerInfoImpl
    implements ListenerHook.ListenerInfo {
        private BundleContext context;
        private ServiceListener listener;
        private String filter;
        private boolean removed;

        ListenerInfoImpl(ServiceListenerRegistration slreg) {
            this.context = slreg.bundleState.getBundleContext();
            this.listener = slreg.listener;
            this.filter = slreg.filter.toString();
        }

        public BundleContext getBundleContext() {
            return this.context;
        }

        public String getFilter() {
            return this.filter;
        }

        public boolean isRemoved() {
            return this.removed;
        }

        public void setRemoved(boolean removed) {
            this.removed = removed;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public String toString() {
            String className = this.listener.getClass().getName();
            return "ListenerInfo[" + this.context + "," + className + "," + this.removed + "]";
        }
    }

    static class ServiceListenerRegistration {
        private AbstractBundle bundleState;
        private ServiceListener listener;
        private Filter filter;
        private ListenerHook.ListenerInfo info;
        AccessControlContext accessControlContext;

        ServiceListenerRegistration(AbstractBundle bundleState, ServiceListener listener, Filter filter) {
            if (bundleState == null) {
                throw new IllegalArgumentException("Null bundleState");
            }
            if (listener == null) {
                throw new IllegalArgumentException("Null listener");
            }
            if (filter == null) {
                throw new IllegalArgumentException("Null filter");
            }
            this.bundleState = bundleState;
            this.listener = listener;
            this.filter = filter;
            this.info = new ListenerInfoImpl(this);
            if (System.getSecurityManager() != null) {
                this.accessControlContext = AccessController.getContext();
            }
        }

        AbstractBundle getBundleState() {
            return this.bundleState;
        }

        BundleContext getBundleContext() {
            return this.bundleState.getBundleContext();
        }

        ListenerHook.ListenerInfo getListenerInfo() {
            return this.info;
        }

        boolean isAllServiceListener() {
            return this.listener instanceof AllServiceListener;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ServiceListenerRegistration)) {
                return false;
            }
            ServiceListenerRegistration other = (ServiceListenerRegistration)obj;
            return other.listener.equals(this.listener);
        }

        public String toString() {
            String className = this.listener.getClass().getName();
            return "ServiceListener[" + this.bundleState + "," + className + "," + this.filter + "]";
        }
    }
}

