/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.plugin.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoaderFactory;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.modules.log.JDKModuleLogger;
import org.jboss.modules.log.ModuleLogger;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.bundle.AbstractBundle;
import org.jboss.osgi.framework.bundle.AbstractRevision;
import org.jboss.osgi.framework.bundle.AbstractUserBundle;
import org.jboss.osgi.framework.bundle.AbstractUserRevision;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.bundle.FragmentRevision;
import org.jboss.osgi.framework.bundle.HostBundle;
import org.jboss.osgi.framework.bundle.HostRevision;
import org.jboss.osgi.framework.bundle.OSGiModuleLoader;
import org.jboss.osgi.framework.bundle.RevisionContent;
import org.jboss.osgi.framework.bundle.SystemBundle;
import org.jboss.osgi.framework.loading.HostBundleFallbackLoader;
import org.jboss.osgi.framework.loading.HostBundleModuleClassLoader;
import org.jboss.osgi.framework.loading.LazyActivationLocalLoader;
import org.jboss.osgi.framework.loading.NativeResourceLoader;
import org.jboss.osgi.framework.loading.RevisionContentResourceLoader;
import org.jboss.osgi.framework.plugin.AbstractPlugin;
import org.jboss.osgi.framework.plugin.ModuleManagerPlugin;
import org.jboss.osgi.framework.plugin.SystemModuleProviderPlugin;
import org.jboss.osgi.framework.plugin.SystemPackagesPlugin;
import org.jboss.osgi.framework.plugin.internal.NativeCodePluginImpl;
import org.jboss.osgi.metadata.ActivationPolicyMetaData;
import org.jboss.osgi.metadata.NativeLibrary;
import org.jboss.osgi.metadata.NativeLibraryMetaData;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.resolver.XModuleIdentity;
import org.jboss.osgi.resolver.XPackageCapability;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.jboss.osgi.resolver.XRequireBundleRequirement;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XWire;
import org.jboss.osgi.vfs.VFSUtils;
import org.osgi.framework.Bundle;

public class ModuleManagerPluginImpl
extends AbstractPlugin
implements ModuleManagerPlugin {
    final Logger log = Logger.getLogger(ModuleManagerPluginImpl.class);
    private OSGiModuleLoader moduleLoader;

    public ModuleManagerPluginImpl(BundleManager bundleManager) {
        super(bundleManager);
    }

    @Override
    public void initPlugin() {
        if (this.getBundleManager().getIntegrationMode() == BundleManager.IntegrationMode.STANDALONE) {
            Module.setModuleLogger((ModuleLogger)new JDKModuleLogger());
        }
        this.moduleLoader = new OSGiModuleLoader(this.getBundleManager());
        SystemModuleProviderPlugin plugin = this.getBundleManager().getPlugin(SystemModuleProviderPlugin.class);
        SystemBundle systemBundle = this.getBundleManager().getSystemBundle();
        try {
            plugin.createSystemModule(this.moduleLoader, systemBundle);
            plugin.createFrameworkModule(this.moduleLoader, systemBundle);
        }
        catch (ModuleLoadException ex) {
            throw new IllegalStateException("Cannot create system/framework module", ex);
        }
    }

    @Override
    public void destroyPlugin() {
        this.moduleLoader = null;
    }

    @Override
    public OSGiModuleLoader getModuleLoader() {
        return this.moduleLoader;
    }

    @Override
    public ModuleIdentifier getModuleIdentifier(XModule resModule) {
        ModuleIdentifier identifier;
        if (resModule.isFragment()) {
            throw new IllegalArgumentException("A fragment is not a module");
        }
        ModuleIdentifier id = (ModuleIdentifier)resModule.getAttachment(ModuleIdentifier.class);
        if (id != null) {
            return id;
        }
        Module module = (Module)resModule.getAttachment(Module.class);
        ModuleIdentifier moduleIdentifier = identifier = module != null ? module.getIdentifier() : null;
        if (identifier == null) {
            XModuleIdentity moduleId = resModule.getModuleId();
            if ("system.bundle".equals(moduleId.getName())) {
                identifier = this.getFrameworkModule().getIdentifier();
            }
            if (identifier == null) {
                String slot = moduleId.getVersion().toString();
                int revision = moduleId.getRevision();
                if (revision > 0) {
                    slot = slot + "-rev" + revision;
                }
                String name = "jbosgi." + moduleId.getName();
                identifier = ModuleIdentifier.create((String)name, (String)slot);
            }
            resModule.addAttachment(ModuleIdentifier.class, (Object)identifier);
        }
        return identifier;
    }

    @Override
    public Set<ModuleIdentifier> getModuleIdentifiers() {
        return this.moduleLoader.getModuleIdentifiers();
    }

    @Override
    public Module getModule(ModuleIdentifier identifier) {
        return this.moduleLoader.getModule(identifier);
    }

    @Override
    public AbstractRevision getBundleRevision(ModuleIdentifier identifier) {
        return this.moduleLoader.getBundleRevision(identifier);
    }

    @Override
    public AbstractBundle getBundleState(ModuleIdentifier identifier) {
        return this.moduleLoader.getBundleState(identifier);
    }

    @Override
    public ModuleIdentifier addModule(XModule resModule) {
        if (resModule == null) {
            throw new IllegalArgumentException("Null module");
        }
        Bundle bundle = (Bundle)resModule.getAttachment(Bundle.class);
        AbstractBundle bundleState = AbstractBundle.assertBundleState(bundle);
        if (bundleState.isFragment()) {
            throw new IllegalStateException("Fragments cannot be added: " + bundleState);
        }
        Module module = (Module)resModule.getAttachment(Module.class);
        if (module != null) {
            AbstractRevision bundleRev = (AbstractRevision)resModule.getAttachment(AbstractRevision.class);
            this.moduleLoader.addModule(bundleRev, module);
            return module.getIdentifier();
        }
        ModuleIdentifier identifier = "system.bundle".equals(resModule.getModuleId().getName()) ? this.getFrameworkModule().getIdentifier() : this.createHostModule(resModule);
        return identifier;
    }

    private ModuleIdentifier createHostModule(XModule resModule) {
        if (resModule == null) {
            throw new IllegalArgumentException("Null resModule");
        }
        Bundle bundle = (Bundle)resModule.getAttachment(Bundle.class);
        HostBundle hostBundle = HostBundle.assertBundleState(bundle);
        List<RevisionContent> contentRoots = hostBundle.getContentRoots();
        ModuleSpec moduleSpec = (ModuleSpec)resModule.getAttachment(ModuleSpec.class);
        if (moduleSpec == null) {
            ModuleIdentifier identifier = this.getModuleIdentifier(resModule);
            ModuleSpec.Builder specBuilder = ModuleSpec.build((ModuleIdentifier)identifier);
            ArrayList<DependencySpec> moduleDependencies = new ArrayList<DependencySpec>();
            SystemPackagesPlugin plugin = this.getBundleManager().getPlugin(SystemPackagesPlugin.class);
            Module systemModule = this.getSystemModule();
            ModuleIdentifier systemIdentifier = systemModule.getIdentifier();
            ModuleLoader systemModuleLoader = systemModule.getModuleLoader();
            PathFilter systemPackagesFilter = plugin.getSystemPackageFilter();
            moduleDependencies.add(DependencySpec.createModuleDependencySpec((PathFilter)systemPackagesFilter, (PathFilter)PathFilters.acceptAll(), (ModuleLoader)systemModuleLoader, (ModuleIdentifier)systemIdentifier, (boolean)false));
            LinkedHashMap<XModule, ModuleDependencyHolder> specHolderMap = new LinkedHashMap<XModule, ModuleDependencyHolder>();
            this.processModuleWires(resModule.getWires(), specHolderMap);
            HashSet allPaths = new HashSet();
            List<FragmentRevision> fragRevs = hostBundle.getCurrentRevision().getAttachedFragments();
            for (FragmentRevision fragRev : fragRevs) {
                List fragWires = fragRev.getResolverModule().getWires();
                this.processModuleWires(fragWires, specHolderMap);
            }
            for (ModuleDependencyHolder holder : specHolderMap.values()) {
                moduleDependencies.add(holder.create());
            }
            for (DependencySpec dep : moduleDependencies) {
                specBuilder.addDependency(dep);
            }
            for (RevisionContent revContent : contentRoots) {
                RevisionContentResourceLoader resLoader = new RevisionContentResourceLoader(revContent);
                specBuilder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)resLoader));
                allPaths.addAll(resLoader.getPaths());
            }
            for (FragmentRevision fragRev : fragRevs) {
                for (RevisionContent revContent : fragRev.getContentList()) {
                    RevisionContentResourceLoader resLoader = new RevisionContentResourceLoader(revContent);
                    specBuilder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)resLoader));
                    allPaths.addAll(resLoader.getPaths());
                }
            }
            HashSet<String> importedPaths = new HashSet<String>();
            for (ModuleDependencyHolder holder : specHolderMap.values()) {
                Set<String> paths = holder.getImportPaths();
                if (paths == null) continue;
                importedPaths.addAll(paths);
            }
            if (hostBundle.isActivationLazy()) {
                HashSet<String> lazyPaths = new HashSet<String>();
                PathFilter lazyFilter = this.getLazyPackagesFilter(hostBundle);
                for (String path : allPaths) {
                    if (!lazyFilter.accept(path)) continue;
                    lazyPaths.add(path);
                }
                this.log.tracef("Module [%s] lazy filter: %s", (Object)identifier, (Object)lazyFilter);
                LazyActivationLocalLoader localLoader = new LazyActivationLocalLoader(hostBundle, identifier, moduleDependencies, lazyFilter);
                specBuilder.addDependency(DependencySpec.createLocalDependencySpec((LocalLoader)localLoader, lazyPaths, (boolean)true));
                PathFilter eagerFilter = PathFilters.not((PathFilter)lazyFilter);
                PathFilter exportFilter = PathFilters.acceptAll();
                this.log.tracef("Module [%s] eager filter: %s", (Object)identifier, (Object)eagerFilter);
                specBuilder.addDependency(DependencySpec.createLocalDependencySpec((PathFilter)eagerFilter, (PathFilter)exportFilter));
            } else {
                PathFilter importFilter = PathFilters.acceptAll();
                PathFilter exportFilter = PathFilters.acceptAll();
                if (!importedPaths.isEmpty()) {
                    importFilter = PathFilters.not((PathFilter)PathFilters.in(importedPaths));
                }
                specBuilder.addDependency(DependencySpec.createLocalDependencySpec((PathFilter)importFilter, (PathFilter)exportFilter));
            }
            this.addNativeResourceLoader(resModule, specBuilder);
            specBuilder.setModuleClassLoaderFactory((ModuleClassLoaderFactory)new HostBundleModuleClassLoader.Factory(hostBundle));
            specBuilder.setFallbackLoader((LocalLoader)new HostBundleFallbackLoader(hostBundle, identifier, importedPaths));
            moduleSpec = specBuilder.create();
        }
        AbstractRevision bundleRev = (AbstractRevision)resModule.getAttachment(AbstractRevision.class);
        this.moduleLoader.addModule(bundleRev, moduleSpec);
        return moduleSpec.getModuleIdentifier();
    }

    private PathFilter getLazyPackagesFilter(HostBundle hostBundle) {
        List excludes;
        PathFilter result = PathFilters.acceptAll();
        ActivationPolicyMetaData activationPolicy = hostBundle.getActivationPolicy();
        List includes = activationPolicy.getIncludes();
        if (includes != null) {
            HashSet<String> paths = new HashSet<String>();
            for (String packageName : includes) {
                paths.add(packageName.replace('.', '/'));
            }
            result = PathFilters.in(paths);
        }
        if ((excludes = activationPolicy.getExcludes()) != null) {
            HashSet<String> paths = new HashSet<String>();
            for (String packageName : excludes) {
                paths.add(packageName.replace('.', '/'));
            }
            result = includes != null ? PathFilters.all((PathFilter[])new PathFilter[]{result, PathFilters.not((PathFilter)PathFilters.in(paths))}) : PathFilters.not((PathFilter)PathFilters.in(paths));
        }
        return result;
    }

    private void addNativeResourceLoader(XModule resModule, ModuleSpec.Builder specBuilder) {
        Bundle bundle = (Bundle)resModule.getAttachment(Bundle.class);
        AbstractUserBundle bundleState = AbstractUserBundle.assertBundleState(bundle);
        Deployment deployment = bundleState.getDeployment();
        this.addNativeResourceLoader(specBuilder, bundleState, deployment);
        AbstractUserRevision rev = bundleState.getCurrentRevision();
        if (rev instanceof HostRevision) {
            for (FragmentRevision fragRev : ((HostRevision)rev).getAttachedFragments()) {
                this.addNativeResourceLoader(specBuilder, bundleState, fragRev.getDeployment());
            }
        }
    }

    private void addNativeResourceLoader(ModuleSpec.Builder specBuilder, AbstractUserBundle bundleState, Deployment deployment) {
        NativeLibraryMetaData libMetaData = (NativeLibraryMetaData)deployment.getAttachment(NativeLibraryMetaData.class);
        if (libMetaData != null) {
            NativeResourceLoader nativeLoader = new NativeResourceLoader();
            for (NativeLibrary library : libMetaData.getNativeLibraries()) {
                String libpath = library.getLibraryPath();
                String libfile = new File(libpath).getName();
                String libname = libfile.substring(0, libfile.lastIndexOf(46));
                NativeCodePluginImpl.BundleNativeLibraryProvider libProvider = new NativeCodePluginImpl.BundleNativeLibraryProvider(bundleState, libname, libpath);
                nativeLoader.addNativeLibrary(libProvider);
                if (!libname.startsWith("lib")) continue;
                libname = libname.substring(3);
                libProvider = new NativeCodePluginImpl.BundleNativeLibraryProvider(bundleState, libname, libpath);
                nativeLoader.addNativeLibrary(libProvider);
            }
            specBuilder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)nativeLoader));
        }
    }

    private void processModuleWires(List<XWire> wires, Map<XModule, ModuleDependencyHolder> depBuilderMap) {
        XModule exporter;
        ArrayList<XWire> bundleWires = new ArrayList<XWire>();
        ArrayList<XWire> packageWires = new ArrayList<XWire>();
        for (XWire wire : wires) {
            XModule host;
            XRequirement req = wire.getRequirement();
            XModule importer = wire.getImporter();
            exporter = wire.getExporter();
            if (exporter == importer || importer.isFragment() && (host = importer.getHostRequirement().getWiredCapability().getModule()) == exporter) continue;
            if (req instanceof XPackageRequirement) {
                packageWires.add(wire);
                continue;
            }
            if (!(req instanceof XRequireBundleRequirement)) continue;
            bundleWires.add(wire);
        }
        HashSet<String> importedPaths = new HashSet<String>();
        HashSet<XModule> packageExporters = new HashSet<XModule>();
        for (XWire wire : packageWires) {
            exporter = wire.getExporter();
            packageExporters.add(exporter);
            XPackageRequirement req = (XPackageRequirement)wire.getRequirement();
            ModuleDependencyHolder holder = this.getDependencyHolder(depBuilderMap, exporter);
            String path = VFSUtils.getPathFromPackageName((String)req.getName());
            holder.setOptional(req.isOptional());
            holder.addImportPath(path);
            importedPaths.add(path);
        }
        PathFilter importedPathsFilter = PathFilters.in(importedPaths);
        for (XWire wire : bundleWires) {
            XModule exporter2 = wire.getExporter();
            if (packageExporters.contains(exporter2)) continue;
            XRequireBundleRequirement req = (XRequireBundleRequirement)wire.getRequirement();
            ModuleDependencyHolder holder = this.getDependencyHolder(depBuilderMap, exporter2);
            holder.setImportFilter(PathFilters.not((PathFilter)importedPathsFilter));
            holder.setOptional(req.isOptional());
            boolean reexport = "reexport".equals(req.getVisibility());
            if (!reexport) continue;
            HashSet<String> exportedPaths = new HashSet<String>();
            for (XPackageCapability cap : exporter2.getPackageCapabilities()) {
                String path = cap.getName().replace('.', '/');
                if (importedPaths.contains(path)) continue;
                exportedPaths.add(path);
            }
            PathFilter exportedPathsFilter = PathFilters.in(exportedPaths);
            holder.setImportFilter(exportedPathsFilter);
            holder.setExportFilter(exportedPathsFilter);
        }
    }

    private ModuleDependencyHolder getDependencyHolder(Map<XModule, ModuleDependencyHolder> depBuilderMap, XModule exporter) {
        ModuleIdentifier exporterId = this.getModuleIdentifier(exporter);
        ModuleDependencyHolder holder = depBuilderMap.get(exporter);
        if (holder == null) {
            holder = new ModuleDependencyHolder(exporterId);
            depBuilderMap.put(exporter, holder);
        }
        return holder;
    }

    @Override
    public Module loadModule(ModuleIdentifier identifier) throws ModuleLoadException {
        return this.moduleLoader.loadModule(identifier);
    }

    @Override
    public Module removeModule(ModuleIdentifier identifier) {
        return this.moduleLoader.removeModule(identifier);
    }

    private Module getSystemModule() {
        SystemModuleProviderPlugin plugin = this.getBundleManager().getPlugin(SystemModuleProviderPlugin.class);
        return plugin.getSystemModule();
    }

    private Module getFrameworkModule() {
        SystemModuleProviderPlugin plugin = this.getBundleManager().getPlugin(SystemModuleProviderPlugin.class);
        return plugin.getFrameworkModule();
    }

    private class ModuleDependencyHolder {
        private DependencySpec dependencySpec;
        private ModuleIdentifier identifier;
        private Set<String> importPaths;
        private PathFilter importFilter;
        private PathFilter exportFilter;
        private boolean optional;

        ModuleDependencyHolder(ModuleIdentifier identifier) {
            this.identifier = identifier;
        }

        void addImportPath(String path) {
            this.assertNotCreated();
            if (this.importPaths == null) {
                this.importPaths = new HashSet<String>();
            }
            this.importPaths.add(path);
        }

        Set<String> getImportPaths() {
            return this.importPaths;
        }

        void setImportFilter(PathFilter importFilter) {
            this.assertNotCreated();
            this.importFilter = importFilter;
        }

        void setExportFilter(PathFilter exportFilter) {
            this.assertNotCreated();
            this.exportFilter = exportFilter;
        }

        void setOptional(boolean optional) {
            this.assertNotCreated();
            this.optional = optional;
        }

        DependencySpec create() {
            if (this.exportFilter == null) {
                this.exportFilter = PathFilters.rejectAll();
            }
            if (this.importFilter == null) {
                this.importFilter = this.importPaths != null ? PathFilters.in(this.importPaths) : PathFilters.acceptAll();
            }
            return DependencySpec.createModuleDependencySpec((PathFilter)this.importFilter, (PathFilter)this.exportFilter, (ModuleLoader)ModuleManagerPluginImpl.this.moduleLoader, (ModuleIdentifier)this.identifier, (boolean)this.optional);
        }

        private void assertNotCreated() {
            if (this.dependencySpec != null) {
                throw new IllegalStateException("DependencySpec already created");
            }
        }
    }
}

