/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.adapters.jdbc;

import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.security.auth.Subject;
import org.jboss.as.connector.adapters.jdbc.BaseWrapperManagedConnectionFactory;
import org.jboss.as.connector.adapters.jdbc.CachedCallableStatement;
import org.jboss.as.connector.adapters.jdbc.CachedPreparedStatement;
import org.jboss.as.connector.adapters.jdbc.PreparedStatementCache;
import org.jboss.as.connector.adapters.jdbc.StaleConnectionException;
import org.jboss.as.connector.adapters.jdbc.WrappedConnection;
import org.jboss.as.connector.adapters.jdbc.WrappedConnectionFactory;
import org.jboss.logging.Logger;

public abstract class BaseWrapperManagedConnection
implements ManagedConnection {
    private static final WrappedConnectionFactory WRAPPED_CONNECTION_FACTORY;
    private static final String JDBC4_FACTORY = "org.jboss.as.connector.adapters.jdbc.jdk6.WrappedConnectionFactoryJDK6";
    private static final String JDBC41_FACTORY = "org.jboss.as.connector.adapters.jdbc.jdk7.WrappedConnectionFactoryJDK7";
    protected final BaseWrapperManagedConnectionFactory mcf;
    protected final Connection con;
    protected final Properties props;
    private final int transactionIsolation;
    private final boolean readOnly;
    private ReentrantLock lock = new ReentrantLock(true);
    private final Collection<ConnectionEventListener> cels = new ArrayList<ConnectionEventListener>();
    private final Set<WrappedConnection> handles = new HashSet<WrappedConnection>();
    private PreparedStatementCache psCache = null;
    protected final Object stateLock = new Object();
    protected boolean inManagedTransaction = false;
    protected AtomicBoolean inLocalTransaction = new AtomicBoolean(false);
    protected boolean jdbcAutoCommit = true;
    protected boolean underlyingAutoCommit = true;
    protected boolean jdbcReadOnly;
    protected boolean underlyingReadOnly;
    protected int jdbcTransactionIsolation;
    protected boolean destroyed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseWrapperManagedConnection(BaseWrapperManagedConnectionFactory mcf, Connection con, Properties props, int transactionIsolation, int psCacheSize) throws SQLException {
        this.mcf = mcf;
        this.con = con;
        this.props = props;
        if (psCacheSize > 0) {
            this.psCache = new PreparedStatementCache(psCacheSize);
        }
        if (transactionIsolation == -1) {
            this.transactionIsolation = con.getTransactionIsolation();
        } else {
            this.transactionIsolation = transactionIsolation;
            con.setTransactionIsolation(transactionIsolation);
        }
        this.readOnly = con.isReadOnly();
        if (mcf.getNewConnectionSQL() != null) {
            Statement s = con.createStatement();
            try {
                s.execute(mcf.getNewConnectionSQL());
            }
            finally {
                s.close();
            }
        }
        this.underlyingReadOnly = this.readOnly;
        this.jdbcReadOnly = this.readOnly;
        this.jdbcTransactionIsolation = this.transactionIsolation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionEventListener(ConnectionEventListener cel) {
        Collection<ConnectionEventListener> collection = this.cels;
        synchronized (collection) {
            this.cels.add(cel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionEventListener(ConnectionEventListener cel) {
        Collection<ConnectionEventListener> collection = this.cels;
        synchronized (collection) {
            this.cels.remove(cel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateConnection(Object handle) throws ResourceException {
        if (!(handle instanceof WrappedConnection)) {
            throw new ResourceException("Wrong kind of connection handle to associate " + handle);
        }
        WrappedConnection wc = (WrappedConnection)handle;
        wc.setManagedConnection(this);
        Set<WrappedConnection> set = this.handles;
        synchronized (set) {
            this.handles.add(wc);
        }
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return null;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return null;
    }

    public void setLogWriter(PrintWriter param1) throws ResourceException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() throws ResourceException {
        Object object = this.handles;
        synchronized (object) {
            for (WrappedConnection lc : this.handles) {
                lc.setManagedConnection(null);
            }
            this.handles.clear();
        }
        object = this.stateLock;
        synchronized (object) {
            this.jdbcAutoCommit = true;
            this.jdbcReadOnly = this.readOnly;
            if (this.jdbcTransactionIsolation != this.transactionIsolation) {
                try {
                    this.con.setTransactionIsolation(this.transactionIsolation);
                    this.jdbcTransactionIsolation = this.transactionIsolation;
                }
                catch (SQLException e) {
                    this.mcf.log.warn((Object)"Error resetting transaction isolation ", (Throwable)e);
                }
            }
        }
        this.lock = new ReentrantLock(true);
    }

    protected void lock() {
        this.lock.lock();
    }

    protected void tryLock() throws SQLException {
        int tryLock = this.mcf.getUseTryLock();
        if (tryLock <= 0) {
            this.lock();
            return;
        }
        try {
            if (!this.lock.tryLock(tryLock, TimeUnit.SECONDS)) {
                throw new SQLException("Unable to obtain lock in " + tryLock + " seconds: " + this);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLException("Interrupted attempting lock: " + this);
        }
    }

    protected void unlock() {
        if (this.lock.isHeldByCurrentThread()) {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        this.checkIdentity(subject, cri);
        WrappedConnection lc = WRAPPED_CONNECTION_FACTORY.createWrappedConnection(this, this.mcf.getSpy(), this.mcf.getJndiName());
        Set<WrappedConnection> set = this.handles;
        synchronized (set) {
            this.handles.add(lc);
        }
        return lc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws ResourceException {
        Object object = this.stateLock;
        synchronized (object) {
            this.destroyed = true;
        }
        this.cleanup();
        try {
            if (!this.underlyingAutoCommit) {
                this.con.rollback();
            }
        }
        catch (SQLException ignored) {
            this.getLog().trace((Object)"Ignored error during rollback: ", (Throwable)ignored);
        }
        try {
            this.con.close();
        }
        catch (SQLException ignored) {
            this.getLog().trace((Object)"Ignored error during close: ", (Throwable)ignored);
        }
    }

    public boolean checkValid() {
        SQLException e = this.mcf.isValidConnection(this.con);
        if (e == null) {
            return true;
        }
        this.getLog().warn((Object)("Destroying connection that is not valid, due to the following exception: " + this.con), (Throwable)e);
        this.broadcastConnectionError(e);
        return false;
    }

    public Properties getProperties() {
        return this.props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeHandle(WrappedConnection handle) {
        Set<WrappedConnection> set = this.stateLock;
        synchronized (set) {
            if (this.destroyed) {
                return;
            }
        }
        set = this.handles;
        synchronized (set) {
            this.handles.remove(handle);
        }
        ArrayList<ConnectionEventListener> copy = null;
        Collection<ConnectionEventListener> collection = this.cels;
        synchronized (collection) {
            if (this.cels != null && this.cels.size() > 0) {
                copy = new ArrayList<ConnectionEventListener>(this.cels);
            }
        }
        if (copy != null) {
            ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, 1);
            ce.setConnectionHandle((Object)handle);
            for (ConnectionEventListener cel : copy) {
                cel.connectionClosed(ce);
            }
        }
    }

    Throwable connectionError(Throwable t) {
        if (t instanceof SQLException) {
            if (this.mcf.isStaleConnection((SQLException)t)) {
                t = new StaleConnectionException((SQLException)t);
            } else if (this.mcf.isExceptionFatal((SQLException)t)) {
                this.broadcastConnectionError(t);
            }
        } else {
            this.broadcastConnectionError(t);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void broadcastConnectionError(Throwable e) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.destroyed) {
                Logger log = this.getLog();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Not broadcasting error, already destroyed " + this), e);
                }
                return;
            }
        }
        Exception ex = null;
        ex = e instanceof Exception ? (Exception)e : new ResourceAdapterInternalException("Unexpected error", e);
        ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, 5, ex);
        ArrayList<ConnectionEventListener> copy = null;
        Collection<ConnectionEventListener> collection = this.cels;
        synchronized (collection) {
            copy = new ArrayList<ConnectionEventListener>(this.cels);
        }
        for (ConnectionEventListener cel : copy) {
            try {
                cel.connectionErrorOccurred(ce);
            }
            catch (Throwable t) {
                this.getLog().warn((Object)("Error notifying of connection error for listener: " + cel), t);
            }
        }
    }

    Connection getConnection() throws SQLException {
        if (this.con == null) {
            throw new SQLException("Connection has been destroyed!!!");
        }
        return this.con;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.psCache == null) return this.doPrepareStatement(sql, resultSetType, resultSetConcurrency);
        PreparedStatementCache.Key key = new PreparedStatementCache.Key(sql, 1, resultSetType, resultSetConcurrency);
        CachedPreparedStatement cachedps = (CachedPreparedStatement)this.psCache.get(key);
        if (cachedps != null) {
            if (!this.canUse(cachedps)) return this.doPrepareStatement(sql, resultSetType, resultSetConcurrency);
            cachedps.inUse();
            return cachedps;
        } else {
            PreparedStatement ps = this.doPrepareStatement(sql, resultSetType, resultSetConcurrency);
            cachedps = WRAPPED_CONNECTION_FACTORY.createCachedPreparedStatement(ps);
            this.psCache.insert(key, cachedps);
        }
        return cachedps;
    }

    PreparedStatement doPrepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.con.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.psCache == null) return this.doPrepareCall(sql, resultSetType, resultSetConcurrency);
        PreparedStatementCache.Key key = new PreparedStatementCache.Key(sql, 2, resultSetType, resultSetConcurrency);
        CachedCallableStatement cachedps = (CachedCallableStatement)this.psCache.get(key);
        if (cachedps != null) {
            if (!this.canUse(cachedps)) return this.doPrepareCall(sql, resultSetType, resultSetConcurrency);
            cachedps.inUse();
            return cachedps;
        } else {
            CallableStatement cs = this.doPrepareCall(sql, resultSetType, resultSetConcurrency);
            cachedps = WRAPPED_CONNECTION_FACTORY.createCachedCallableStatement(cs);
            this.psCache.insert(key, cachedps);
        }
        return cachedps;
    }

    CallableStatement doPrepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.con.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    boolean canUse(CachedPreparedStatement cachedps) {
        if (!cachedps.isInUse()) {
            return true;
        }
        if (this.underlyingAutoCommit) {
            return false;
        }
        return this.mcf.sharePS;
    }

    protected Logger getLog() {
        return this.mcf.log;
    }

    private void checkIdentity(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        Properties newProps = this.mcf.getConnectionProperties(subject, cri);
        if (!this.props.equals(newProps)) {
            throw new ResourceException("Wrong credentials passed to getConnection!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkTransaction() throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.inManagedTransaction) {
                return;
            }
            if (this.jdbcAutoCommit != this.underlyingAutoCommit) {
                this.con.setAutoCommit(this.jdbcAutoCommit);
                this.underlyingAutoCommit = this.jdbcAutoCommit;
            }
        }
        if (!this.jdbcAutoCommit && !this.inLocalTransaction.getAndSet(true)) {
            ArrayList<ConnectionEventListener> copy = null;
            Collection<ConnectionEventListener> collection = this.cels;
            synchronized (collection) {
                copy = new ArrayList<ConnectionEventListener>(this.cels);
            }
            ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, 2);
            for (ConnectionEventListener cel : copy) {
                try {
                    cel.localTransactionStarted(ce);
                }
                catch (Throwable t) {
                    this.getLog().trace((Object)("Error notifying of connection committed for listener: " + cel), t);
                }
            }
        }
        this.checkState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkState() throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.jdbcReadOnly != this.underlyingReadOnly) {
                this.con.setReadOnly(this.jdbcReadOnly);
                this.underlyingReadOnly = this.jdbcReadOnly;
            }
        }
    }

    boolean isJdbcAutoCommit() {
        return this.inManagedTransaction ? false : this.jdbcAutoCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setJdbcAutoCommit(boolean jdbcAutoCommit) throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.inManagedTransaction) {
                throw new SQLException("You cannot set autocommit during a managed transaction!");
            }
            this.jdbcAutoCommit = jdbcAutoCommit;
        }
        if (jdbcAutoCommit && this.inLocalTransaction.getAndSet(false)) {
            ArrayList<ConnectionEventListener> copy = null;
            Collection<ConnectionEventListener> collection = this.cels;
            synchronized (collection) {
                copy = new ArrayList<ConnectionEventListener>(this.cels);
            }
            ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, 3);
            for (ConnectionEventListener cel : copy) {
                try {
                    cel.localTransactionCommitted(ce);
                }
                catch (Throwable t) {
                    this.getLog().trace((Object)("Error notifying of connection committed for listener: " + cel), t);
                }
            }
        }
    }

    boolean isJdbcReadOnly() {
        return this.jdbcReadOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setJdbcReadOnly(boolean readOnly) throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.inManagedTransaction) {
                throw new SQLException("You cannot set read only during a managed transaction!");
            }
            this.jdbcReadOnly = readOnly;
        }
    }

    int getJdbcTransactionIsolation() {
        return this.jdbcTransactionIsolation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setJdbcTransactionIsolation(int isolationLevel) throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            this.jdbcTransactionIsolation = isolationLevel;
            this.con.setTransactionIsolation(this.jdbcTransactionIsolation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jdbcCommit() throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.inManagedTransaction) {
                throw new SQLException("You cannot commit during a managed transaction!");
            }
            if (this.jdbcAutoCommit) {
                throw new SQLException("You cannot commit with autocommit set!");
            }
        }
        this.con.commit();
        if (this.inLocalTransaction.getAndSet(false)) {
            ArrayList<ConnectionEventListener> copy = null;
            Collection<ConnectionEventListener> collection = this.cels;
            synchronized (collection) {
                copy = new ArrayList<ConnectionEventListener>(this.cels);
            }
            ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, 3);
            for (ConnectionEventListener cel : copy) {
                try {
                    cel.localTransactionCommitted(ce);
                }
                catch (Throwable t) {
                    this.getLog().trace((Object)("Error notifying of connection committed for listener: " + cel), t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jdbcRollback() throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.inManagedTransaction) {
                throw new SQLException("You cannot rollback during a managed transaction!");
            }
            if (this.jdbcAutoCommit) {
                throw new SQLException("You cannot rollback with autocommit set!");
            }
        }
        this.con.rollback();
        if (this.inLocalTransaction.getAndSet(false)) {
            ArrayList<ConnectionEventListener> copy = null;
            Collection<ConnectionEventListener> collection = this.cels;
            synchronized (collection) {
                copy = new ArrayList<ConnectionEventListener>(this.cels);
            }
            ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, 4);
            for (ConnectionEventListener cel : copy) {
                try {
                    cel.localTransactionRolledback(ce);
                }
                catch (Throwable t) {
                    this.getLog().trace((Object)("Error notifying of connection rollback for listener: " + cel), t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jdbcRollback(Savepoint savepoint) throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.inManagedTransaction) {
                throw new SQLException("You cannot rollback during a managed transaction!");
            }
            if (this.jdbcAutoCommit) {
                throw new SQLException("You cannot rollback with autocommit set!");
            }
        }
        this.con.rollback(savepoint);
    }

    int getTrackStatements() {
        return this.mcf.trackStatements;
    }

    boolean isTransactionQueryTimeout() {
        return this.mcf.isTransactionQueryTimeout;
    }

    int getQueryTimeout() {
        return this.mcf.getQueryTimeout();
    }

    protected void checkException(SQLException e) throws ResourceException {
        this.connectionError(e);
        throw new ResourceException("SQLException", (Throwable)e);
    }

    static {
        Class<?> connectionFactory = null;
        try {
            connectionFactory = Class.forName(JDBC4_FACTORY);
        }
        catch (ClassNotFoundException e) {
            try {
                connectionFactory = Class.forName(JDBC41_FACTORY);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Unabled to load wrapped connection factory", cnfe);
            }
        }
        try {
            WRAPPED_CONNECTION_FACTORY = (WrappedConnectionFactory)connectionFactory.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializign connection factory", e);
        }
    }
}

