/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.sql.Driver;
import java.util.ServiceLoader;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class JdbcDriverAdd
implements ModelAddOperationHandler {
    static final JdbcDriverAdd INSTANCE = new JdbcDriverAdd();
    public static final Logger log = Logger.getLogger((String)"org.jboss.as.connector.subsystems.datasources");

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        ModelNode address = operation.require("address");
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)address);
        final String moduleName = operation.require("module").asString();
        ModelNode model = context.getSubModel();
        model.get("name").set(pathAddress.getLastElement().getValue());
        model.get("module").set(moduleName);
        ModelNode compensating = Util.getResourceRemoveOperation((ModelNode)address);
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    Module module;
                    ServiceTarget target = context.getServiceTarget();
                    try {
                        module = Module.getCallerModuleLoader().loadModule(ModuleIdentifier.create((String)moduleName));
                    }
                    catch (ModuleLoadException e) {
                        throw new OperationFailedException((Throwable)e, new ModelNode().set("Failed to load module for driver [" + moduleName + "]"));
                    }
                    ServiceLoader serviceLoader = module.loadService(Driver.class);
                    if (serviceLoader != null) {
                        for (Driver driver : serviceLoader) {
                            int majorVersion = driver.getMajorVersion();
                            int minorVersion = driver.getMinorVersion();
                            boolean compliant = driver.jdbcCompliant();
                            if (compliant) {
                                log.infof("Deploying JDBC-compliant driver %s (version %d.%d)", driver.getClass(), (Object)majorVersion, (Object)minorVersion);
                            } else {
                                log.infof("Deploying non-JDBC-compliant driver %s (version %d.%d)", driver.getClass(), (Object)majorVersion, (Object)minorVersion);
                            }
                            target.addService(ServiceName.JBOSS.append(new String[]{"jdbc-driver", driver.getClass().getName(), Integer.toString(majorVersion), Integer.toString(minorVersion)}), (Service)new ValueService((Value)new ImmediateValue((Object)driver))).setInitialMode(ServiceController.Mode.ACTIVE).install();
                        }
                    }
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensating);
    }
}

