/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionFactory;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.AnnotationIndexUtils;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.weld.WeldDeploymentMarker;
import org.jboss.as.weld.deployment.BeanArchiveMetadata;
import org.jboss.as.weld.deployment.BeanDeploymentArchiveImpl;
import org.jboss.as.weld.deployment.BeanDeploymentModule;
import org.jboss.as.weld.deployment.EjbDescriptorImpl;
import org.jboss.as.weld.deployment.WeldAttachments;
import org.jboss.as.weld.deployment.WeldDeploymentMetadata;
import org.jboss.as.weld.injection.WeldInjectionFactory;
import org.jboss.as.weld.services.bootstrap.WeldEjbInjectionServices;
import org.jboss.as.weld.services.bootstrap.WeldJpaInjectionServices;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.injection.spi.EjbInjectionServices;
import org.jboss.weld.injection.spi.JpaInjectionServices;

public class BeanArchiveProcessor
implements DeploymentUnitProcessor {
    private static final Logger log = Logger.getLogger((String)"org.jboss.weld");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentUnit topLevelDeployment = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        WeldDeploymentMetadata cdiDeploymentMetadata = (WeldDeploymentMetadata)deploymentUnit.getAttachment(WeldDeploymentMetadata.ATTACHMENT_KEY);
        if (!WeldDeploymentMarker.isWeldDeployment(deploymentUnit)) {
            return;
        }
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        Module topLevelModule = (Module)topLevelDeployment.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        if (eeModuleDescription != null) {
            eeModuleDescription.addInjectionFactory((InjectionFactory)new WeldInjectionFactory(phaseContext.getServiceTarget(), deploymentUnit, (ClassLoader)topLevelModule.getClassLoader()));
        }
        String beanArchiveIdPrefix = deploymentUnit.getParent() == null ? deploymentUnit.getName() : deploymentUnit.getParent().getName() + "." + deploymentUnit.getName();
        HashSet<BeanDeploymentArchiveImpl> beanDeploymentArchives = new HashSet<BeanDeploymentArchiveImpl>();
        log.info((Object)("Processing CDI deployment: " + phaseContext.getDeploymentUnit().getName()));
        Map indexes = AnnotationIndexUtils.getAnnotationIndexes((DeploymentUnit)deploymentUnit);
        HashMap<ResourceRoot, BeanDeploymentArchiveImpl> bdaMap = new HashMap<ResourceRoot, BeanDeploymentArchiveImpl>();
        Module module = (Module)phaseContext.getDeploymentUnit().getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        BeanDeploymentArchiveImpl rootBda = null;
        if (cdiDeploymentMetadata != null) {
            for (BeanArchiveMetadata beanArchiveMetadata : cdiDeploymentMetadata.getBeanArchiveMetadata()) {
                BeanDeploymentArchiveImpl bda = this.createBeanDeploymentArchive((Index)indexes.get(beanArchiveMetadata.getResourceRoot()), beanArchiveMetadata, module, beanArchiveIdPrefix);
                beanDeploymentArchives.add(bda);
                bdaMap.put(beanArchiveMetadata.getResourceRoot(), bda);
                if (!beanArchiveMetadata.isDeploymentRoot()) continue;
                rootBda = bda;
                deploymentUnit.putAttachment(WeldAttachments.DEPLOYMENT_ROOT_BEAN_DEPLOYMENT_ARCHIVE, (Object)bda);
            }
        }
        if (rootBda == null) {
            BeanDeploymentArchiveImpl bda = new BeanDeploymentArchiveImpl(Collections.<String>emptySet(), BeansXml.EMPTY_BEANS_XML, module, beanArchiveIdPrefix);
            beanDeploymentArchives.add(bda);
            deploymentUnit.putAttachment(WeldAttachments.DEPLOYMENT_ROOT_BEAN_DEPLOYMENT_ARCHIVE, (Object)bda);
            rootBda = bda;
        }
        this.processEjbComponents(deploymentUnit, bdaMap, rootBda, indexes);
        WeldEjbInjectionServices ejbInjectionServices = new WeldEjbInjectionServices(deploymentUnit.getServiceRegistry(), eeModuleDescription);
        WeldJpaInjectionServices jpaInjectionServices = new WeldJpaInjectionServices(deploymentUnit, deploymentUnit.getServiceRegistry());
        BeanDeploymentModule bdm = new BeanDeploymentModule(beanDeploymentArchives);
        bdm.addService(EjbInjectionServices.class, ejbInjectionServices);
        bdm.addService(JpaInjectionServices.class, jpaInjectionServices);
        deploymentUnit.putAttachment(WeldAttachments.BEAN_DEPLOYMENT_MODULE, (Object)bdm);
    }

    private void processEjbComponents(DeploymentUnit deploymentUnit, Map<ResourceRoot, BeanDeploymentArchiveImpl> bdaMap, BeanDeploymentArchiveImpl rootBda, Map<ResourceRoot, Index> indexes) {
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        for (AbstractComponentDescription component : moduleDescription.getComponentDescriptions()) {
            if (!(component instanceof SessionBeanComponentDescription)) continue;
            SessionBeanComponentDescription componentDescription = (SessionBeanComponentDescription)component;
            BeanDeploymentArchiveImpl bda = this.resolveSessionBeanBda(componentDescription.getEJBClassName(), bdaMap, rootBda, indexes);
            bda.addEjbDescriptor(new EjbDescriptorImpl((EJBComponentDescription)componentDescription, bda, deploymentUnit));
        }
    }

    private BeanDeploymentArchiveImpl resolveSessionBeanBda(String ejbClassName, Map<ResourceRoot, BeanDeploymentArchiveImpl> bdaMap, BeanDeploymentArchiveImpl rootBda, Map<ResourceRoot, Index> indexes) {
        DotName className = DotName.createSimple((String)ejbClassName);
        for (Map.Entry<ResourceRoot, BeanDeploymentArchiveImpl> entry : bdaMap.entrySet()) {
            Index index = indexes.get(entry.getKey());
            if (index == null || index.getClassByName(className) == null) continue;
            return entry.getValue();
        }
        return rootBda;
    }

    private BeanDeploymentArchiveImpl createBeanDeploymentArchive(Index index, BeanArchiveMetadata beanArchiveMetadata, Module module, String beanArchivePrefix) throws DeploymentUnitProcessingException {
        HashSet<String> classNames = new HashSet<String>();
        if (index != null) {
            for (ClassInfo classInfo : index.getKnownClasses()) {
                classNames.add(classInfo.name().toString());
            }
        }
        return new BeanDeploymentArchiveImpl(classNames, beanArchiveMetadata.getBeansXml(), module, beanArchivePrefix + beanArchiveMetadata.getResourceRoot().getRoot().getPathName());
    }

    public void undeploy(DeploymentUnit context) {
    }
}

