/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.weld.WeldDeploymentMarker;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilters;

public class WeldDependencyProcessor
implements DeploymentUnitProcessor {
    private static ModuleIdentifier JAVAX_PERSISTENCE_API_ID = ModuleIdentifier.create((String)"javax.persistence.api");
    private static ModuleIdentifier JAVAEE_API_ID = ModuleIdentifier.create((String)"javaee.api");
    private static final ModuleIdentifier JAVASSIST_ID = ModuleIdentifier.create((String)"org.javassist");
    private static ModuleIdentifier JBOSS_INTERCEPTOR_ID = ModuleIdentifier.create((String)"org.jboss.interceptor");
    private static ModuleIdentifier JBOSS_AS_WELD_ID = ModuleIdentifier.create((String)"org.jboss.as.weld");
    private static ModuleIdentifier JBOSS_LOGGING_ID = ModuleIdentifier.create((String)"org.jboss.logging");
    private static ModuleIdentifier WELD_CORE_ID = ModuleIdentifier.create((String)"org.jboss.weld.core");
    private static ModuleIdentifier WELD_API_ID = ModuleIdentifier.create((String)"org.jboss.weld.api");
    private static ModuleIdentifier WELD_SPI_ID = ModuleIdentifier.create((String)"org.jboss.weld.spi");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        if (!WeldDeploymentMarker.isWeldDeployment(deploymentUnit)) {
            return;
        }
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        this.addDepdenency(moduleSpecification, moduleLoader, JAVAX_PERSISTENCE_API_ID);
        this.addDepdenency(moduleSpecification, moduleLoader, JAVAEE_API_ID);
        this.addDepdenency(moduleSpecification, moduleLoader, JBOSS_INTERCEPTOR_ID);
        this.addDepdenency(moduleSpecification, moduleLoader, JBOSS_LOGGING_ID);
        this.addDepdenency(moduleSpecification, moduleLoader, JAVASSIST_ID);
        this.addDepdenency(moduleSpecification, moduleLoader, WELD_CORE_ID);
        this.addDepdenency(moduleSpecification, moduleLoader, WELD_API_ID);
        this.addDepdenency(moduleSpecification, moduleLoader, WELD_SPI_ID);
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            ModuleDependency dep = new ModuleDependency(moduleLoader, JBOSS_AS_WELD_ID, false, false, false);
            dep.addImportFilter(PathFilters.getMetaInfFilter(), true);
            dep.addExportFilter(PathFilters.getMetaInfFilter(), true);
            moduleSpecification.addDependency(dep);
        }
    }

    private void addDepdenency(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, ModuleIdentifier moduleIdentifier) {
        moduleSpecification.addDependency(new ModuleDependency(moduleLoader, moduleIdentifier, false, false, false));
    }

    public void undeploy(DeploymentUnit context) {
    }
}

