/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.util.HashSet;
import java.util.List;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import javax.validation.ValidatorFactory;
import org.jboss.as.ee.beanvalidation.BeanValidationAttachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.PrivateSubDeploymentMarker;
import org.jboss.as.txn.TransactionManagerService;
import org.jboss.as.txn.UserTransactionService;
import org.jboss.as.weld.WeldContainer;
import org.jboss.as.weld.WeldDeploymentMarker;
import org.jboss.as.weld.deployment.BeanDeploymentArchiveImpl;
import org.jboss.as.weld.deployment.BeanDeploymentModule;
import org.jboss.as.weld.deployment.WeldAttachments;
import org.jboss.as.weld.deployment.WeldDeployment;
import org.jboss.as.weld.services.TCCLSingletonService;
import org.jboss.as.weld.services.WeldService;
import org.jboss.as.weld.services.bootstrap.WeldEjbInjectionServices;
import org.jboss.as.weld.services.bootstrap.WeldEjbServices;
import org.jboss.as.weld.services.bootstrap.WeldJpaInjectionServices;
import org.jboss.as.weld.services.bootstrap.WeldResourceInjectionServices;
import org.jboss.as.weld.services.bootstrap.WeldSecurityServices;
import org.jboss.as.weld.services.bootstrap.WeldTransactionServices;
import org.jboss.as.weld.services.bootstrap.WeldValidationServices;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.injection.spi.EjbInjectionServices;
import org.jboss.weld.injection.spi.JpaInjectionServices;
import org.jboss.weld.validation.spi.ValidationServices;

public class WeldDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final Logger log = Logger.getLogger((String)"org.jboss.weld");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        if (!WeldDeploymentMarker.isWeldDeployment(deploymentUnit)) {
            return;
        }
        if (deploymentUnit.getParent() != null) {
            return;
        }
        log.info((Object)("Starting Services for CDI deployment: " + phaseContext.getDeploymentUnit().getName()));
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        HashSet<BeanDeploymentModule> beanDeploymentModules = new HashSet<BeanDeploymentModule>();
        HashSet<BeanDeploymentModule> globalBeanDeploymentModules = new HashSet<BeanDeploymentModule>();
        HashSet<BeanDeploymentArchiveImpl> beanDeploymentArchives = new HashSet<BeanDeploymentArchiveImpl>();
        BeanDeploymentModule rootBeanDeploymentModule = (BeanDeploymentModule)deploymentUnit.getAttachment(WeldAttachments.BEAN_DEPLOYMENT_MODULE);
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
        globalBeanDeploymentModules.add(rootBeanDeploymentModule);
        beanDeploymentArchives.addAll(rootBeanDeploymentModule.getBeanDeploymentArchives());
        List subDeployments = deploymentUnit.getAttachmentList(Attachments.SUB_DEPLOYMENTS);
        HashSet<ClassLoader> subDeploymentLoaders = new HashSet<ClassLoader>();
        for (DeploymentUnit subDeployment : subDeployments) {
            BeanDeploymentModule bdm;
            Module subDeploymentModule = (Module)subDeployment.getAttachment(Attachments.MODULE);
            if (module != null) {
                subDeploymentLoaders.add((ClassLoader)subDeploymentModule.getClassLoader());
            }
            if ((bdm = (BeanDeploymentModule)subDeployment.getAttachment(WeldAttachments.BEAN_DEPLOYMENT_MODULE)) == null) continue;
            beanDeploymentArchives.addAll(bdm.getBeanDeploymentArchives());
            if (bdm == null) continue;
            beanDeploymentModules.add(bdm);
            if (PrivateSubDeploymentMarker.isPrivate((DeploymentUnit)subDeployment)) continue;
            globalBeanDeploymentModules.add(bdm);
        }
        for (BeanDeploymentModule bdm : beanDeploymentModules) {
            if (bdm == rootBeanDeploymentModule) continue;
            bdm.addBeanDeploymentModules(globalBeanDeploymentModules);
        }
        List extensions = deploymentUnit.getAttachmentList(WeldAttachments.PORTABLE_EXTENSIONS);
        WeldDeployment deployment = new WeldDeployment(beanDeploymentArchives, extensions, module, subDeploymentLoaders);
        WeldContainer weldContainer = new WeldContainer(deployment, (Environment)Environments.EE_INJECT);
        ValidatorFactory factory = (ValidatorFactory)deploymentUnit.getAttachment(BeanValidationAttachments.VALIDATOR_FACTORY);
        weldContainer.addWeldService(ValidationServices.class, new WeldValidationServices(factory));
        WeldEjbInjectionServices ejbInjectionServices = new WeldEjbInjectionServices(deploymentUnit.getServiceRegistry(), eeModuleDescription);
        weldContainer.addWeldService(EjbInjectionServices.class, ejbInjectionServices);
        weldContainer.addWeldService(EjbServices.class, new WeldEjbServices(deploymentUnit.getServiceRegistry()));
        WeldJpaInjectionServices rootJpaInjectionServices = new WeldJpaInjectionServices(deploymentUnit, deploymentUnit.getServiceRegistry());
        weldContainer.addWeldService(JpaInjectionServices.class, rootJpaInjectionServices);
        WeldService weldService = new WeldService(weldContainer);
        ServiceName weldServiceName = deploymentUnit.getServiceName().append(WeldService.SERVICE_NAME);
        ServiceBuilder weldServiceBuilder = serviceTarget.addService(weldServiceName, (Service)weldService);
        weldServiceBuilder.addDependencies(new ServiceName[]{TCCLSingletonService.SERVICE_NAME});
        this.installResourceInjectionService(serviceTarget, deploymentUnit, weldService, (ServiceBuilder<WeldContainer>)weldServiceBuilder);
        this.installSecurityService(serviceTarget, deploymentUnit, weldService, (ServiceBuilder<WeldContainer>)weldServiceBuilder);
        this.installTransactionService(serviceTarget, deploymentUnit, weldService, (ServiceBuilder<WeldContainer>)weldServiceBuilder);
        weldServiceBuilder.install();
    }

    private ServiceName installSecurityService(ServiceTarget serviceTarget, DeploymentUnit deploymentUnit, WeldService weldService, ServiceBuilder<WeldContainer> weldServiceBuilder) {
        WeldSecurityServices service = new WeldSecurityServices();
        ServiceName serviceName = deploymentUnit.getServiceName().append(WeldSecurityServices.SERVICE_NAME);
        serviceTarget.addService(serviceName, (Service)service).install();
        weldServiceBuilder.addDependency(serviceName, WeldSecurityServices.class, weldService.getSecurityServices());
        return serviceName;
    }

    private ServiceName installResourceInjectionService(ServiceTarget serviceTarget, DeploymentUnit deploymentUnit, WeldService weldService, ServiceBuilder<WeldContainer> weldServiceBuilder) {
        WeldResourceInjectionServices service = new WeldResourceInjectionServices();
        ServiceName serviceName = deploymentUnit.getServiceName().append(WeldResourceInjectionServices.SERVICE_NAME);
        serviceTarget.addService(serviceName, (Service)service).install();
        weldServiceBuilder.addDependency(serviceName, WeldResourceInjectionServices.class, weldService.getResourceInjectionServices());
        return serviceName;
    }

    private ServiceName installTransactionService(ServiceTarget serviceTarget, DeploymentUnit deploymentUnit, WeldService weldService, ServiceBuilder<WeldContainer> weldServiceBuilder) {
        WeldTransactionServices weldTransactionServices = new WeldTransactionServices();
        ServiceName weldTransactionServiceName = deploymentUnit.getServiceName().append(WeldTransactionServices.SERVICE_NAME);
        serviceTarget.addService(weldTransactionServiceName, (Service)weldTransactionServices).addDependency(TransactionManagerService.SERVICE_NAME, TransactionManager.class, weldTransactionServices.getInjectedTransactionManager()).addDependency(UserTransactionService.SERVICE_NAME, UserTransaction.class, weldTransactionServices.getInjectedTransaction()).install();
        weldServiceBuilder.addDependency(weldTransactionServiceName, WeldTransactionServices.class, weldService.getWeldTransactionServices());
        return weldTransactionServiceName;
    }

    public void undeploy(DeploymentUnit context) {
        ServiceName weldTransactionServiceName = context.getServiceName().append(WeldTransactionServices.SERVICE_NAME);
        ServiceController serviceController = context.getServiceRegistry().getService(weldTransactionServiceName);
        if (serviceController != null) {
            serviceController.setMode(ServiceController.Mode.REMOVE);
        }
    }
}

