/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import javax.enterprise.inject.spi.Extension;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.PrivateSubDeploymentMarker;
import org.jboss.as.weld.WeldDeploymentMarker;
import org.jboss.as.weld.deployment.WeldAttachments;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.util.ServiceLoader;

public class WeldPortableExtensionProcessor
implements DeploymentUnitProcessor {
    private static final Logger log = Logger.getLogger((String)"org.jboss.weld");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (PrivateSubDeploymentMarker.isPrivate((DeploymentUnit)deploymentUnit) ? !WeldDeploymentMarker.isWeldDeployment(deploymentUnit) : (deploymentUnit.getParent() == null ? !WeldDeploymentMarker.isWeldDeployment(deploymentUnit) : !WeldDeploymentMarker.isWeldDeployment(deploymentUnit.getParent()))) {
            return;
        }
        DeploymentUnit topLevelDeployment = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        this.loadAttachments(module, topLevelDeployment);
    }

    private void loadAttachments(Module module, DeploymentUnit deploymentUnit) {
        ServiceLoader loader = ServiceLoader.load(Extension.class, (ClassLoader)module.getClassLoader());
        for (Metadata extension : loader) {
            log.debug((Object)("Loaded portable extension " + extension.getLocation()));
            deploymentUnit.addToAttachmentList(WeldAttachments.PORTABLE_EXTENSIONS, (Object)extension);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

