/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.jmx.JMXConnectorService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

class JMXConnectorRemove
implements ModelUpdateOperationHandler {
    static final JMXConnectorRemove INSTANCE = new JMXConnectorRemove();
    static final String OPERATION_NAME = "remove-connector";

    private JMXConnectorRemove() {
    }

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) {
        ModelNode subModel = context.getSubModel();
        ModelNode compensatingOperation = new ModelNode();
        compensatingOperation.get("operation").set("add-connector");
        compensatingOperation.get("address").set(operation.require("address"));
        compensatingOperation.get("server-binding").set(subModel.get("server-binding"));
        compensatingOperation.get("registry-binding").set(subModel.get("registry-binding"));
        subModel.get("server-binding").clear();
        subModel.get("registry-binding").clear();
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceController service = context.getServiceRegistry().getService(JMXConnectorService.SERVICE_NAME);
                    if (service != null) {
                        service.addListener((ServiceListener)new ResultHandler.ServiceRemoveListener(resultHandler));
                    } else {
                        resultHandler.handleResultComplete();
                    }
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }
}

