/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.web.Namespace;
import org.jboss.as.web.WebConnectorMetrics;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class WebSubsystemDescriptions {
    static final String RESOURCE_NAME = WebSubsystemDescriptions.class.getPackage().getName() + ".LocalDescriptions";

    WebSubsystemDescriptions() {
    }

    static ModelNode getSubsystemDescription(Locale locale) {
        ResourceBundle bundle = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("web"));
        node.get("head-comment-allowed").set(true);
        node.get("tail-comment-allowed").set(true);
        node.get("namespace").set(Namespace.WEB_1_0.getUriString());
        node.get(new String[]{"attributes", "default-virtual-server", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "default-virtual-server", "description"}).set(bundle.getString("web.default-virtual-server"));
        node.get(new String[]{"attributes", "default-virtual-server", "required"}).set(false);
        node.get(new String[]{"attributes", "native", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "native", "description"}).set(bundle.getString("web.native"));
        node.get(new String[]{"attributes", "native", "required"}).set(false);
        WebSubsystemDescriptions.getConfigurationCommonDescription(node.get(new String[]{"attributes", "configuration"}), bundle);
        WebSubsystemDescriptions.getConnectorCommonDescription(node.get(new String[]{"children", "connector"}), bundle);
        WebSubsystemDescriptions.getVirtualServerCommonDescription(node.get(new String[]{"children", "virtual-server"}), bundle);
        return node;
    }

    static ModelNode getSubsystemAddDescription(Locale locale) {
        ResourceBundle bundle = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle.getString("web.add"));
        node.get(new String[]{"request-properties", "default-virtual-server", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "default-virtual-server", "description"}).set(bundle.getString("web.default-virtual-server"));
        node.get(new String[]{"request-properties", "default-virtual-server", "required"}).set(false);
        WebSubsystemDescriptions.getConfigurationCommonDescription(node.get(new String[]{"request-properties", "configuration"}), bundle);
        return node;
    }

    static ModelNode getConnectorDescription(Locale locale) {
        ResourceBundle bundle = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("head-comment-allowed").set(true);
        node.get("tail-comment-allowed").set(true);
        return WebSubsystemDescriptions.getConnectorCommonDescription(node, bundle);
    }

    static ModelNode getConfigurationCommonDescription(ModelNode node, ResourceBundle bundle) {
        node.get("type").set(ModelType.OBJECT);
        node.get("description").set(bundle.getString("web.configuration"));
        node.get("required").set(false);
        return node;
    }

    static ModelNode getConnectorCommonDescription(ModelNode node, ResourceBundle bundle) {
        node.get("type").set(ModelType.OBJECT);
        node.get("description").set(bundle.getString("web.connector"));
        node.get(new String[]{"attributes", "name", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "name", "description"}).set(bundle.getString("web.connector.name"));
        node.get(new String[]{"attributes", "name", "required"}).set(true);
        node.get(new String[]{"attributes", "name", "nillable"}).set(false);
        node.get(new String[]{"attributes", "protocol", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "protocol", "description"}).set(bundle.getString("web.connector.protocol"));
        node.get(new String[]{"attributes", "protocol", "required"}).set(true);
        node.get(new String[]{"attributes", "protocol", "nillable"}).set(false);
        node.get(new String[]{"attributes", "socket-binding", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "socket-binding", "description"}).set(bundle.getString("web.connector.socket-binding"));
        node.get(new String[]{"attributes", "socket-binding", "required"}).set(true);
        node.get(new String[]{"attributes", "socket-binding", "nillable"}).set(false);
        node.get(new String[]{"attributes", "scheme", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "scheme", "description"}).set(bundle.getString("web.connector.scheme"));
        node.get(new String[]{"attributes", "scheme", "required"}).set(true);
        node.get(new String[]{"attributes", "scheme", "nillable"}).set(false);
        for (String metric : WebConnectorMetrics.ATTRIBUTES) {
            node.get(new String[]{"attributes", metric, "type"}).set(ModelType.INT);
        }
        return node;
    }

    static ModelNode getConnectorAdd(Locale locale) {
        ResourceBundle bundle = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle.getString("web.connector.add"));
        node.get(new String[]{"request-properties", "protocol", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "protocol", "description"}).set(bundle.getString("web.connector.protocol"));
        node.get(new String[]{"request-properties", "protocol", "required"}).set(true);
        node.get(new String[]{"request-properties", "protocol", "nillable"}).set(false);
        node.get(new String[]{"request-properties", "socket-binding", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "socket-binding", "description"}).set(bundle.getString("web.connector.socket-binding"));
        node.get(new String[]{"request-properties", "socket-binding", "required"}).set(true);
        node.get(new String[]{"request-properties", "socket-binding", "nillable"}).set(false);
        node.get(new String[]{"request-properties", "scheme", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "scheme", "description"}).set(bundle.getString("web.connector.scheme"));
        node.get(new String[]{"request-properties", "scheme", "required"}).set(true);
        node.get(new String[]{"request-properties", "scheme", "nillable"}).set(false);
        return node;
    }

    static ModelNode getConnectorRemove(Locale locale) {
        ResourceBundle bundle = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("remove");
        node.get("description").set(bundle.getString("web.connector.remove"));
        return node;
    }

    static ModelNode getVirtualServerDescription(Locale locale) {
        ResourceBundle bundle = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("head-comment-allowed").set(true);
        node.get("tail-comment-allowed").set(true);
        return WebSubsystemDescriptions.getVirtualServerCommonDescription(node, bundle);
    }

    static ModelNode getVirtualServerCommonDescription(ModelNode node, ResourceBundle bundle) {
        node.get("type").set(ModelType.OBJECT);
        node.get("description").set(bundle.getString("web.virtual-server"));
        node.get(new String[]{"attributes", "name", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "name", "description"}).set(bundle.getString("web.virtual-server.name"));
        node.get(new String[]{"attributes", "name", "required"}).set(true);
        node.get(new String[]{"attributes", "name", "nillable"}).set(false);
        node.get(new String[]{"attributes", "alias", "type"}).set(ModelType.LIST);
        node.get(new String[]{"attributes", "alias", "description"}).set(bundle.getString("web.virtual-server.alias"));
        node.get(new String[]{"attributes", "alias", "required"}).set(false);
        node.get(new String[]{"attributes", "alias", "nillable"}).set(true);
        return node;
    }

    static ModelNode getVirtualServerAdd(Locale locale) {
        ResourceBundle bundle = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle.getString("web.virtual-server.add"));
        node.get(new String[]{"request-properties", "alias", "type"}).set(ModelType.LIST);
        node.get(new String[]{"request-properties", "alias", "description"}).set(bundle.getString("web.virtual-server.alias"));
        node.get(new String[]{"request-properties", "alias", "required"}).set(false);
        return node;
    }

    static ModelNode getVirtualServerRemove(Locale locale) {
        ResourceBundle bundle = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("remove");
        node.get("description").set(bundle.getString("web.virtual-server.remove"));
        return node;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

