/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.login.AppConfigurationEntry;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.security.Attribute;
import org.jboss.as.security.Element;
import org.jboss.as.security.service.JaasConfigurationService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.security.acl.config.ACLProviderEntry;
import org.jboss.security.audit.config.AuditProviderEntry;
import org.jboss.security.auth.container.config.AuthModuleEntry;
import org.jboss.security.auth.login.AuthenticationInfo;
import org.jboss.security.auth.login.BaseAuthenticationInfo;
import org.jboss.security.auth.login.JASPIAuthenticationInfo;
import org.jboss.security.auth.login.LoginModuleStackHolder;
import org.jboss.security.authorization.config.AuthorizationModuleEntry;
import org.jboss.security.config.ACLInfo;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.ApplicationPolicyRegistration;
import org.jboss.security.config.AuditInfo;
import org.jboss.security.config.AuthorizationInfo;
import org.jboss.security.config.ControlFlag;
import org.jboss.security.config.IdentityTrustInfo;
import org.jboss.security.config.MappingInfo;
import org.jboss.security.identitytrust.config.IdentityTrustModuleEntry;
import org.jboss.security.mapping.MappingType;
import org.jboss.security.mapping.config.MappingModuleEntry;

class SecurityDomainAdd
implements ModelAddOperationHandler {
    static final String OPERATION_NAME = "add";
    static final SecurityDomainAdd INSTANCE = new SecurityDomainAdd();

    static final ModelNode getRecreateOperation(ModelNode address, ModelNode securityDomain) {
        return Util.getOperation((String)OPERATION_NAME, (ModelNode)address, (ModelNode)securityDomain);
    }

    private SecurityDomainAdd() {
    }

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) {
        ModelNode opAddr = operation.require("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        String securityDomain = address.getLastElement().getValue();
        Util.copyParamsToModel((ModelNode)operation, (ModelNode)context.getSubModel());
        final ApplicationPolicy applicationPolicy = this.createApplicationPolicy(securityDomain, operation);
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ApplicationPolicyRegistration loginConfig = SecurityDomainAdd.this.getConfiguration(context.getServiceRegistry());
                    loginConfig.addApplicationPolicy(applicationPolicy.getName(), applicationPolicy);
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        ModelNode compensatingOperation = Util.getResourceRemoveOperation((ModelNode)opAddr);
        return new BasicOperationResult(compensatingOperation);
    }

    private ApplicationPolicy createApplicationPolicy(String securityDomain, ModelNode operation) {
        AppConfigurationEntry entry;
        HashMap<String, String> options;
        AppConfigurationEntry.LoginModuleControlFlag controlFlag;
        String codeName;
        List modules;
        AuthenticationInfo authenticationInfo;
        ApplicationPolicy applicationPolicy = new ApplicationPolicy(securityDomain);
        ModelNode node = null;
        node = operation.get(Element.AUTHENTICATION.getLocalName());
        if (node.isDefined()) {
            authenticationInfo = new AuthenticationInfo(securityDomain);
            modules = node.asList();
            for (ModelNode module : modules) {
                codeName = module.require(Attribute.CODE.getLocalName()).asString();
                controlFlag = this.getControlFlag(module.require(Attribute.FLAG.getLocalName()).asString());
                options = new HashMap<String, String>();
                if (module.hasDefined("module-options")) {
                    for (Property prop : module.get("module-options").asPropertyList()) {
                        options.put(prop.getName(), prop.getValue().asString());
                    }
                }
                entry = new AppConfigurationEntry(codeName, controlFlag, options);
                authenticationInfo.addAppConfigurationEntry(entry);
            }
            applicationPolicy.setAuthenticationInfo((BaseAuthenticationInfo)authenticationInfo);
        }
        if ((node = operation.get(Element.ACL.getLocalName())).isDefined()) {
            ACLInfo aclInfo = new ACLInfo(securityDomain);
            modules = node.asList();
            for (ModelNode module : modules) {
                codeName = module.require(Attribute.CODE.getLocalName()).asString();
                controlFlag = ControlFlag.valueOf((String)module.require(Attribute.FLAG.getLocalName()).asString());
                options = new HashMap();
                if (module.hasDefined("module-options")) {
                    for (Property prop : module.get("module-options").asPropertyList()) {
                        options.put(prop.getName(), prop.getValue().asString());
                    }
                }
                entry = new ACLProviderEntry(codeName, options);
                entry.setControlFlag((ControlFlag)controlFlag);
                aclInfo.add((Object)entry);
            }
            applicationPolicy.setAclInfo(aclInfo);
        }
        if ((node = operation.get(Element.AUDIT.getLocalName())).isDefined()) {
            AuditInfo auditInfo = new AuditInfo(securityDomain);
            modules = node.asList();
            for (ModelNode module : modules) {
                codeName = module.require(Attribute.CODE.getLocalName()).asString();
                HashMap<String, String> options2 = new HashMap<String, String>();
                if (module.hasDefined("module-options")) {
                    for (Property prop : module.get("module-options").asPropertyList()) {
                        options2.put(prop.getName(), prop.getValue().asString());
                    }
                }
                AuditProviderEntry entry2 = new AuditProviderEntry(codeName, options2);
                auditInfo.add((Object)entry2);
            }
            applicationPolicy.setAuditInfo(auditInfo);
        }
        if ((node = operation.get(Element.AUTHORIZATION.getLocalName())).isDefined()) {
            AuthorizationInfo authorizationInfo = new AuthorizationInfo(securityDomain);
            modules = node.asList();
            for (ModelNode module : modules) {
                codeName = module.require(Attribute.CODE.getLocalName()).asString();
                controlFlag = ControlFlag.valueOf((String)module.require(Attribute.FLAG.getLocalName()).asString());
                options = new HashMap();
                if (module.hasDefined("module-options")) {
                    for (Property prop : module.get("module-options").asPropertyList()) {
                        options.put(prop.getName(), prop.getValue().asString());
                    }
                }
                entry = new AuthorizationModuleEntry(codeName, options);
                entry.setControlFlag((ControlFlag)controlFlag);
                authorizationInfo.add((Object)entry);
            }
            applicationPolicy.setAuthorizationInfo(authorizationInfo);
        }
        if ((node = operation.get(Element.IDENTITY_TRUST.getLocalName())).isDefined()) {
            IdentityTrustInfo identityTrustInfo = new IdentityTrustInfo(securityDomain);
            modules = node.asList();
            for (ModelNode module : modules) {
                codeName = module.require(Attribute.CODE.getLocalName()).asString();
                controlFlag = ControlFlag.valueOf((String)module.require(Attribute.FLAG.getLocalName()).asString());
                options = new HashMap();
                if (module.hasDefined("module-options")) {
                    for (Property prop : module.get("module-options").asPropertyList()) {
                        options.put(prop.getName(), prop.getValue().asString());
                    }
                }
                entry = new IdentityTrustModuleEntry(codeName, options);
                entry.setControlFlag((ControlFlag)controlFlag);
                identityTrustInfo.add((Object)entry);
            }
            applicationPolicy.setIdentityTrustInfo(identityTrustInfo);
        }
        if ((node = operation.get(Element.MAPPING.getLocalName())).isDefined()) {
            modules = node.asList();
            String mappingType = null;
            for (ModelNode module : modules) {
                MappingInfo mappingInfo = new MappingInfo(securityDomain);
                String codeName2 = module.require(Attribute.CODE.getLocalName()).asString();
                mappingType = module.hasDefined(Attribute.TYPE.getLocalName()) ? module.get(Attribute.TYPE.getLocalName()).asString() : MappingType.ROLE.toString();
                options = new HashMap();
                if (module.hasDefined("module-options")) {
                    for (Property prop : module.get("module-options").asPropertyList()) {
                        options.put(prop.getName(), prop.getValue().asString());
                    }
                }
                entry = new MappingModuleEntry(codeName2, options, mappingType);
                mappingInfo.add((Object)entry);
                applicationPolicy.setMappingInfo(mappingType, mappingInfo);
            }
        }
        if ((node = operation.get(Element.AUTHENTICATION_JASPI.getLocalName())).isDefined()) {
            AppConfigurationEntry entry3;
            HashMap<String, String> options3;
            String code;
            authenticationInfo = new JASPIAuthenticationInfo(securityDomain);
            HashMap<String, LoginModuleStackHolder> holders = new HashMap<String, LoginModuleStackHolder>();
            ModelNode moduleStack = node.get(Element.LOGIN_MODULE_STACK.getLocalName());
            modules = moduleStack.asList();
            Iterator iter = modules.iterator();
            ModelNode nameNode = (ModelNode)iter.next();
            String name = nameNode.get(Attribute.NAME.getLocalName()).asString();
            LoginModuleStackHolder holder = new LoginModuleStackHolder(name, null);
            holders.put(name, holder);
            authenticationInfo.add(holder);
            while (iter.hasNext()) {
                ModelNode module = (ModelNode)iter.next();
                code = module.require(Attribute.CODE.getLocalName()).asString();
                AppConfigurationEntry.LoginModuleControlFlag controlFlag2 = this.getControlFlag(module.require(Attribute.FLAG.getLocalName()).asString());
                options3 = new HashMap<String, String>();
                if (module.hasDefined("module-options")) {
                    for (Property prop : module.get("module-options").asPropertyList()) {
                        options3.put(prop.getName(), prop.getValue().asString());
                    }
                }
                entry3 = new AppConfigurationEntry(code, controlFlag2, options3);
                holder.addAppConfigurationEntry(entry3);
            }
            ModelNode authModule = node.get(Element.AUTH_MODULE.getLocalName());
            code = authModule.require(Attribute.CODE.getLocalName()).asString();
            String loginStackRef = null;
            if (authModule.hasDefined(Attribute.LOGIN_MODULE_STACK_REF.getLocalName())) {
                loginStackRef = authModule.get(Attribute.LOGIN_MODULE_STACK_REF.getLocalName()).asString();
            }
            options3 = new HashMap();
            if (authModule.hasDefined("module-options")) {
                for (Property prop : authModule.get("module-options").asPropertyList()) {
                    options3.put(prop.getName(), prop.getValue().asString());
                }
            }
            entry3 = new AuthModuleEntry(code, options3, loginStackRef);
            if (loginStackRef != null) {
                if (!holders.containsKey(loginStackRef)) {
                    throw new IllegalArgumentException("auth-module references a login module stack that doesn't exist: " + loginStackRef);
                }
                entry3.setLoginModuleStackHolder((LoginModuleStackHolder)holders.get(loginStackRef));
            }
            authenticationInfo.add((AuthModuleEntry)entry3);
            applicationPolicy.setAuthenticationInfo((BaseAuthenticationInfo)authenticationInfo);
        }
        return applicationPolicy;
    }

    private synchronized ApplicationPolicyRegistration getConfiguration(ServiceRegistry serviceRegistry) {
        ServiceController controller = serviceRegistry.getRequiredService(JaasConfigurationService.SERVICE_NAME);
        return (ApplicationPolicyRegistration)controller.getValue();
    }

    private AppConfigurationEntry.LoginModuleControlFlag getControlFlag(String flag) {
        if ("required".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        }
        if ("sufficient".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        }
        if ("optional".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        }
        if ("requisite".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        }
        throw new RuntimeException(flag + " is not recognized");
    }
}

