/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.controller.BasicModelController;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.interfaces.ParsedInterfaceCriteria;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.DomainControllerService;
import org.jboss.as.domain.controller.DomainDeploymentRepository;
import org.jboss.as.domain.controller.FileRepository;
import org.jboss.as.domain.controller.HostRegistryService;
import org.jboss.as.domain.controller.LocalHostModel;
import org.jboss.as.domain.controller.MasterDomainControllerClient;
import org.jboss.as.host.controller.ConfigurationPersisterFactory;
import org.jboss.as.host.controller.HostController;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostControllerService;
import org.jboss.as.host.controller.HostModelUtil;
import org.jboss.as.host.controller.LocalFileRepository;
import org.jboss.as.host.controller.ManagedServerLifecycleCallback;
import org.jboss.as.host.controller.ProcessControllerConnectionService;
import org.jboss.as.host.controller.RemoteDomainConnectionService;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.ServerInventoryService;
import org.jboss.as.host.controller.mgmt.DomainControllerOperationHandlerService;
import org.jboss.as.host.controller.mgmt.ManagementCommunicationService;
import org.jboss.as.host.controller.mgmt.ManagementCommunicationServiceInjector;
import org.jboss.as.host.controller.mgmt.ServerToHostOperationHandler;
import org.jboss.as.process.ProcessControllerClient;
import org.jboss.as.protocol.mgmt.ManagementOperationHandler;
import org.jboss.as.server.deployment.api.DeploymentRepository;
import org.jboss.as.server.mgmt.HttpManagementService;
import org.jboss.as.server.services.net.NetworkInterfaceBinding;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.as.threads.ThreadFactoryService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class HostControllerBootstrap {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.host.controller");
    static final ServiceName SERVICE_NAME_BASE = ServiceName.JBOSS.append(new String[]{"host", "controller"});
    static final int DEFAULT_POOL_SIZE = 20;
    private final ServiceContainer serviceContainer = ServiceContainer.Factory.create();
    private final HostControllerEnvironment environment;
    private final byte[] authCode;

    public HostControllerBootstrap(HostControllerEnvironment environment, byte[] authCode) {
        this.environment = environment;
        this.authCode = authCode;
    }

    public void start() throws Exception {
        File configDir = this.environment.getDomainConfigurationDir();
        final ModelNode hostModelNode = HostModelUtil.createCoreModel();
        final ExtensibleConfigurationPersister configurationPersister = HostControllerBootstrap.createHostConfigurationPersister(configDir);
        final ModelNodeRegistration hostRegistry = HostModelUtil.createHostRegistry(configurationPersister);
        List operations = configurationPersister.load();
        final AtomicInteger count = new AtomicInteger(1);
        ResultHandler resultHandler = new ResultHandler(){

            public void handleResultFragment(String[] location, ModelNode result) {
            }

            public void handleResultComplete() {
                if (count.decrementAndGet() == 0) {
                    // empty if block
                }
            }

            public void handleFailed(ModelNode failureDescription) {
                if (count.decrementAndGet() == 0) {
                    // empty if block
                }
            }

            public void handleCancellation() {
                if (count.decrementAndGet() == 0) {
                    // empty if block
                }
            }
        };
        final class BootstrapModelController
        extends BasicModelController {
            BootstrapModelController() {
                super(modelNode, (ConfigurationPersister)extensibleConfigurationPersister, modelNodeRegistration);
            }
        }
        BootstrapModelController bootstrapContoller = new BootstrapModelController();
        for (ModelNode operation : operations) {
            count.incrementAndGet();
            operation.get("rollback-on-runtime-failure").set(false);
            bootstrapContoller.execute(OperationBuilder.Factory.create((ModelNode)operation).build(), resultHandler);
        }
        if (count.decrementAndGet() == 0) {
            // empty if block
        }
        ServiceContainer serviceTarget = this.serviceContainer;
        serviceTarget.addListener((ServiceListener)new AbstractServiceListener<Object>(){

            public void serviceFailed(ServiceController<?> serviceController, StartException reason) {
                log.errorf((Throwable)reason, "Service [%s] failed.", (Object)serviceController.getName());
            }
        });
        ProcessControllerConnectionService processControllerClient = new ProcessControllerConnectionService(this.environment, this.authCode);
        serviceTarget.addService(ProcessControllerConnectionService.SERVICE_NAME, (Service)processControllerClient).install();
        HostControllerBootstrap.activateNetworkInterfaces(hostModelNode, (ServiceTarget)serviceTarget);
        ServiceName threadFactoryServiceName = SERVICE_NAME_BASE.append(new String[]{"thread-factory"});
        ServiceName executorServiceName = SERVICE_NAME_BASE.append(new String[]{"executor"});
        serviceTarget.addService(threadFactoryServiceName, (Service)new ThreadFactoryService()).install();
        HostControllerExecutorService executorService = new HostControllerExecutorService();
        serviceTarget.addService(executorServiceName, (Service)executorService).addDependency(threadFactoryServiceName, ThreadFactory.class, executorService.threadFactoryValue).install();
        String mgmtNetwork = hostModelNode.get(new String[]{"management-interfaces", "native-interface", "interface"}).asString();
        int mgmtPort = hostModelNode.get(new String[]{"management-interfaces", "native-interface", "port"}).asInt();
        ServerInventoryService inventory = new ServerInventoryService(this.environment, mgmtPort);
        serviceTarget.addService(ServerInventoryService.SERVICE_NAME, (Service)inventory).addDependency(ProcessControllerConnectionService.SERVICE_NAME, ProcessControllerClient.class, inventory.getClient()).addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{mgmtNetwork}), NetworkInterfaceBinding.class, inventory.getInterface()).install();
        String name = hostModelNode.get("name").asString();
        HostControllerService hc = new HostControllerService(name, hostModelNode, configurationPersister, hostRegistry);
        serviceTarget.addService(HostController.SERVICE_NAME, (Service)hc).addDependency(ServerInventoryService.SERVICE_NAME, ServerInventory.class, hc.getServerInventory()).addDependency(ServerToHostOperationHandler.SERVICE_NAME).setInitialMode(ServiceController.Mode.ACTIVE).install();
        ManagementCommunicationService managementCommunicationService = new ManagementCommunicationService();
        serviceTarget.addService(ManagementCommunicationService.SERVICE_NAME, (Service)managementCommunicationService).addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{mgmtNetwork}), NetworkInterfaceBinding.class, managementCommunicationService.getInterfaceInjector()).addInjection(managementCommunicationService.getPortInjector(), (Object)mgmtPort).addDependency(executorServiceName, ExecutorService.class, managementCommunicationService.getExecutorServiceInjector()).addDependency(threadFactoryServiceName, ThreadFactory.class, managementCommunicationService.getThreadFactoryInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
        HostControllerBootstrap.activateDomainController(this.environment, hostModelNode, (ServiceTarget)serviceTarget, this.environment.isBackupDomainFiles(), this.environment.isUseCachedDc());
        if (hostModelNode.get("management-interfaces").hasDefined("http-interface")) {
            HttpManagementService service = new HttpManagementService();
            serviceTarget.addService(HttpManagementService.SERVICE_NAME, (Service)service).addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{hostModelNode.get(new String[]{"management-interfaces", "http-interface"}).require("interface").asString()}), NetworkInterfaceBinding.class, service.getInterfaceInjector()).addDependency(DomainController.SERVICE_NAME, ModelController.class, service.getModelControllerInjector()).addInjection((Injector)service.getTempDirInjector(), (Object)this.environment.getDomainTempDir().getAbsolutePath()).addInjection(service.getPortInjector(), (Object)hostModelNode.get(new String[]{"management-interfaces", "http-interface"}).require("port").asInt()).addDependency(executorServiceName, ExecutorService.class, service.getExecutorServiceInjector()).setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)new ResultHandler.ServiceStartListener(resultHandler)).install();
        }
        ServerToHostOperationHandler serverToHost = new ServerToHostOperationHandler();
        serviceTarget.addService(ServerToHostOperationHandler.SERVICE_NAME, (Service)serverToHost).addDependency(ServerInventoryService.SERVICE_NAME, ManagedServerLifecycleCallback.class, serverToHost.getCallback()).addDependency(ManagementCommunicationService.SERVICE_NAME, ManagementCommunicationService.class, (Injector)new ManagementCommunicationServiceInjector((Value<? extends ManagementOperationHandler>)serverToHost)).install();
    }

    static void activateDomainController(HostControllerEnvironment environment, ModelNode host, ServiceTarget serviceTarget, boolean backupDomainFiles, boolean useCachedDc) {
        boolean slave;
        LocalFileRepository fileRepository = new LocalFileRepository(environment);
        boolean bl = slave = !host.get("domain-controller").hasDefined("local");
        if (slave) {
            HostControllerBootstrap.installRemoteDomainControllerConnection(environment, host, serviceTarget, fileRepository);
        }
        HostControllerBootstrap.installLocalDomainController(environment, host, serviceTarget, slave, fileRepository, backupDomainFiles, useCachedDc);
    }

    static void installLocalDomainController(HostControllerEnvironment environment, ModelNode host, ServiceTarget serviceTarget, boolean isSlave, FileRepository fileRepository, boolean backupDomainFiles, boolean useCachedDc) {
        String hostName = host.get("name").asString();
        String mgmtNetwork = host.get(new String[]{"management-interfaces", "native-interface", "interface"}).asString();
        int mgmtPort = host.get(new String[]{"management-interfaces", "native-interface", "port"}).asInt();
        serviceTarget.addService(HostRegistryService.SERVICE_NAME, (Service)new HostRegistryService()).install();
        File configDir = environment.getDomainConfigurationDir();
        ExtensibleConfigurationPersister domainConfigurationPersister = HostControllerBootstrap.createDomainConfigurationPersister(configDir, isSlave);
        DomainDeploymentRepository deploymentRepository = new DomainDeploymentRepository(environment.getDomainDeploymentDir());
        DomainControllerService dcService = new DomainControllerService(domainConfigurationPersister, hostName, mgmtPort, (DeploymentRepository)deploymentRepository, fileRepository, backupDomainFiles, useCachedDc);
        ServiceBuilder builder = serviceTarget.addService(DomainController.SERVICE_NAME, (Service)dcService);
        if (isSlave) {
            builder.addDependency(MasterDomainControllerClient.SERVICE_NAME, MasterDomainControllerClient.class, dcService.getMasterDomainControllerClientInjector());
        }
        builder.addDependency(SERVICE_NAME_BASE.append(new String[]{"executor"}), ScheduledExecutorService.class, dcService.getScheduledExecutorServiceInjector()).addDependency(HostController.SERVICE_NAME, LocalHostModel.class, dcService.getHostControllerServiceInjector()).addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{mgmtNetwork}), NetworkInterfaceBinding.class, dcService.getInterfaceInjector()).addDependency(HostRegistryService.SERVICE_NAME, HostRegistryService.class, (Injector)dcService.getHostRegistryInjector()).install();
        DomainControllerOperationHandlerService operationHandlerService = new DomainControllerOperationHandlerService(isSlave);
        serviceTarget.addService(DomainControllerOperationHandlerService.SERVICE_NAME, (Service)operationHandlerService).addDependency(ManagementCommunicationService.SERVICE_NAME, ManagementCommunicationService.class, operationHandlerService.getManagementCommunicationServiceValue()).addDependency(DomainController.SERVICE_NAME, ModelController.class, (Injector)operationHandlerService.getModelControllerValue()).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    static void installRemoteDomainControllerConnection(HostControllerEnvironment environment, ModelNode host, ServiceTarget serviceTarget, FileRepository repository) {
        InetAddress addr;
        String name;
        try {
            name = host.require("name").asString();
        }
        catch (NoSuchElementException e1) {
            throw new IllegalArgumentException("A host connecting to a remote domain controller must have its name attribute set");
        }
        ModelNode dc = host.require("domain-controller").require("remote");
        try {
            addr = InetAddress.getByName(dc.require("host").asString());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        int port = dc.require("port").asInt();
        RemoteDomainConnectionService service = new RemoteDomainConnectionService(name, addr, port, repository);
        serviceTarget.addService(MasterDomainControllerClient.SERVICE_NAME, (Service)service).addDependency(ManagementCommunicationService.SERVICE_NAME, ManagementCommunicationService.class, service.getManagementCommunicationServiceInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    static void activateNetworkInterfaces(ModelNode host, ServiceTarget serviceTarget) {
        for (Property iFace : host.get("interface").asPropertyList()) {
            String interfaceName = iFace.getName();
            ParsedInterfaceCriteria criteria = ParsedInterfaceCriteria.parse((ModelNode)iFace.getValue().require("criteria"));
            serviceTarget.addService(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{interfaceName}), NetworkInterfaceService.create((String)interfaceName, (ParsedInterfaceCriteria)criteria)).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        }
    }

    static ExtensibleConfigurationPersister createHostConfigurationPersister(File configDir) {
        return ConfigurationPersisterFactory.createHostXmlConfigurationPersister(configDir);
    }

    static ExtensibleConfigurationPersister createDomainConfigurationPersister(File configDir, boolean isSlave) {
        if (isSlave) {
            return ConfigurationPersisterFactory.createDomainXmlConfigurationPersister(configDir, "cached-remote-domain.xml");
        }
        return ConfigurationPersisterFactory.createDomainXmlConfigurationPersister(configDir);
    }

    static final class HostControllerExecutorService
    implements Service<Executor> {
        final InjectedValue<ThreadFactory> threadFactoryValue = new InjectedValue();
        private ScheduledExecutorService executorService;

        HostControllerExecutorService() {
        }

        public synchronized void start(StartContext context) throws StartException {
            this.executorService = Executors.newScheduledThreadPool(20, (ThreadFactory)this.threadFactoryValue.getValue());
        }

        public synchronized void stop(StopContext context) {
            this.executorService.shutdown();
        }

        public synchronized ScheduledExecutorService getValue() throws IllegalStateException {
            return this.executorService;
        }
    }
}

