/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.controller.remote.RemoteProxyController;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.host.controller.HostController;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.operations.ServerRestartHandler;
import org.jboss.as.host.controller.operations.ServerStartHandler;
import org.jboss.as.host.controller.operations.ServerStatusHandler;
import org.jboss.as.host.controller.operations.ServerStopHandler;
import org.jboss.as.protocol.Connection;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class HostControllerImpl
implements HostController {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.host.controller");
    private final String name;
    private final ServerInventory serverInventory;
    private final ModelNode model;
    private final ModelNodeRegistration registry;
    private volatile DomainController domainController;

    HostControllerImpl(String name, ModelNode model, ExtensibleConfigurationPersister configurationPersister, ModelNodeRegistration registry, ServerInventory serverInventory) {
        this.model = model;
        this.registry = registry;
        this.name = name;
        this.serverInventory = serverInventory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ServerStatus getServerStatus(String serverName) {
        ServerInventory servers = this.serverInventory;
        return servers.determineServerStatus(serverName);
    }

    @Override
    public ServerStatus startServer(String serverName) {
        if (this.domainController == null) {
            throw new IllegalStateException(String.format("Domain Controller is not available; cannot start server %s", serverName));
        }
        ServerInventory servers = this.serverInventory;
        return servers.startServer(serverName, this.getHostModel().clone(), this.domainController);
    }

    @Override
    public ServerStatus restartServer(String serverName) {
        return this.restartServer(serverName, -1);
    }

    @Override
    public ServerStatus restartServer(String serverName, int gracefulTimeout) {
        if (this.domainController == null) {
            throw new IllegalStateException(String.format("Domain Controller is not available; cannot restart server %s", serverName));
        }
        ServerInventory servers = this.serverInventory;
        return servers.restartServer(serverName, gracefulTimeout, this.getHostModel().clone(), this.domainController);
    }

    @Override
    public ServerStatus stopServer(String serverName) {
        return this.stopServer(serverName, -1);
    }

    @Override
    public ServerStatus stopServer(String serverName, int gracefulTimeout) {
        ServerInventory servers = this.serverInventory;
        return servers.stopServer(serverName, gracefulTimeout);
    }

    @Override
    public void registerRunningServer(String serverName, Connection connection) {
        PathElement element = PathElement.pathElement((String)"server", (String)serverName);
        ProxyController serverController = RemoteProxyController.create((Connection)connection, (PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)this.name), element}));
        this.registry.registerProxyController(element, serverController);
        this.model.get(new String[]{element.getKey(), element.getValue()});
    }

    @Override
    public void unregisterRunningServer(String serverName) {
        PathElement element = PathElement.pathElement((String)"server", (String)serverName);
        this.model.get(element.getKey()).remove(element.getValue());
        this.registry.unregisterProxyController(element);
    }

    @Override
    public void startServers(DomainController domainController) {
        this.domainController = domainController;
        ModelNode rawModel = this.getHostModel();
        if (rawModel.hasDefined("server-config")) {
            ModelNode servers = rawModel.get("server-config").clone();
            for (String serverName : servers.keys()) {
                if (!servers.get(new String[]{serverName, "auto-start"}).asBoolean(true)) continue;
                try {
                    this.startServer(serverName);
                }
                catch (Exception e) {
                    log.errorf((Throwable)e, "failed to start server (%s)", (Object)serverName);
                }
            }
        }
    }

    @Override
    public void stopServers() {
        ModelNode rawModel = this.getHostModel();
        this.domainController = null;
        if (rawModel.hasDefined("server-config")) {
            ModelNode servers = rawModel.get("server-config").clone();
            for (String serverName : servers.keys()) {
                if (!servers.get(new String[]{serverName, "auto-start"}).asBoolean(true)) continue;
                try {
                    this.stopServer(serverName);
                }
                catch (Exception e) {
                    log.errorf((Throwable)e, "failed to stop server (%s)", (Object)serverName);
                }
            }
        }
    }

    ModelNode getHostModel() {
        if (this.domainController == null) {
            throw new IllegalStateException();
        }
        return this.domainController.getDomainAndHostModel().get(new String[]{"host", this.name});
    }

    protected void registerInternalOperations() {
        ServerStartHandler startHandler = new ServerStartHandler(this);
        ServerRestartHandler restartHandler = new ServerRestartHandler(this);
        ServerStopHandler stopHandler = new ServerStopHandler(this);
        ModelNodeRegistration servers = this.registry.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"server-config")}));
        servers.registerMetric("status", (OperationHandler)new ServerStatusHandler(this));
        servers.registerOperationHandler("start", (OperationHandler)startHandler, (DescriptionProvider)startHandler, false);
        servers.registerOperationHandler("restart", (OperationHandler)restartHandler, (DescriptionProvider)restartHandler, false);
        servers.registerOperationHandler("stop", (OperationHandler)stopHandler, (DescriptionProvider)stopHandler, false);
    }
}

