/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.net.SocketFactory;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.process.ProcessControllerClient;
import org.jboss.as.process.ProcessInfo;
import org.jboss.as.process.ProcessMessageHandler;
import org.jboss.as.protocol.ProtocolClient;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class ProcessControllerConnectionService
implements Service<ProcessControllerClient> {
    static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"host", "controller", "process-controller-connection"});
    final InjectedValue<ServerInventory> serverInventory = new InjectedValue();
    private final HostControllerEnvironment environment;
    private final byte[] authCode;
    private ProcessControllerClient client;

    ProcessControllerConnectionService(HostControllerEnvironment environment, byte[] authCode) {
        this.environment = environment;
        this.authCode = authCode;
    }

    public synchronized void start(StartContext context) throws StartException {
        ProcessControllerClient client;
        try {
            ProtocolClient.Configuration configuration = new ProtocolClient.Configuration();
            configuration.setReadExecutor((Executor)Executors.newCachedThreadPool());
            configuration.setServerAddress(new InetSocketAddress(this.environment.getProcessControllerAddress(), (int)this.environment.getProcessControllerPort()));
            configuration.setThreadFactory(Executors.defaultThreadFactory());
            configuration.setSocketFactory(SocketFactory.getDefault());
            client = ProcessControllerClient.connect((ProtocolClient.Configuration)configuration, (byte[])this.authCode, (ProcessMessageHandler)new ProcessMessageHandler(){

                public void handleProcessAdded(ProcessControllerClient client, String processName) {
                }

                public void handleProcessStarted(ProcessControllerClient client, String processName) {
                }

                public void handleProcessStopped(ProcessControllerClient client, String processName, long uptimeMillis) {
                }

                public void handleProcessRemoved(ProcessControllerClient client, String processName) {
                }

                public void handleProcessInventory(ProcessControllerClient client, Map<String, ProcessInfo> inventory) {
                }

                public void handleConnectionShutdown(ProcessControllerClient client) {
                }

                public void handleConnectionFailure(ProcessControllerClient client, IOException cause) {
                }

                public void handleConnectionFinished(ProcessControllerClient client) {
                }
            });
            client.requestProcessInventory();
        }
        catch (IOException e) {
            throw new StartException((Throwable)e);
        }
        this.client = client;
    }

    public synchronized void stop(StopContext context) {
        ProcessControllerClient client = this.client;
        this.client = null;
        StreamUtils.safeClose((Closeable)client);
    }

    public synchronized ProcessControllerClient getValue() throws IllegalStateException, IllegalArgumentException {
        ProcessControllerClient client = this.client;
        if (client == null) {
            throw new IllegalStateException();
        }
        return client;
    }
}

