/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.cdi;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.servlet.http.HttpSession;
import org.jboss.jsfunit.cdi.BasicAuthentication;
import org.jboss.jsfunit.cdi.Browser;
import org.jboss.jsfunit.cdi.BrowserVersion;
import org.jboss.jsfunit.cdi.Cookies;
import org.jboss.jsfunit.cdi.FormAuthentication;
import org.jboss.jsfunit.cdi.InitialPage;
import org.jboss.jsfunit.cdi.InitialRequest;
import org.jboss.jsfunit.cdi.Proxy;
import org.jboss.jsfunit.framework.BasicAuthenticationStrategy;
import org.jboss.jsfunit.framework.Environment;
import org.jboss.jsfunit.framework.FormAuthenticationStrategy;
import org.jboss.jsfunit.framework.InitialRequestStrategy;
import org.jboss.jsfunit.framework.WebClientSpec;
import org.jboss.jsfunit.framework.WebConversationFactory;
import org.jboss.jsfunit.jsfsession.JSFClientSession;
import org.jboss.jsfunit.jsfsession.JSFServerSession;
import org.jboss.jsfunit.jsfsession.JSFSession;

public class JSFSessionFactory {
    public static final String JSFSESSION_FIELD_INJECTED = JSFSessionFactory.class.getName() + ".JSFSESSION_FIELD_INJECTED";
    public static final String JSFSESSION_METHOD_INJECTED = JSFSessionFactory.class.getName() + ".JSFSESSION_METHOD_INJECTED";

    private Annotation getAnnotation(Class annoClass, InjectionPoint injectionPoint, ElementType injectionType) {
        if (injectionType == ElementType.METHOD) {
            Method method = (Method)injectionPoint.getMember();
            return method.getAnnotation(annoClass);
        }
        if (injectionType == ElementType.FIELD) {
            Class<?> clazz = injectionPoint.getMember().getDeclaringClass();
            return clazz.getAnnotation(annoClass);
        }
        return null;
    }

    WebClientSpec createWebClientSpec(InjectionPoint injectionPoint, ElementType injectionType) {
        String password;
        String userName;
        Annotation initialPage = this.getAnnotation(InitialPage.class, injectionPoint, injectionType);
        if (initialPage == null) {
            throw new IllegalArgumentException("@InitialPage required for injection.  Specify at class level for field injection or at method level for method injection.");
        }
        Browser browser = null;
        Annotation browserAnno = this.getAnnotation(BrowserVersion.class, injectionPoint, injectionType);
        if (browserAnno == null) {
            browser = Browser.DEFAULT;
        }
        if (browserAnno != null) {
            browser = ((BrowserVersion)browserAnno).value();
        }
        String host = null;
        int port = 0;
        Proxy proxyAnno = (Proxy)this.getAnnotation(Proxy.class, injectionPoint, injectionType);
        if (proxyAnno != null) {
            host = proxyAnno.host();
            port = proxyAnno.port();
        }
        WebClientSpec wcSpec = new WebClientSpec(((InitialPage)initialPage).value(), browser.getVersion(), host, port);
        BasicAuthentication basicAuthAnno = (BasicAuthentication)this.getAnnotation(BasicAuthentication.class, injectionPoint, injectionType);
        FormAuthentication formAuthAnno = (FormAuthentication)this.getAnnotation(FormAuthentication.class, injectionPoint, injectionType);
        InitialRequest initReqAnno = (InitialRequest)this.getAnnotation(InitialRequest.class, injectionPoint, injectionType);
        this.validateOneNonNullInitialRequest(injectionType, basicAuthAnno, formAuthAnno, initReqAnno);
        if (basicAuthAnno != null) {
            userName = basicAuthAnno.userName();
            password = basicAuthAnno.password();
            wcSpec.setInitialRequestStrategy((InitialRequestStrategy)new BasicAuthenticationStrategy(userName, password));
        }
        if (formAuthAnno != null) {
            userName = formAuthAnno.userName();
            password = formAuthAnno.password();
            String submitComponent = formAuthAnno.submitComponent();
            String userNameComponent = formAuthAnno.userNameComponent();
            String passwordComponent = formAuthAnno.passwordComponent();
            wcSpec.setInitialRequestStrategy((InitialRequestStrategy)new FormAuthenticationStrategy(userName, password, submitComponent, userNameComponent, passwordComponent));
        }
        if (initReqAnno != null) {
            Class clazz = initReqAnno.value();
            InitialRequestStrategy initReq = (InitialRequestStrategy)Environment.newInstance((Class)clazz);
            wcSpec.setInitialRequestStrategy(initReq);
        }
        this.setCookies(wcSpec, injectionPoint, injectionType);
        return wcSpec;
    }

    private void setCookies(WebClientSpec wcSpec, InjectionPoint injectionPoint, ElementType injectionType) {
        String[] values;
        Cookies cookiesAnno = (Cookies)this.getAnnotation(Cookies.class, injectionPoint, injectionType);
        if (cookiesAnno == null) {
            return;
        }
        String[] names = cookiesAnno.names();
        if (names.length != (values = cookiesAnno.values()).length) {
            throw new IllegalArgumentException("'names' and 'values' must have equal number of elements in @Cookies annotation.");
        }
        for (int i = 0; i < names.length; ++i) {
            wcSpec.addCookie(names[i], values[i]);
        }
    }

    private void validateOneNonNullInitialRequest(ElementType injectionType, Annotation ... initRequests) {
        boolean found = false;
        for (Annotation anno : initRequests) {
            if (anno != null && found) {
                if (injectionType == ElementType.METHOD) {
                    throw new IllegalArgumentException("Only one of @BasicAuthentication, @FormAuthentication, or @InitialRequest is allowed per method.");
                }
                if (injectionType == ElementType.FIELD) {
                    throw new IllegalArgumentException("Only one of @BasicAuthentication, @FormAuthentication, or @InitialRequest is allowed at the class level.");
                }
            }
            if (anno == null) continue;
            found = true;
        }
    }

    JSFSession createJSFSession(InjectionPoint injectionPoint, ElementType injectionType, HttpSession httpSession) throws IOException {
        JSFSession jsfSession = new JSFSession(this.createWebClientSpec(injectionPoint, injectionType));
        if (injectionType == ElementType.FIELD) {
            httpSession.setAttribute(JSFSESSION_FIELD_INJECTED, (Object)jsfSession);
        }
        if (injectionType == ElementType.METHOD) {
            httpSession.setAttribute(JSFSESSION_METHOD_INJECTED, (Object)jsfSession);
        }
        return jsfSession;
    }

    @Produces
    JSFSession findJSFSession(InjectionPoint injectionPoint) throws IOException {
        ElementType injectionType = this.getElementType(injectionPoint);
        HttpSession httpSession = WebConversationFactory.getSessionFromThreadLocal();
        JSFSession jsfSession = null;
        if (injectionType == ElementType.FIELD) {
            jsfSession = (JSFSession)httpSession.getAttribute(JSFSESSION_FIELD_INJECTED);
        }
        if (injectionType == ElementType.METHOD) {
            jsfSession = (JSFSession)httpSession.getAttribute(JSFSESSION_METHOD_INJECTED);
        }
        if (jsfSession != null) {
            return jsfSession;
        }
        jsfSession = this.createJSFSession(injectionPoint, injectionType, httpSession);
        return jsfSession;
    }

    @Produces
    JSFClientSession getJSFClientSession(InjectionPoint injectionPoint) throws IOException {
        return this.findJSFSession(injectionPoint).getJSFClientSession();
    }

    @Produces
    JSFServerSession getJSFServerSession(InjectionPoint injectionPoint) throws IOException {
        return this.findJSFSession(injectionPoint).getJSFServerSession();
    }

    private ElementType getElementType(InjectionPoint injectionPoint) {
        Member member = injectionPoint.getMember();
        if (member instanceof Method) {
            return ElementType.METHOD;
        }
        if (member instanceof Field) {
            return ElementType.FIELD;
        }
        throw new IllegalArgumentException("JSFUnit artifacts are only injectable at method or field.  Found InjectionPoint Member " + injectionPoint.getMember());
    }
}

