/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.listener;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ManagedConnection;
import javax.transaction.SystemException;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.connectionmanager.listener.ConnectionState;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.logging.Logger;

public abstract class AbstractConnectionListener
implements ConnectionListener {
    private final Logger log = Logger.getLogger(this.getClass());
    protected boolean trace;
    private final ConnectionManager cm;
    private final ManagedConnection managedConnection;
    private final Pool pool;
    private final Object internalManagedPoolContext;
    private ConnectionState state = ConnectionState.NORMAL;
    private final CopyOnWriteArrayList<Object> connectionHandles = new CopyOnWriteArrayList();
    private final AtomicBoolean trackByTx = new AtomicBoolean(false);
    private long lastUse;
    private long lastValidated;

    protected AbstractConnectionListener(ConnectionManager cm, ManagedConnection managedConnection, Pool pool, Object context) {
        this.cm = cm;
        this.managedConnection = managedConnection;
        this.pool = pool;
        this.internalManagedPoolContext = context;
        this.trace = this.log.isTraceEnabled();
        this.lastUse = System.currentTimeMillis();
    }

    protected CachedConnectionManager getCachedConnectionManager() {
        return this.cm.getCachedConnectionManager();
    }

    protected ConnectionManager getConnectionManager() {
        return this.cm;
    }

    protected Logger getLog() {
        return this.log;
    }

    @Override
    public void delist() throws ResourceException {
    }

    @Override
    public void enlist() throws SystemException {
    }

    @Override
    public Object getContext() {
        return this.internalManagedPoolContext;
    }

    @Override
    public long getLastValidatedTime() {
        return this.lastValidated;
    }

    public ManagedConnection getManagedConnection() {
        return this.managedConnection;
    }

    @Override
    public Pool getPool() {
        return this.pool;
    }

    @Override
    public ConnectionState getState() {
        return this.state;
    }

    @Override
    public boolean isManagedConnectionFree() {
        return this.connectionHandles.isEmpty();
    }

    @Override
    public boolean isTimedOut(long timeout) {
        return this.lastUse < timeout;
    }

    @Override
    public boolean isTrackByTx() {
        return this.trackByTx.get();
    }

    @Override
    public void registerConnection(Object handle) {
        if (handle != null) {
            this.connectionHandles.add(handle);
        } else {
            this.log.info((Object)("Registered a null handle for managedConnection: " + this.managedConnection));
        }
    }

    @Override
    public void setLastValidatedTime(long lastValidated) {
        this.lastValidated = lastValidated;
    }

    @Override
    public void setState(ConnectionState newState) {
        this.state = newState;
    }

    @Override
    public void setTrackByTx(boolean trackByTx) {
        this.trackByTx.set(trackByTx);
    }

    @Override
    public void tidyup() throws ResourceException {
    }

    @Override
    public void unregisterConnection(Object handle) {
        if (handle != null) {
            if (!this.connectionHandles.remove(handle)) {
                this.log.info((Object)("Unregistered handle that was not registered! " + handle + " for managedConnection: " + this.managedConnection));
            }
        } else {
            this.log.info((Object)("Unregistered a null handle for managedConnection: " + this.managedConnection));
        }
        if (this.trace) {
            this.log.trace((Object)("unregisterConnection: " + this.connectionHandles.size() + " handles left"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterConnections() {
        try {
            for (Object handle : this.connectionHandles) {
                if (this.getCachedConnectionManager() == null) continue;
                this.getCachedConnectionManager().unregisterConnection(this.getConnectionManager(), handle);
            }
        }
        finally {
            this.connectionHandles.clear();
        }
    }

    @Override
    public void used() {
        this.lastUse = System.currentTimeMillis();
    }

    public void connectionClosed(ConnectionEvent event) {
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        if (this.state == ConnectionState.NORMAL) {
            if (event != null) {
                Exception cause = event.getException();
                if (cause == null) {
                    cause = new Exception("No exception was reported");
                }
                this.log.warn((Object)("Connection error occured: " + this), (Throwable)cause);
            } else {
                Exception cause = new Exception("No exception was reported");
                this.log.warn((Object)("Unknown Connection error occured: " + this), (Throwable)cause);
            }
        }
        try {
            this.unregisterConnections();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (event != null && event.getSource() != this.getManagedConnection()) {
            this.log.warn((Object)"Notified of error on a different managed connection?");
        }
        this.getConnectionManager().returnManagedConnection(this, true);
    }

    public void localTransactionCommitted(ConnectionEvent event) {
    }

    public void localTransactionRolledback(ConnectionEvent event) {
    }

    public void localTransactionStarted(ConnectionEvent event) {
    }

    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        if (!(o instanceof AbstractConnectionListener)) {
            throw new ClassCastException("Not correct type: " + o.getClass().getName());
        }
        AbstractConnectionListener acl = (AbstractConnectionListener)o;
        if (this.lastUse < acl.lastUse) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(this.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(this)));
        buffer.append("[state=");
        if (this.state.equals((Object)ConnectionState.NORMAL)) {
            buffer.append("NORMAL");
        } else if (this.state.equals((Object)ConnectionState.DESTROY)) {
            buffer.append("DESTROY");
        } else if (this.state.equals((Object)ConnectionState.DESTROYED)) {
            buffer.append("DESTROYED");
        } else {
            buffer.append("UNKNOWN?");
        }
        buffer.append(" managed connection=").append(this.managedConnection);
        buffer.append(" connection handles=").append(this.connectionHandles.size());
        buffer.append(" lastUse=").append(this.lastUse);
        buffer.append(" trackByTx=").append(this.trackByTx.get());
        buffer.append(" pool=").append(this.pool);
        buffer.append(" pool internal context=").append(this.internalManagedPoolContext);
        this.toString(buffer);
        buffer.append(']');
        return buffer.toString();
    }

    protected void toString(StringBuffer buffer) {
    }
}

