/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool.mcp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.RetryableUnavailableException;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.security.auth.Subject;
import org.jboss.jca.common.JBossResourceException;
import org.jboss.jca.core.api.connectionmanager.pool.PoolConfiguration;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListenerFactory;
import org.jboss.jca.core.connectionmanager.listener.ConnectionState;
import org.jboss.jca.core.connectionmanager.pool.SubPoolContext;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.idle.IdleRemover;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPool;
import org.jboss.jca.core.connectionmanager.pool.mcp.PoolFiller;
import org.jboss.jca.core.connectionmanager.pool.validator.ConnectionValidator;
import org.jboss.logging.Logger;

public class ArrayBlockingQueueManagedConnectionPool
implements ManagedConnectionPool {
    private Logger log;
    private boolean trace;
    private ManagedConnectionFactory mcf;
    private ConnectionListenerFactory clf;
    private Subject defaultSubject;
    private ConnectionRequestInfo defaultCri;
    private PoolConfiguration poolConfiguration;
    private Pool pool;
    private int maxSize;
    private ArrayBlockingQueue<ConnectionListener> cls;
    private ConcurrentMap<ConnectionListener, ConnectionListener> permits;
    private SubPoolContext subPool;
    private final ConcurrentSkipListSet<ConnectionListener> checkedOut = new ConcurrentSkipListSet();
    private AtomicBoolean started = new AtomicBoolean(false);
    private AtomicBoolean shutdown = new AtomicBoolean(false);
    private AtomicInteger maxUsedConnections = new AtomicInteger(0);

    @Override
    public void initialize(ManagedConnectionFactory mcf, ConnectionListenerFactory clf, Subject subject, ConnectionRequestInfo cri, PoolConfiguration pc, Pool p, SubPoolContext spc, Logger log) {
        this.mcf = mcf;
        this.clf = clf;
        this.defaultSubject = subject;
        this.defaultCri = cri;
        this.poolConfiguration = pc;
        this.maxSize = pc.getMaxSize();
        this.pool = p;
        this.subPool = spc;
        this.log = log;
        this.trace = log.isTraceEnabled();
        this.cls = new ArrayBlockingQueue(this.maxSize, true);
        this.permits = new ConcurrentHashMap<ConnectionListener, ConnectionListener>(this.maxSize);
        if (pc.isPrefill()) {
            PoolFiller.fillPool(this);
        }
        this.reenable();
    }

    @Override
    public SubPoolContext getSubPool() {
        return this.subPool;
    }

    @Override
    public boolean isRunning() {
        return !this.shutdown.get();
    }

    @Override
    public boolean isEmpty() {
        return this.cls.size() == 0 && this.checkedOut.size() == 0;
    }

    @Override
    public void reenable() {
        if (this.poolConfiguration.getIdleTimeout() > 0L) {
            IdleRemover.registerPool(this, this.poolConfiguration.getIdleTimeout());
        }
        if (this.poolConfiguration.isBackgroundValidation() && this.poolConfiguration.getBackgroundValidationInterval() > 0L) {
            this.log.debug((Object)("Registering for background validation at interval " + this.poolConfiguration.getBackgroundValidationInterval()));
            ConnectionValidator.registerPool(this, this.poolConfiguration.getBackgroundValidationInterval());
        }
        this.shutdown.set(false);
    }

    private synchronized long getAvailableConnections() {
        int result = this.maxSize - this.permits.size();
        return result >= 0 ? (long)result : 0L;
    }

    @Override
    public ConnectionListener getConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        subject = subject == null ? this.defaultSubject : subject;
        cri = cri == null ? this.defaultCri : cri;
        ConnectionListener cl = null;
        boolean verifyConnectionListener = true;
        long startWait = System.currentTimeMillis();
        if (this.getAvailableConnections() > 0L) {
            if (this.shutdown.get()) {
                throw new RetryableUnavailableException("The pool has been shutdown");
            }
            cl = this.cls.peek();
            if (cl != null) {
                try {
                    cl = this.cls.poll(this.poolConfiguration.getBlockingTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ie) {
                    long end = System.currentTimeMillis() - startWait;
                    throw new ResourceException("Interrupted while requesting connection! Waited " + end + " ms");
                }
            } else {
                try {
                    cl = this.createConnectionEventListener(subject, cri);
                    if (!this.started.getAndSet(true) && this.poolConfiguration.getMinSize() > 0) {
                        PoolFiller.fillPool(this);
                    }
                    if (this.trace) {
                        this.log.trace((Object)("supplying new ManagedConnection: " + cl));
                    }
                    verifyConnectionListener = false;
                }
                catch (Throwable t) {
                    this.log.warn((Object)("Throwable while attempting to get a new connection: " + cl), t);
                    JBossResourceException.rethrowAsResourceException((String)("Unexpected throwable while trying to create a connection: " + cl), (Throwable)t);
                }
            }
        } else {
            try {
                cl = this.cls.poll(this.poolConfiguration.getBlockingTimeout(), TimeUnit.MILLISECONDS);
                if (this.shutdown.get()) {
                    throw new RetryableUnavailableException("The pool has been shutdown");
                }
            }
            catch (InterruptedException ie) {
                if (!this.poolConfiguration.isUseFastFail()) {
                    throw new ResourceException("No ManagedConnections available within configured blocking timeout ( " + this.poolConfiguration.getBlockingTimeout() + " [ms] )");
                }
                if (this.trace) {
                    this.log.trace((Object)"Fast failing for connection attempt. No more attempts will be made to acquire connection from pool and a new connection will be created immeadiately");
                }
                try {
                    cl = this.createConnectionEventListener(subject, cri);
                    if (!this.started.getAndSet(true) && this.poolConfiguration.getMinSize() > 0) {
                        PoolFiller.fillPool(this);
                    }
                    if (this.trace) {
                        this.log.trace((Object)("supplying new ManagedConnection: " + cl));
                    }
                    verifyConnectionListener = false;
                }
                catch (Throwable t) {
                    this.log.warn((Object)("Throwable while attempting to get a new connection: " + cl), t);
                    JBossResourceException.rethrowAsResourceException((String)("Unexpected throwable while trying to create a connection: " + cl), (Throwable)t);
                }
            }
        }
        this.checkedOut.add(cl);
        int size = this.maxSize - this.permits.size();
        if (size > this.maxUsedConnections.get()) {
            this.maxUsedConnections.set(size);
        }
        if (!verifyConnectionListener) {
            this.permits.put(cl, cl);
            return cl;
        }
        try {
            ManagedConnection matchedMC = this.mcf.matchManagedConnections(Collections.singleton(cl.getManagedConnection()), subject, cri);
            if (matchedMC != null) {
                if (this.trace) {
                    this.log.trace((Object)("supplying ManagedConnection from pool: " + cl));
                }
                this.permits.put(cl, cl);
                return cl;
            }
            this.log.warn((Object)("Destroying connection that could not be successfully matched: " + cl + " for: " + this.mcf));
            this.checkedOut.remove(cl);
            this.doDestroy(cl);
            cl = null;
        }
        catch (Throwable t) {
            this.log.warn((Object)("Throwable while trying to match ManagedConnection, destroying connection: " + cl), t);
            this.checkedOut.remove(cl);
            this.doDestroy(cl);
            cl = null;
            JBossResourceException.rethrowAsResourceException((String)("Unexpected throwable while trying to create a connection: " + cl), (Throwable)t);
        }
        throw new JBossResourceException("This should never happen", new Throwable("STACKTRACE"));
    }

    @Override
    public void returnConnection(ConnectionListener cl, boolean kill) {
        if (cl.getState() == ConnectionState.DESTROYED) {
            if (this.trace) {
                this.log.trace((Object)("ManagedConnection is being returned after it was destroyed" + cl));
            }
            if (this.permits.containsKey(cl)) {
                this.permits.remove(cl);
            }
            return;
        }
        if (this.trace) {
            this.log.trace((Object)("putting ManagedConnection back into pool kill=" + kill + " cl=" + cl));
        }
        try {
            cl.getManagedConnection().cleanup();
        }
        catch (ResourceException re) {
            this.log.warn((Object)("ResourceException cleaning up ManagedConnection: " + cl), (Throwable)re);
            kill = true;
        }
        if (cl.getState() == ConnectionState.DESTROY || cl.getState() == ConnectionState.DESTROYED) {
            kill = true;
        }
        this.checkedOut.remove(cl);
        if (!kill && this.cls.size() >= this.poolConfiguration.getMaxSize()) {
            this.log.warn((Object)("Destroying returned connection, maximum pool size exceeded " + cl));
            kill = true;
        }
        if (kill) {
            this.cls.remove(cl);
        } else {
            cl.used();
            if (!this.cls.contains(cl)) {
                try {
                    this.cls.put(cl);
                }
                catch (InterruptedException ie) {
                    cl.setState(ConnectionState.DESTROY);
                    kill = true;
                }
            } else {
                this.log.warn((Object)("Attempt to return connection twice (ignored): " + cl), new Throwable("STACKTRACE"));
            }
        }
        if (this.permits.containsKey(cl)) {
            this.permits.remove(cl);
        }
        if (kill) {
            if (this.trace) {
                this.log.trace((Object)("Destroying returned connection " + cl));
            }
            this.doDestroy(cl);
        }
    }

    @Override
    public void flush() {
        ArrayList<ConnectionListener> destroy = null;
        if (this.trace) {
            this.log.trace((Object)("Flushing pool checkedOut=" + this.checkedOut + " inPool=" + this.cls));
        }
        for (ConnectionListener cl : this.checkedOut) {
            if (this.trace) {
                this.log.trace((Object)("Flush marking checked out connection for destruction " + cl));
            }
            cl.setState(ConnectionState.DESTROY);
        }
        ConnectionListener cl = this.cls.poll();
        while (cl != null) {
            if (destroy == null) {
                destroy = new ArrayList<ConnectionListener>();
            }
            destroy.add(cl);
            cl = this.cls.poll();
        }
        if (destroy != null) {
            for (int i = 0; i < destroy.size(); ++i) {
                ConnectionListener l = (ConnectionListener)destroy.get(i);
                if (this.trace) {
                    this.log.trace((Object)("Destroying flushed connection " + l));
                }
                this.doDestroy(l);
            }
            if (!this.shutdown.get() && this.poolConfiguration.getMinSize() > 0) {
                PoolFiller.fillPool(this);
            }
        }
    }

    @Override
    public void removeIdleConnections() {
        ArrayList<ConnectionListener> destroy = null;
        long timeout = System.currentTimeMillis() - this.poolConfiguration.getIdleTimeout();
        boolean cont = true;
        while (cont) {
            ConnectionListener cl = this.cls.peek();
            if (cl != null && cl.isTimedOut(timeout) && this.shouldRemove()) {
                if (destroy == null) {
                    destroy = new ArrayList<ConnectionListener>(1);
                }
                if ((cl = this.cls.poll()) != null) {
                    destroy.add(cl);
                    continue;
                }
                cont = false;
                continue;
            }
            cont = false;
        }
        if (destroy != null) {
            for (int i = 0; i < destroy.size(); ++i) {
                ConnectionListener cl = (ConnectionListener)destroy.get(i);
                if (this.trace) {
                    this.log.trace((Object)("Destroying timedout connection " + cl));
                }
                this.doDestroy(cl);
            }
            if (!this.shutdown.get() && this.poolConfiguration.getMinSize() > 0) {
                PoolFiller.fillPool(this);
            }
            if (this.pool != null) {
                this.pool.emptySubPool(this);
            }
        }
    }

    @Override
    public void shutdown() {
        this.shutdown.set(true);
        IdleRemover.unregisterPool(this);
        ConnectionValidator.unregisterPool(this);
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillToMin() {
        while (this.poolConfiguration.getMinSize() - (this.cls.size() + this.checkedOut.size()) > 0) {
            if (this.shutdown.get()) {
                return;
            }
            ConnectionListener cl = null;
            boolean destroy = false;
            try {
                cl = this.createConnectionEventListener(this.defaultSubject, this.defaultCri);
                if (this.checkedOut.size() + this.cls.size() < this.poolConfiguration.getMinSize()) {
                    if (this.trace) {
                        this.log.trace((Object)("Filling pool cl=" + cl));
                    }
                    if (this.cls.offer(cl)) continue;
                    this.log.debug((Object)"Connection couldn't be inserted during fillToMin");
                    destroy = true;
                    continue;
                }
                this.log.debug((Object)"MinSize reached during fillToMin");
                destroy = true;
            }
            catch (ResourceException re) {
                this.log.warn((Object)"Unable to fill pool ", (Throwable)re);
                destroy = true;
            }
            finally {
                if (!destroy) continue;
                if (cl == null) break;
                this.doDestroy(cl);
                break;
            }
        }
    }

    private ConnectionListener createConnectionEventListener(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        ManagedConnection mc = this.mcf.createManagedConnection(subject, cri);
        try {
            return this.clf.createConnectionListener(mc, this);
        }
        catch (ResourceException re) {
            mc.destroy();
            throw re;
        }
    }

    private void doDestroy(ConnectionListener cl) {
        if (cl.getState() == ConnectionState.DESTROYED) {
            this.log.trace((Object)("ManagedConnection is already destroyed " + cl));
            return;
        }
        cl.setState(ConnectionState.DESTROYED);
        try {
            cl.getManagedConnection().destroy();
        }
        catch (Throwable t) {
            this.log.debug((Object)("Exception destroying ManagedConnection " + cl), t);
        }
    }

    private boolean shouldRemove() {
        boolean remove = true;
        if (this.poolConfiguration.isStrictMin()) {
            boolean bl = remove = this.cls.size() > this.poolConfiguration.getMinSize();
            if (this.trace) {
                this.log.trace((Object)("StrictMin is active. Current connection will be removed is " + remove));
            }
        }
        return remove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void validateConnections() throws Exception {
        block12: {
            if (this.trace) {
                this.log.trace((Object)("Attempting to  validate connections for pool " + this));
            }
            anyDestroyed = false;
            while (true) lbl-1000:
            // 5 sources

            {
                cl = null;
                destroyed = false;
                if (this.cls.size() == 0) {
                    break block12;
                }
                cl = this.removeForFrequencyCheck();
                if (cl == null) {
                    break block12;
                }
                try {
                    candidateSet = Collections.singleton(cl.getManagedConnection());
                    if (this.mcf instanceof ValidatingManagedConnectionFactory) {
                        vcf = (ValidatingManagedConnectionFactory)this.mcf;
                        if ((candidateSet = vcf.getInvalidConnections(candidateSet)) == null || candidateSet.size() <= 0 || cl.getState() == ConnectionState.DESTROY) ** GOTO lbl-1000
                        this.doDestroy(cl);
                        destroyed = true;
                        anyDestroyed = true;
                    }
                    this.log.warn((Object)"Warning: Background validation was specified with a non compliant ManagedConnectionFactory interface.");
                }
                finally {
                    if (destroyed || this.returnForFrequencyCheck(cl)) continue;
                    anyDestroyed = true;
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                if (anyDestroyed && !this.shutdown.get() && this.poolConfiguration.getMinSize() > 0) {
                    PoolFiller.fillPool(this);
                }
            }
        }
    }

    private ConnectionListener removeForFrequencyCheck() {
        this.log.debug((Object)"Checking for connection within frequency");
        ConnectionListener result = null;
        Iterator<ConnectionListener> iter = this.cls.iterator();
        while (result == null && iter.hasNext()) {
            ConnectionListener cl = iter.next();
            long lastCheck = cl.getLastValidatedTime();
            if (System.currentTimeMillis() - lastCheck < this.poolConfiguration.getBackgroundValidationInterval()) continue;
            result = cl;
            this.cls.remove(cl);
        }
        return result;
    }

    private boolean returnForFrequencyCheck(ConnectionListener cl) {
        this.log.debug((Object)("Returning for connection within frequency: " + cl));
        if (cl == null) {
            return true;
        }
        cl.setLastValidatedTime(System.currentTimeMillis());
        if (!this.cls.offer(cl)) {
            this.log.debug((Object)"Connection couldn't be returned");
            this.doDestroy(cl);
            return false;
        }
        return true;
    }
}

