/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.transaction;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.jca.core.spi.transaction.local.TransactionLocal;
import org.jboss.logging.Logger;
import org.jboss.util.NestedRuntimeException;

public class TransactionSynchronizer
implements Synchronization {
    private static Logger log = Logger.getLogger(TransactionSynchronizer.class);
    private static TransactionLocal txSynchs;
    private Transaction tx;
    private Thread enlistingThread;
    private CopyOnWriteArrayList<Synchronization> unenlisted = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<Synchronization> enlisted = new CopyOnWriteArrayList();
    private Synchronization ccmSynch;
    private ReentrantLock lockObject = new ReentrantLock(true);
    private Condition condition = this.lockObject.newCondition();

    public static void setTransactionIntegration(TransactionIntegration ti) {
        txSynchs = ti.createTransactionLocal();
    }

    private TransactionSynchronizer(Transaction tx) {
        this.tx = tx;
    }

    public void addUnenlisted(Synchronization synch) {
        this.unenlisted.add(synch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Synchronization> getUnenlisted() {
        Thread currentThread = Thread.currentThread();
        while (this.enlistingThread != null && this.enlistingThread != currentThread) {
            boolean interrupted = false;
            try {
                this.lockObject.lock();
                this.condition.await();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
            finally {
                this.lockObject.unlock();
            }
            if (!interrupted) continue;
            currentThread.interrupt();
        }
        CopyOnWriteArrayList<Synchronization> result = this.unenlisted;
        this.unenlisted = null;
        if (result != null) {
            this.enlistingThread = currentThread;
        }
        return result;
    }

    public void addEnlisted(Synchronization synch) {
        this.enlisted.add(synch);
    }

    public boolean removeEnlisted(Synchronization synch) {
        return this.enlisted.remove(synch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enlisted() {
        try {
            this.lockObject.lock();
            Thread currentThread = Thread.currentThread();
            if (this.enlistingThread == null || this.enlistingThread != currentThread) {
                log.warn((Object)("Thread " + currentThread + " not the enlisting thread " + this.enlistingThread), (Throwable)new Exception("STACKTRACE"));
                return;
            }
            this.enlistingThread = null;
            this.condition.signalAll();
        }
        finally {
            this.lockObject.unlock();
        }
    }

    public static TransactionSynchronizer getRegisteredSynchronizer(Transaction tx) throws SystemException, RollbackException {
        TransactionSynchronizer result = (TransactionSynchronizer)txSynchs.get(tx);
        if (result == null) {
            result = new TransactionSynchronizer(tx);
            tx.registerSynchronization((Synchronization)result);
            txSynchs.set(tx, (Object)result);
        }
        return result;
    }

    public static Synchronization getCCMSynchronization(Transaction tx) {
        TransactionSynchronizer ts = (TransactionSynchronizer)txSynchs.get(tx);
        if (ts != null) {
            return ts.ccmSynch;
        }
        return null;
    }

    public static void registerCCMSynchronization(Transaction tx, Synchronization synch) throws Exception {
        TransactionSynchronizer ts = TransactionSynchronizer.getRegisteredSynchronizer(tx);
        ts.ccmSynch = synch;
    }

    public static void lock(Transaction tx) {
        try {
            txSynchs.lock(tx);
        }
        catch (InterruptedException e) {
            throw new NestedRuntimeException("Unable to get synchronization", (Throwable)e);
        }
    }

    public static void unlock(Transaction tx) {
        txSynchs.unlock(tx);
    }

    public void beforeCompletion() {
        if (this.enlisted != null) {
            for (int i = 0; i < this.enlisted.size(); ++i) {
                Synchronization synch = this.enlisted.get(i);
                this.invokeBefore(synch);
            }
        }
        if (this.ccmSynch != null) {
            this.invokeBefore(this.ccmSynch);
        }
    }

    public void afterCompletion(int status) {
        if (this.enlisted != null) {
            for (int i = 0; i < this.enlisted.size(); ++i) {
                Synchronization synch = this.enlisted.get(i);
                this.invokeAfter(synch, status);
            }
        }
        if (this.ccmSynch != null) {
            this.invokeAfter(this.ccmSynch, status);
        }
    }

    protected void invokeBefore(Synchronization synch) {
        try {
            synch.beforeCompletion();
        }
        catch (Throwable t) {
            log.warn((Object)("Transaction " + this.tx + " error in before completion " + synch), t);
        }
    }

    protected void invokeAfter(Synchronization synch, int status) {
        try {
            synch.afterCompletion(status);
        }
        catch (Throwable t) {
            log.warn((Object)("Transaction " + this.tx + " error in after completion " + synch), t);
        }
    }
}

