/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.tx;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashSet;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.security.auth.Subject;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.jboss.jca.common.JBossResourceException;
import org.jboss.jca.core.api.connectionmanager.ConnectionManager;
import org.jboss.jca.core.connectionmanager.AbstractConnectionManager;
import org.jboss.jca.core.connectionmanager.ConnectionRecord;
import org.jboss.jca.core.connectionmanager.TxConnectionManager;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.connectionmanager.listener.TxConnectionListener;
import org.jboss.jca.core.connectionmanager.pool.SubPoolContext;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPool;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.jca.core.spi.transaction.TransactionTimeoutConfiguration;
import org.jboss.jca.core.spi.transaction.TxUtils;
import org.jboss.jca.core.spi.transaction.local.TransactionLocal;
import org.jboss.util.NestedRuntimeException;
import org.jboss.util.NotImplementedException;

public class TxConnectionManagerImpl
extends AbstractConnectionManager
implements TxConnectionManager {
    private static final long serialVersionUID = 1L;
    private transient TransactionManager transactionManager;
    private TransactionIntegration txIntegration;
    private boolean interleaving;
    private boolean localTransactions;
    private int xaResourceTimeout = 0;
    private boolean padXid;
    private boolean wrapXAResource = true;
    private boolean isSameRMOverride;

    public TxConnectionManagerImpl(TransactionIntegration txIntegration, boolean localTransactions) {
        if (txIntegration == null) {
            throw new IllegalArgumentException("TransactionIntegration is null");
        }
        this.transactionManager = txIntegration.getTransactionManager();
        this.txIntegration = txIntegration;
        this.setLocalTransactions(localTransactions);
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public TransactionIntegration getTransactionIntegration() {
        return this.txIntegration;
    }

    @Override
    public boolean isInterleaving() {
        return this.interleaving;
    }

    public void setInterleaving(boolean value) {
        this.interleaving = value;
    }

    @Override
    public boolean isLocalTransactions() {
        return this.localTransactions;
    }

    void setLocalTransactions(boolean v) {
        this.localTransactions = v;
        if (v) {
            this.setInterleaving(false);
        }
    }

    @Override
    public int getXAResourceTimeout() {
        return this.xaResourceTimeout;
    }

    public void setXAResourceTimeout(int timeout) {
        this.xaResourceTimeout = timeout;
    }

    @Override
    public boolean getIsSameRMOverride() {
        return this.isSameRMOverride;
    }

    public void setIsSameRMOverride(boolean v) {
        this.isSameRMOverride = v;
    }

    @Override
    public boolean getWrapXAResource() {
        return this.wrapXAResource;
    }

    public void setWrapXAResource(boolean v) {
        this.wrapXAResource = v;
    }

    @Override
    public boolean getPadXid() {
        return this.padXid;
    }

    public void setPadXid(boolean v) {
        this.padXid = v;
    }

    public long getTimeLeftBeforeTransactionTimeout(boolean errorRollback) throws RollbackException {
        if (this.transactionManager == null) {
            throw new IllegalStateException("No transaction manager: " + this.getCachedConnectionManager());
        }
        if (this.transactionManager instanceof TransactionTimeoutConfiguration) {
            return ((TransactionTimeoutConfiguration)this.transactionManager).getTimeLeftBeforeTransactionTimeout(errorRollback);
        }
        return -1L;
    }

    @Override
    public ConnectionListener getManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        Transaction trackByTransaction = null;
        try {
            Transaction tx = this.transactionManager.getTransaction();
            if (tx != null && !TxUtils.isActive((Transaction)tx)) {
                throw new ResourceException("Transaction is not active: tx=" + tx);
            }
            if (!this.interleaving) {
                trackByTransaction = tx;
            }
        }
        catch (Throwable t) {
            JBossResourceException.rethrowAsResourceException((String)"Error checking for a transaction.", (Throwable)t);
        }
        this.getLog().tracef("getManagedConnection interleaving=%s , tx=%s", (Object)this.interleaving, (Object)trackByTransaction);
        return super.getManagedConnection(trackByTransaction, subject, cri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transactionStarted(Collection<ConnectionRecord> crs) throws SystemException {
        HashSet<ConnectionListener> cls = new HashSet<ConnectionListener>(crs.size());
        for (ConnectionRecord cr : crs) {
            ConnectionListener cl = cr.getConnectionListener();
            if (cls.contains(cl)) continue;
            cls.add(cl);
            cl.enlist();
            if (this.isInterleaving()) continue;
            cl.setTrackByTx(true);
            ManagedConnectionPool mcp = (ManagedConnectionPool)cl.getContext();
            SubPoolContext subPool = mcp.getSubPool();
            TransactionLocal trackByTx = subPool.getTrackByTx();
            try {
                trackByTx.lock();
            }
            catch (Throwable t) {
                TxConnectionManagerImpl.rethrowAsSystemException("Unable to begin transaction with JCA lazy enlistment scenario", trackByTx.getTransaction(), t);
            }
            try {
                trackByTx.set((Object)cl);
            }
            finally {
                trackByTx.unlock();
            }
        }
    }

    @Override
    protected void managedConnectionReconnected(ConnectionListener cl) throws ResourceException {
        try {
            cl.enlist();
        }
        catch (Throwable t) {
            this.getLog().trace((Object)("Could not enlist in transaction on entering meta-aware object! " + cl), t);
            throw new JBossResourceException("Could not enlist in transaction on entering meta-aware object!", t);
        }
    }

    @Override
    protected void managedConnectionDisconnected(ConnectionListener cl) throws ResourceException {
        Throwable throwable = null;
        try {
            cl.delist();
        }
        catch (Throwable t) {
            throwable = t;
        }
        if (cl.isManagedConnectionFree()) {
            this.getLog().tracef("Disconnected isManagedConnectionFree=true cl=%s", (Object)cl);
            this.returnManagedConnection(cl, false);
        } else {
            this.getLog().tracef("Disconnected isManagedConnectionFree=false cl=%s", (Object)cl);
        }
        if (throwable != null) {
            JBossResourceException.rethrowAsResourceException((String)"Could not delist resource, probably a transaction rollback? ", (Throwable)throwable);
        }
    }

    @Override
    public ConnectionListener createConnectionListener(ManagedConnection mc, Object context) throws ResourceException {
        Object xaResource = null;
        if (this.localTransactions) {
            xaResource = this.txIntegration.createLocalXAResource((ConnectionManager)this);
            if (this.xaResourceTimeout != 0) {
                this.getLog().debug((Object)("XAResource transaction timeout cannot be set for local transactions: " + this.getJndiName()));
            }
        } else {
            if (this.wrapXAResource) {
                String eisProductName = null;
                String eisProductVersion = null;
                try {
                    if (mc.getMetaData() != null) {
                        eisProductName = mc.getMetaData().getEISProductName();
                        eisProductVersion = mc.getMetaData().getEISProductVersion();
                    }
                }
                catch (ResourceException re) {
                    // empty catch block
                }
                if (eisProductName == null) {
                    eisProductName = this.getJndiName();
                }
                if (eisProductVersion == null) {
                    eisProductVersion = this.getJndiName();
                }
                this.getLog().tracef("Generating XAResourceWrapper for TxConnectionManager (%s)", (Object)this);
                xaResource = this.txIntegration.createXAResourceWrapper(mc.getXAResource(), this.padXid, Boolean.valueOf(this.isSameRMOverride), eisProductName, eisProductVersion, this.getJndiName());
            } else {
                this.getLog().tracef("Not wrapping XAResource.", new Object[0]);
                xaResource = mc.getXAResource();
            }
            if (this.xaResourceTimeout != 0) {
                try {
                    if (!xaResource.setTransactionTimeout(this.xaResourceTimeout)) {
                        this.getLog().debug((Object)("XAResource does not support transaction timeout configuration: " + this.getJndiName()));
                    }
                }
                catch (XAException e) {
                    throw new JBossResourceException("Unable to set XAResource transaction timeout: " + this.getJndiName(), (Throwable)e);
                }
            }
        }
        TxConnectionListener cli = new TxConnectionListener(this, mc, this.getPool(), context, (XAResource)xaResource);
        mc.addConnectionEventListener((ConnectionEventListener)cli);
        return cli;
    }

    @Override
    public boolean isTransactional() {
        try {
            return !TxUtils.isCompleted((Transaction)this.transactionManager.getTransaction());
        }
        catch (SystemException se) {
            throw new RuntimeException("Error during isTransactional()", se);
        }
    }

    public int getTransactionTimeout() throws SystemException {
        throw new NotImplementedException("NYI: getTransactionTimeout()");
    }

    public static void rethrowAsSystemException(String context, Transaction tx, Throwable t) throws SystemException {
        if (t instanceof SystemException) {
            throw (SystemException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RollbackException) {
            throw new IllegalStateException(context + " tx=" + tx + " marked for rollback.");
        }
        throw new NestedRuntimeException(context + " tx=" + tx + " got unexpected error ", t);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }
}

