/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.naming;

import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.resource.Referenceable;
import org.jboss.jca.core.spi.naming.JndiStrategy;
import org.jboss.logging.Logger;
import org.jboss.util.naming.Util;

public class ExplicitJndiStrategy
implements JndiStrategy {
    private static Logger log = Logger.getLogger(ExplicitJndiStrategy.class);
    private static boolean trace = log.isTraceEnabled();
    private static ConcurrentMap<String, Object> objs = new ConcurrentHashMap<String, Object>();

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)obj;
        String className = (String)ref.get("class").getContent();
        String cfname = (String)ref.get("name").getContent();
        return objs.get(ExplicitJndiStrategy.qualifiedName(cfname, className));
    }

    public String[] bindConnectionFactories(String deployment, Object[] cfs) throws Throwable {
        throw new IllegalStateException("JNDI names are required");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] bindConnectionFactories(String deployment, Object[] cfs, String[] jndis) throws Throwable {
        if (deployment == null) {
            throw new IllegalArgumentException("Deployment is null");
        }
        if (deployment.trim().equals("")) {
            throw new IllegalArgumentException("Deployment is empty");
        }
        if (cfs == null) {
            throw new IllegalArgumentException("CFS is null");
        }
        if (cfs.length == 0) {
            throw new IllegalArgumentException("CFS is empty");
        }
        if (jndis == null) {
            throw new IllegalArgumentException("JNDIs is null");
        }
        if (jndis.length == 0) {
            throw new IllegalArgumentException("JNDIs is empty");
        }
        if (cfs.length != jndis.length) {
            throw new IllegalArgumentException("Number of connection factories doesn't match number of JNDI names");
        }
        InitialContext context = new InitialContext();
        try {
            for (int i = 0; i < cfs.length; ++i) {
                String jndiName = jndis[i];
                Object cf = cfs[i];
                if (trace) {
                    log.trace((Object)("Binding " + cf.getClass().getName() + " under " + jndiName));
                }
                if (cf == null) {
                    throw new IllegalArgumentException("Connection factory is null");
                }
                if (jndiName == null) {
                    throw new IllegalArgumentException("JNDI name is null");
                }
                String className = cf.getClass().getName();
                Reference ref = new Reference(className, new StringRefAddr("class", className), ExplicitJndiStrategy.class.getName(), null);
                ref.add(new StringRefAddr("name", jndiName));
                if (objs.putIfAbsent(ExplicitJndiStrategy.qualifiedName(jndiName, className), cf) != null) {
                    throw new Exception("Deployment " + className + " failed, " + jndiName + " is already deployed");
                }
                Referenceable referenceable = (Referenceable)cf;
                referenceable.setReference(ref);
                Util.bind((Context)context, (String)jndiName, (Object)cf);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Bound " + cf.getClass().getName() + " under " + jndiName));
            }
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException ne) {}
            }
        }
        return jndis;
    }

    public void unbindConnectionFactories(String deployment, Object[] cfs) throws Throwable {
        throw new IllegalStateException("JNDI names are required");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindConnectionFactories(String deployment, Object[] cfs, String[] jndis) throws Throwable {
        if (cfs == null) {
            throw new IllegalArgumentException("CFS is null");
        }
        if (cfs.length == 0) {
            throw new IllegalArgumentException("CFS is empty");
        }
        if (jndis == null) {
            throw new IllegalArgumentException("JNDIs is null");
        }
        if (jndis.length == 0) {
            throw new IllegalArgumentException("JNDIs is empty");
        }
        if (cfs.length != jndis.length) {
            throw new IllegalArgumentException("Number of connection factories doesn't match number of JNDI names");
        }
        InitialContext context = null;
        try {
            context = new InitialContext();
            for (int i = 0; i < cfs.length; ++i) {
                String jndiName = jndis[i];
                Object cf = cfs[i];
                if (cf == null) {
                    throw new IllegalArgumentException("Connection factory is null");
                }
                if (jndiName == null) {
                    throw new IllegalArgumentException("JNDI name is null");
                }
                String className = cf.getClass().getName();
                if (trace) {
                    log.trace((Object)("Unbinding " + className + " under " + jndiName));
                }
                Util.unbind((Context)context, (String)jndiName);
                objs.remove(ExplicitJndiStrategy.qualifiedName(jndiName, className));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Unbound " + className + " under " + jndiName));
            }
        }
        catch (Throwable t) {
            log.warn((Object)"Exception during unbind", t);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException ne) {}
            }
        }
    }

    public String[] bindAdminObjects(String deployment, Object[] aos) throws Throwable {
        throw new IllegalStateException("JNDI names are required");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] bindAdminObjects(String deployment, Object[] aos, String[] jndis) throws Throwable {
        if (deployment == null) {
            throw new IllegalArgumentException("Deployment is null");
        }
        if (deployment.trim().equals("")) {
            throw new IllegalArgumentException("Deployment is empty");
        }
        if (aos == null) {
            throw new IllegalArgumentException("AOS is null");
        }
        if (aos.length == 0) {
            throw new IllegalArgumentException("AOS is empty");
        }
        if (jndis == null) {
            throw new IllegalArgumentException("JNDIs is null");
        }
        if (jndis.length == 0) {
            throw new IllegalArgumentException("JNDIs is empty");
        }
        if (aos.length != jndis.length) {
            throw new IllegalArgumentException("Number of admin objects doesn't match number of JNDI names");
        }
        InitialContext context = new InitialContext();
        try {
            for (int i = 0; i < aos.length; ++i) {
                String jndiName = jndis[i];
                Object ao = aos[i];
                if (trace) {
                    log.trace((Object)("Binding " + ao.getClass().getName() + " under " + jndiName));
                }
                if (ao == null) {
                    throw new IllegalArgumentException("Admin object is null");
                }
                if (jndiName == null) {
                    throw new IllegalArgumentException("JNDI name is null");
                }
                String className = ao.getClass().getName();
                Reference ref = new Reference(className, new StringRefAddr("class", className), ExplicitJndiStrategy.class.getName(), null);
                ref.add(new StringRefAddr("name", jndiName));
                if (objs.putIfAbsent(ExplicitJndiStrategy.qualifiedName(jndiName, className), ao) != null) {
                    throw new Exception("Deployment " + className + " failed, " + jndiName + " is already deployed");
                }
                Referenceable referenceable = (Referenceable)ao;
                referenceable.setReference(ref);
                Util.bind((Context)context, (String)jndiName, (Object)ao);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Bound " + ao.getClass().getName() + " under " + jndiName));
            }
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException ne) {}
            }
        }
        return jndis;
    }

    public void unbindAdminObjects(String deployment, Object[] aos) throws Throwable {
        throw new IllegalStateException("JNDI names are required");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindAdminObjects(String deployment, Object[] aos, String[] jndis) throws Throwable {
        if (aos == null) {
            throw new IllegalArgumentException("AOS is null");
        }
        if (aos.length == 0) {
            throw new IllegalArgumentException("AOS is empty");
        }
        if (jndis == null) {
            throw new IllegalArgumentException("JNDIs is null");
        }
        if (jndis.length == 0) {
            throw new IllegalArgumentException("JNDIs is empty");
        }
        if (aos.length != jndis.length) {
            throw new IllegalArgumentException("Number of admin objects doesn't match number of JNDI names");
        }
        InitialContext context = null;
        try {
            context = new InitialContext();
            for (int i = 0; i < aos.length; ++i) {
                String jndiName = jndis[i];
                Object ao = aos[i];
                if (ao == null) {
                    throw new IllegalArgumentException("Admin object is null");
                }
                if (jndiName == null) {
                    throw new IllegalArgumentException("JNDI name is null");
                }
                String className = ao.getClass().getName();
                if (trace) {
                    log.trace((Object)("Unbinding " + className + " under " + jndiName));
                }
                Util.unbind((Context)context, (String)jndiName);
                objs.remove(ExplicitJndiStrategy.qualifiedName(jndiName, className));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Unbound " + className + " under " + jndiName));
            }
        }
        catch (Throwable t) {
            log.warn((Object)"Exception during unbind", t);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException ne) {}
            }
        }
    }

    public JndiStrategy clone() throws CloneNotSupportedException {
        return (JndiStrategy)super.clone();
    }

    private static String qualifiedName(String name, String className) {
        return className + "#" + name;
    }
}

