/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.naming;

import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.resource.Referenceable;
import org.jboss.jca.core.spi.naming.JndiStrategy;
import org.jboss.logging.Logger;
import org.jboss.util.naming.Util;

public class SimpleJndiStrategy
implements JndiStrategy {
    private static Logger log = Logger.getLogger(SimpleJndiStrategy.class);
    private static boolean trace = log.isTraceEnabled();
    private static final String CF_JNDI_PREFIX = "java:/eis/";
    private static final String AO_JNDI_PREFIX = "java:/eis/ao/";
    private static ConcurrentMap<String, Object> objs = new ConcurrentHashMap<String, Object>();

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)obj;
        String className = (String)ref.get("class").getContent();
        String cfname = (String)ref.get("name").getContent();
        return objs.get(SimpleJndiStrategy.qualifiedName(cfname, className));
    }

    public String[] bindConnectionFactories(String deployment, Object[] cfs) throws Throwable {
        String jndiName = CF_JNDI_PREFIX + deployment;
        return this.bindConnectionFactories(deployment, cfs, new String[]{jndiName});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] bindConnectionFactories(String deployment, Object[] cfs, String[] jndis) throws Throwable {
        if (deployment == null) {
            throw new IllegalArgumentException("Deployment is null");
        }
        if (deployment.trim().equals("")) {
            throw new IllegalArgumentException("Deployment is empty");
        }
        if (cfs == null) {
            throw new IllegalArgumentException("CFS is null");
        }
        if (cfs.length == 0) {
            throw new IllegalArgumentException("CFS is empty");
        }
        if (cfs.length > 1) {
            throw new IllegalArgumentException("SimpleJndiStrategy only support a single connection factory per deployment");
        }
        if (jndis == null) {
            throw new IllegalArgumentException("JNDIs is null");
        }
        if (jndis.length == 0) {
            throw new IllegalArgumentException("JNDIs is empty");
        }
        if (jndis.length > 1) {
            throw new IllegalArgumentException("SimpleJndiStrategy only support a single JNDI name per deployment");
        }
        String jndiName = jndis[0];
        Object cf = cfs[0];
        if (trace) {
            log.trace((Object)("Binding " + cf.getClass().getName() + " under " + jndiName));
        }
        if (cf == null) {
            throw new IllegalArgumentException("Connection factory is null");
        }
        if (jndiName == null) {
            throw new IllegalArgumentException("JNDI name is null");
        }
        InitialContext context = new InitialContext();
        try {
            String className = cf.getClass().getName();
            Reference ref = new Reference(className, new StringRefAddr("class", className), SimpleJndiStrategy.class.getName(), null);
            ref.add(new StringRefAddr("name", jndiName));
            if (objs.putIfAbsent(SimpleJndiStrategy.qualifiedName(jndiName, className), cf) != null) {
                throw new Exception("Deployment " + className + " failed, " + jndiName + " is already deployed");
            }
            Referenceable referenceable = (Referenceable)cf;
            referenceable.setReference(ref);
            Util.bind((Context)context, (String)jndiName, (Object)cf);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Bound " + cf.getClass().getName() + " under " + jndiName));
            }
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException ne) {}
            }
        }
        return new String[]{jndiName};
    }

    public void unbindConnectionFactories(String deployment, Object[] cfs) throws Throwable {
        String jndiName = CF_JNDI_PREFIX + deployment;
        this.unbindConnectionFactories(deployment, cfs, new String[]{jndiName});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindConnectionFactories(String deployment, Object[] cfs, String[] jndis) throws Throwable {
        if (cfs == null) {
            throw new IllegalArgumentException("CFS is null");
        }
        if (cfs.length == 0) {
            throw new IllegalArgumentException("CFS is empty");
        }
        if (cfs.length > 1) {
            throw new IllegalArgumentException("SimpleJndiStrategy only support a single connection factory per deployment");
        }
        if (jndis == null) {
            throw new IllegalArgumentException("JNDIs is null");
        }
        if (jndis.length == 0) {
            throw new IllegalArgumentException("JNDIs is empty");
        }
        if (jndis.length > 1) {
            throw new IllegalArgumentException("SimpleJndiStrategy only support a single JNDI name per deployment");
        }
        String jndiName = jndis[0];
        Object cf = cfs[0];
        if (cf == null) {
            throw new IllegalArgumentException("Connection factory is null");
        }
        if (jndiName == null) {
            throw new IllegalArgumentException("JNDI name is null");
        }
        String className = cf.getClass().getName();
        if (trace) {
            log.trace((Object)("Unbinding " + className + " under " + jndiName));
        }
        InitialContext context = null;
        try {
            context = new InitialContext();
            Util.unbind((Context)context, (String)jndiName);
            objs.remove(SimpleJndiStrategy.qualifiedName(jndiName, className));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unbound " + className + " under " + jndiName));
            }
        }
        catch (Throwable t) {
            log.warn((Object)"Exception during unbind", t);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException ne) {}
            }
        }
    }

    public String[] bindAdminObjects(String deployment, Object[] aos) throws Throwable {
        String jndiName = AO_JNDI_PREFIX + deployment;
        return this.bindAdminObjects(deployment, aos, new String[]{jndiName});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] bindAdminObjects(String deployment, Object[] aos, String[] jndis) throws Throwable {
        if (deployment == null) {
            throw new IllegalArgumentException("Deployment is null");
        }
        if (deployment.trim().equals("")) {
            throw new IllegalArgumentException("Deployment is empty");
        }
        if (aos == null) {
            throw new IllegalArgumentException("AOS is null");
        }
        if (aos.length == 0) {
            throw new IllegalArgumentException("AOS is empty");
        }
        if (aos.length > 1) {
            throw new IllegalArgumentException("SimpleJndiStrategy only support a single admin object per deployment");
        }
        if (jndis == null) {
            throw new IllegalArgumentException("JNDIs is null");
        }
        if (jndis.length == 0) {
            throw new IllegalArgumentException("JNDIs is empty");
        }
        if (jndis.length > 1) {
            throw new IllegalArgumentException("SimpleJndiStrategy only support a single JNDI name per deployment");
        }
        String jndiName = jndis[0];
        Object ao = aos[0];
        if (trace) {
            log.trace((Object)("Binding " + ao.getClass().getName() + " under " + jndiName));
        }
        if (ao == null) {
            throw new IllegalArgumentException("Admin object is null");
        }
        if (jndiName == null) {
            throw new IllegalArgumentException("JNDI name is null");
        }
        InitialContext context = new InitialContext();
        try {
            String className = ao.getClass().getName();
            Reference ref = new Reference(className, new StringRefAddr("class", className), SimpleJndiStrategy.class.getName(), null);
            ref.add(new StringRefAddr("name", jndiName));
            if (objs.putIfAbsent(SimpleJndiStrategy.qualifiedName(jndiName, className), ao) != null) {
                throw new Exception("Deployment " + className + " failed, " + jndiName + " is already deployed");
            }
            Referenceable referenceable = (Referenceable)ao;
            referenceable.setReference(ref);
            Util.bind((Context)context, (String)jndiName, (Object)ao);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Bound " + ao.getClass().getName() + " under " + jndiName));
            }
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException ne) {}
            }
        }
        return new String[]{jndiName};
    }

    public void unbindAdminObjects(String deployment, Object[] aos) throws Throwable {
        String jndiName = AO_JNDI_PREFIX + deployment;
        this.unbindAdminObjects(deployment, aos, new String[]{jndiName});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindAdminObjects(String deployment, Object[] aos, String[] jndis) throws Throwable {
        if (aos == null) {
            throw new IllegalArgumentException("AOS is null");
        }
        if (aos.length == 0) {
            throw new IllegalArgumentException("AOS is empty");
        }
        if (aos.length > 1) {
            throw new IllegalArgumentException("SimpleJndiStrategy only support a single admin object per deployment");
        }
        if (jndis == null) {
            throw new IllegalArgumentException("JNDIs is null");
        }
        if (jndis.length == 0) {
            throw new IllegalArgumentException("JNDIs is empty");
        }
        if (jndis.length > 1) {
            throw new IllegalArgumentException("SimpleJndiStrategy only support a single JNDI name per deployment");
        }
        String jndiName = jndis[0];
        Object ao = aos[0];
        if (ao == null) {
            throw new IllegalArgumentException("Admin object is null");
        }
        if (jndiName == null) {
            throw new IllegalArgumentException("JNDI name is null");
        }
        String className = ao.getClass().getName();
        if (trace) {
            log.trace((Object)("Unbinding " + className + " under " + jndiName));
        }
        InitialContext context = null;
        try {
            context = new InitialContext();
            Util.unbind((Context)context, (String)jndiName);
            objs.remove(SimpleJndiStrategy.qualifiedName(jndiName, className));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unbound " + className + " under " + jndiName));
            }
        }
        catch (Throwable t) {
            log.warn((Object)"Exception during unbind", t);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException ne) {}
            }
        }
    }

    public JndiStrategy clone() throws CloneNotSupportedException {
        return (JndiStrategy)super.clone();
    }

    private static String qualifiedName(String name, String className) {
        return className + "#" + name;
    }
}

