/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.tx.jbossts;

import java.util.Arrays;
import javax.transaction.xa.Xid;
import org.jboss.jca.core.spi.transaction.xa.XidWrapper;

public class XidWrapperImpl
implements XidWrapper {
    private static final long serialVersionUID = 3223859423961011795L;
    private int formatId;
    private byte[] globalTransactionId;
    private byte[] branchQualifier;
    private String jndiName;
    private transient String cachedToString;
    private transient int cachedHashCode;

    public XidWrapperImpl(Xid xid, boolean pad, String jndiName) {
        this.branchQualifier = pad ? new byte[64] : new byte[xid.getBranchQualifier().length];
        System.arraycopy(xid.getBranchQualifier(), 0, this.branchQualifier, 0, xid.getBranchQualifier().length);
        this.globalTransactionId = xid.getGlobalTransactionId();
        this.formatId = xid.getFormatId();
        this.jndiName = jndiName;
    }

    public byte[] getBranchQualifier() {
        return (byte[])this.branchQualifier.clone();
    }

    public int getFormatId() {
        return this.formatId;
    }

    public byte[] getGlobalTransactionId() {
        return (byte[])this.globalTransactionId.clone();
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof Xid)) {
            return false;
        }
        Xid other = (Xid)object;
        return this.formatId == other.getFormatId() && Arrays.equals(this.globalTransactionId, other.getGlobalTransactionId()) && Arrays.equals(this.branchQualifier, other.getBranchQualifier());
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.cachedHashCode = this.formatId;
            for (int i = 0; i < this.globalTransactionId.length; ++i) {
                this.cachedHashCode += this.globalTransactionId[i];
            }
        }
        return this.cachedHashCode;
    }

    public String toString() {
        if (this.cachedToString == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("XidWrapperImpl@").append(Integer.toHexString(System.identityHashCode(this)));
            sb.append("[formatId=").append(this.getFormatId());
            sb.append(" globalTransactionId=").append(new String(this.getGlobalTransactionId()).trim());
            sb.append(" branchQualifier=").append(new String(this.getBranchQualifier()).trim());
            sb.append(" jndiName=").append(this.jndiName);
            sb.append("]");
            this.cachedToString = sb.toString();
        }
        return this.cachedToString;
    }
}

