/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.bundle.AbstractBundle;
import org.jboss.osgi.framework.bundle.AbstractRevision;
import org.jboss.osgi.framework.bundle.AbstractUserRevision;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.bundle.BundleStorageState;
import org.jboss.osgi.framework.bundle.BundleWrapper;
import org.jboss.osgi.framework.bundle.RevisionContent;
import org.jboss.osgi.framework.plugin.BundleDeploymentPlugin;
import org.jboss.osgi.framework.plugin.BundleStoragePlugin;
import org.jboss.osgi.framework.plugin.DeployerServicePlugin;
import org.jboss.osgi.framework.plugin.ModuleManagerPlugin;
import org.jboss.osgi.framework.plugin.Plugin;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public abstract class AbstractUserBundle
extends AbstractBundle {
    private static final Logger log = Logger.getLogger(AbstractUserBundle.class);
    private Dictionary<String, String> headersOnUninstall;

    AbstractUserBundle(BundleManager bundleManager, Deployment dep) throws BundleException {
        super(bundleManager, dep.getSymbolicName(), (BundleStorageState)dep.getAttachment(BundleStorageState.class));
        this.createRevision(dep);
    }

    public static AbstractUserBundle assertBundleState(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Null bundle");
        }
        if (bundle instanceof BundleWrapper) {
            bundle = ((BundleWrapper)bundle).getBundleState();
        }
        if (!(bundle instanceof AbstractUserBundle)) {
            throw new IllegalArgumentException("Not an DeploymentBundle: " + bundle);
        }
        return (AbstractUserBundle)bundle;
    }

    AbstractUserRevision createRevision(Deployment deployment) throws BundleException {
        AbstractUserRevision revision = this.createRevisionInternal(deployment);
        this.addRevision(revision);
        return revision;
    }

    abstract AbstractUserRevision createRevisionInternal(Deployment var1) throws BundleException;

    public ModuleClassLoader getModuleClassLoader() {
        return this.getCurrentRevision().getModuleClassLoader();
    }

    public Deployment getDeployment() {
        return this.getCurrentRevision().getDeployment();
    }

    public RevisionContent getFirstContentRoot() {
        return this.getCurrentRevision().getRootContent();
    }

    public List<RevisionContent> getContentRoots() {
        return this.getCurrentRevision().getContentList();
    }

    @Override
    public AbstractUserRevision getCurrentRevision() {
        return (AbstractUserRevision)super.getCurrentRevision();
    }

    public String getLocation() {
        return this.getCurrentRevision().getLocation();
    }

    @Override
    public List<XModule> getAllResolverModules() {
        ArrayList<XModule> allModules = new ArrayList<XModule>();
        for (AbstractRevision rev : this.getRevisions()) {
            allModules.add(rev.getResolverModule());
        }
        return allModules;
    }

    @Override
    public Dictionary<String, String> getHeaders(String locale) {
        if (this.getState() == 1) {
            return this.headersOnUninstall;
        }
        return super.getHeaders(locale);
    }

    @Override
    void updateInternal(InputStream input) throws BundleException {
        int state;
        boolean restart = false;
        if (!(this.isFragment() || (state = this.getState()) != 32 && state != 8 && state != 16)) {
            this.stopInternal(1);
            if (state != 16) {
                restart = true;
            }
        }
        this.changeState(2, 64);
        try {
            this.createUpdateRevision(input);
        }
        catch (BundleException ex) {
            if (restart) {
                this.startInternal(1);
            }
            throw ex;
        }
        catch (Exception ex) {
            BundleException be = new BundleException("Problem updating bundle");
            be.initCause((Throwable)ex);
            if (restart) {
                this.startInternal(1);
            }
            throw be;
        }
        this.getFrameworkEventsPlugin().fireBundleEvent(this, 8);
        if (restart) {
            try {
                this.startInternal(1);
            }
            catch (BundleException e) {
                this.getFrameworkEventsPlugin().fireFrameworkEvent(this, 2, e);
            }
        }
    }

    private void createUpdateRevision(InputStream input) throws Exception {
        BundleStorageState storageState;
        Plugin plugin;
        BundleManager bundleManager = this.getBundleManager();
        VirtualFile rootFile = null;
        if (input == null) {
            String updateLocation = this.getOSGiMetaData().getHeader("Bundle-UpdateLocation");
            if (updateLocation != null) {
                URL updateURL = new URL(updateLocation);
                rootFile = AbstractVFS.toVirtualFile((URL)updateURL);
            } else {
                rootFile = this.getFirstContentRoot().getVirtualFile();
            }
        }
        if (rootFile == null && input != null) {
            rootFile = AbstractVFS.toVirtualFile((InputStream)input);
        }
        try {
            plugin = bundleManager.getPlugin(BundleStoragePlugin.class);
            storageState = plugin.createStorageState(this.getBundleId(), this.getLocation(), rootFile);
        }
        catch (IOException ex) {
            throw new BundleException("Cannot setup storage for: " + rootFile, (Throwable)ex);
        }
        plugin = bundleManager.getPlugin(BundleDeploymentPlugin.class);
        Deployment dep = plugin.createDeployment(storageState);
        OSGiMetaData metadata = plugin.createOSGiMetaData(dep);
        dep.addAttachment(OSGiMetaData.class, (Object)metadata);
        dep.addAttachment(Bundle.class, (Object)this);
        this.createRevision(dep);
        this.getResolverPlugin().addModule(this.getResolverModule());
    }

    public void refresh() throws BundleException {
        this.assertNotUninstalled();
        if (!this.isResolved()) {
            throw new IllegalStateException("Attempt to refresh an unresolved bundle: " + this);
        }
        for (AbstractRevision rev : this.getRevisions()) {
            XModule resModule = rev.getResolverModule();
            this.getResolverPlugin().removeModule(resModule);
            ModuleIdentifier identifier = rev.getModuleIdentifier();
            this.getModuleManagerPlugin().removeModule(identifier);
        }
        AbstractUserRevision currentRev = this.getCurrentRevision();
        this.clearRevisions();
        this.fireBundleEvent(64);
        currentRev.refreshRevision(this.getOSGiMetaData());
        this.getResolverPlugin().addModule(currentRev.getResolverModule());
        this.changeState(2);
    }

    public void remove() {
        BundleManager bundleManager = this.getBundleManager();
        bundleManager.removeBundle(this);
        BundleStorageState storageState = this.getBundleStorageState();
        storageState.deleteBundleStorage();
        ModuleManagerPlugin moduleManager = bundleManager.getPlugin(ModuleManagerPlugin.class);
        for (AbstractRevision rev : this.getRevisions()) {
            AbstractUserRevision userRev = (AbstractUserRevision)rev;
            if (!this.isFragment()) {
                ModuleIdentifier identifier = rev.getModuleIdentifier();
                moduleManager.removeModule(identifier);
            }
            userRev.close();
        }
        this.fireBundleEvent(64);
    }

    public void uninstall() throws BundleException {
        DeployerServicePlugin service = this.getBundleManager().getPlugin(DeployerServicePlugin.class);
        service.undeploy(this.getDeployment());
    }

    void uninstallInternal() throws BundleException {
        this.assertNotUninstalled();
        this.headersOnUninstall = this.getHeaders(null);
        BundleManager bundleManager = this.getBundleManager();
        if (bundleManager.getBundleById(this.getBundleId()) == null) {
            throw new BundleException("Not installed: " + this);
        }
        this.beforeUninstall();
        bundleManager.uninstallBundle(this);
        log.infof("Bundle uninstalled: %s", (Object)this);
    }

    protected void beforeUninstall() throws BundleException {
    }
}

