/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VFSUtils;
import org.jboss.osgi.vfs.VirtualFile;

public final class BundleStorageState {
    final Logger log = Logger.getLogger(BundleStorageState.class);
    public static final String PROPERTY_BUNDLE_FILE = "BundleFile";
    public static final String PROPERTY_BUNDLE_ID = "BundleId";
    public static final String PROPERTY_BUNDLE_LOCATION = "Location";
    public static final String PROPERTY_BUNDLE_REV = "BundleRev";
    public static final String PROPERTY_LAST_MODIFIED = "LastModified";
    public static final String PROPERTY_PERSISTENTLY_STARTED = "PersistentlyStarted";
    public static final String PROPERTY_ACTIVATION_POLICY_USED = "ActivationPolicyUsed";
    public static final String BUNDLE_PERSISTENT_PROPERTIES = "bundle-persistent.properties";
    private final File bundleDir;
    private final VirtualFile rootFile;
    private final Properties props;
    private final String location;
    private final long bundleId;
    private final int revision;
    private long lastModified;
    static Set<String> requiredProps = new HashSet<String>();

    public static BundleStorageState createFromStorage(File storageDir) throws IOException {
        Properties props = BundleStorageState.loadProperties(storageDir);
        VirtualFile rootFile = null;
        String vfsLocation = props.getProperty(PROPERTY_BUNDLE_FILE);
        if (vfsLocation != null) {
            File revFile = new File(storageDir + "/" + vfsLocation);
            rootFile = AbstractVFS.toVirtualFile((URI)revFile.toURI());
        }
        return new BundleStorageState(storageDir, rootFile, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(File storageDir) throws FileNotFoundException, IOException {
        Properties props = new Properties();
        File propsFile = new File(storageDir + "/" + BUNDLE_PERSISTENT_PROPERTIES);
        if (propsFile.exists()) {
            FileInputStream input = new FileInputStream(propsFile);
            try {
                props.load(input);
            }
            finally {
                VFSUtils.safeClose((Closeable)input);
            }
        }
        return props;
    }

    public static BundleStorageState createBundleStorageState(File storageDir, VirtualFile rootFile, Properties props) throws IOException {
        BundleStorageState storageState = new BundleStorageState(storageDir, rootFile, props);
        storageState.writeProperties();
        return storageState;
    }

    private BundleStorageState(File bundleDir, VirtualFile rootFile, Properties props) throws IOException {
        if (bundleDir == null) {
            throw new IllegalArgumentException("Null storageDir");
        }
        if (!bundleDir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + bundleDir);
        }
        if (props == null) {
            throw new IllegalArgumentException("Null properties");
        }
        for (String key : requiredProps) {
            if (props.get(key) != null) continue;
            throw new IllegalArgumentException("Required property missing: " + key);
        }
        this.bundleDir = bundleDir;
        this.rootFile = rootFile;
        this.props = props;
        this.location = props.getProperty(PROPERTY_BUNDLE_LOCATION);
        this.bundleId = Long.parseLong(props.getProperty(PROPERTY_BUNDLE_ID));
        this.revision = Integer.parseInt(props.getProperty(PROPERTY_BUNDLE_REV));
        this.lastModified = Long.parseLong(props.getProperty(PROPERTY_LAST_MODIFIED));
    }

    public File getBundleStorageDir() {
        return this.bundleDir;
    }

    public String getLocation() {
        return this.location;
    }

    public VirtualFile getRootFile() {
        return this.rootFile;
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public int getRevisionId() {
        return this.revision;
    }

    public long getLastModified() {
        String value = this.props.getProperty(PROPERTY_LAST_MODIFIED);
        return new Long(value);
    }

    public void updateLastModified() {
        this.lastModified = System.currentTimeMillis();
        this.props.setProperty(PROPERTY_LAST_MODIFIED, new Long(this.lastModified).toString());
        this.writeProperties();
    }

    public boolean isPersistentlyStarted() {
        String value = this.props.getProperty(PROPERTY_PERSISTENTLY_STARTED);
        return value != null ? new Boolean(value) : false;
    }

    public void setPersistentlyStarted(boolean started) {
        this.props.setProperty(PROPERTY_PERSISTENTLY_STARTED, new Boolean(started).toString());
        this.writeProperties();
    }

    public boolean isBundleActivationPolicyUsed() {
        String value = this.props.getProperty(PROPERTY_ACTIVATION_POLICY_USED);
        return value != null ? new Boolean(value) : false;
    }

    public void setBundleActivationPolicyUsed(boolean usePolicy) {
        this.props.setProperty(PROPERTY_ACTIVATION_POLICY_USED, new Boolean(usePolicy).toString());
        this.writeProperties();
    }

    public void deleteBundleStorage() {
        VFSUtils.safeClose((Closeable)this.rootFile);
        this.deleteInternal(this.bundleDir);
    }

    public void deleteRevisionStorage() {
        VFSUtils.safeClose((Closeable)this.rootFile);
    }

    void deleteInternal(File file) {
        if (file.isDirectory()) {
            for (File aux : file.listFiles()) {
                this.deleteInternal(aux);
            }
        }
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeProperties() {
        try {
            File propsFile = new File(this.bundleDir + "/" + BUNDLE_PERSISTENT_PROPERTIES);
            FileOutputStream output = new FileOutputStream(propsFile);
            try {
                this.props.store(output, "Persistent Bundle Properties");
            }
            finally {
                VFSUtils.safeClose((Closeable)output);
            }
        }
        catch (IOException ex) {
            this.log.errorf((Throwable)ex, "Cannot write persistent storage: %s", (Object)this.bundleDir);
        }
    }

    public String toString() {
        return "BundleStorageState[id=" + this.bundleId + ",location=" + this.location + ",file=" + this.rootFile + "]";
    }

    static {
        requiredProps.add(PROPERTY_BUNDLE_ID);
        requiredProps.add(PROPERTY_BUNDLE_REV);
        requiredProps.add(PROPERTY_BUNDLE_LOCATION);
        requiredProps.add(PROPERTY_LAST_MODIFIED);
    }
}

