/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptorException;
import org.jboss.osgi.framework.bundle.AbstractBundle;
import org.jboss.osgi.framework.bundle.AbstractBundleContext;
import org.jboss.osgi.framework.bundle.AbstractUserBundle;
import org.jboss.osgi.framework.bundle.AbstractUserRevision;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.bundle.BundleStorageState;
import org.jboss.osgi.framework.bundle.HostBundleContext;
import org.jboss.osgi.framework.bundle.HostRevision;
import org.jboss.osgi.framework.bundle.ModuleActivatorBridge;
import org.jboss.osgi.framework.bundle.RevisionContent;
import org.jboss.osgi.framework.bundle.ServiceState;
import org.jboss.osgi.framework.plugin.StartLevelPlugin;
import org.jboss.osgi.metadata.ActivationPolicyMetaData;
import org.jboss.osgi.modules.ModuleActivator;
import org.jboss.osgi.resolver.XModule;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleException;

public final class HostBundle
extends AbstractUserBundle {
    private static final Logger log = Logger.getLogger(HostBundle.class);
    private final StartLevelPlugin startLevelPlugin = this.getBundleManager().getOptionalPlugin(StartLevelPlugin.class);
    private final AtomicBoolean awaitLazyActivation;
    private final Semaphore activationSemaphore;
    private BundleActivator bundleActivator;
    private int startLevel = this.startLevelPlugin != null ? this.startLevelPlugin.getInitialBundleStartLevel() : -1;

    HostBundle(BundleManager bundleManager, Deployment deployment) throws BundleException {
        super(bundleManager, deployment);
        this.awaitLazyActivation = new AtomicBoolean(this.isActivationLazy());
        this.activationSemaphore = new Semaphore(1);
    }

    public static HostBundle assertBundleState(Bundle bundle) {
        AbstractBundle bundleState = AbstractBundle.assertBundleState(bundle);
        if (!(bundleState instanceof HostBundle)) {
            throw new IllegalArgumentException("Not an InternalBundle: " + bundleState);
        }
        return (HostBundle)bundleState;
    }

    @Override
    AbstractUserRevision createRevisionInternal(Deployment dep) throws BundleException {
        return new HostRevision(this, dep);
    }

    @Override
    public HostRevision getCurrentRevision() {
        return (HostRevision)super.getCurrentRevision();
    }

    @Override
    public List<RevisionContent> getContentRoots() {
        return this.getCurrentRevision().getContentList();
    }

    public boolean isDestroyed() {
        return this.getBundleManager().getBundleById(this.getBundleId()) == null;
    }

    @Override
    public boolean isFragment() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ensureResolved(boolean fireEvent) {
        HostBundle hostBundle = this;
        synchronized (hostBundle) {
            XModule resModule = this.getResolverModule();
            if (resModule.isResolved()) {
                return true;
            }
            try {
                this.getResolverPlugin().resolve(resModule);
                return true;
            }
            catch (BundleException ex) {
                if (fireEvent) {
                    this.getFrameworkEventsPlugin().fireFrameworkEvent(this, 2, ex);
                }
                return false;
            }
        }
    }

    @Override
    AbstractBundleContext createContextInternal() {
        return new HostBundleContext(this, null);
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public void setStartLevel(int level) {
        this.startLevel = level;
    }

    public boolean isPersistentlyStarted() {
        BundleStorageState storageState = this.getBundleStorageState();
        return storageState.isPersistentlyStarted();
    }

    private void setPersistentlyStarted(boolean started) {
        BundleStorageState storageState = this.getBundleStorageState();
        storageState.setPersistentlyStarted(started);
    }

    public boolean isBundleActivationPolicyUsed() {
        BundleStorageState storageState = this.getBundleStorageState();
        return storageState.isBundleActivationPolicyUsed();
    }

    private void setBundleActivationPolicyUsed(boolean usePolicy) {
        BundleStorageState storageState = this.getBundleStorageState();
        storageState.setBundleActivationPolicyUsed(usePolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void startInternal(int options) throws BundleException {
        this.assertStartConditions();
        if (!this.hasStartLevelValidForStart()) {
            if ((options & 1) != 0) {
                throw new BundleException("Bundle cannot be started due to the Framework's current start level");
            }
            this.persistAutoStartSettings(options);
            return;
        }
        try {
            boolean useActivationPolicy;
            this.aquireActivationLock();
            if (this.getState() == 32) {
                return;
            }
            this.persistAutoStartSettings(options);
            if (!this.ensureResolved(false)) {
                throw new BundleException("Cannot resolve bundle: " + this);
            }
            if (this.getBundleContextInternal() == null) {
                this.createBundleContext();
            }
            boolean bl = useActivationPolicy = (options & 2) != 0;
            if (this.awaitLazyActivation.get() && useActivationPolicy) {
                this.transitionToStarting(options);
            } else {
                this.transitionToActive(options);
            }
        }
        finally {
            this.activationSemaphore.release();
        }
    }

    private void assertStartConditions() throws BundleException {
        List requiredEnvs = this.getOSGiMetaData().getRequiredExecutionEnvironment();
        if (requiredEnvs != null) {
            boolean foundSupportedEnv = false;
            String frameworkEnvProp = (String)this.getBundleManager().getProperty("org.osgi.framework.executionenvironment");
            List<String> availableEnvs = Arrays.asList(frameworkEnvProp.split("[, ]"));
            for (String aux : requiredEnvs) {
                if (!availableEnvs.contains(aux)) continue;
                foundSupportedEnv = true;
                break;
            }
            if (!foundSupportedEnv) {
                throw new BundleException("Unsupported execution environment " + requiredEnvs + " we have " + availableEnvs);
            }
        }
    }

    private void aquireActivationLock() throws BundleException {
        try {
            if (!this.activationSemaphore.tryAcquire(10L, TimeUnit.SECONDS)) {
                throw new BundleException("Cannot acquire start/stop lock for: " + this);
            }
        }
        catch (InterruptedException ex) {
            log.warnf("Tread interupted while trying to start/stop bundle: %s", (Object)this);
            return;
        }
    }

    private void persistAutoStartSettings(int options) {
        if ((options & 1) == 0) {
            this.setPersistentlyStarted(true);
            boolean activationPolicyUsed = (options & 2) != 0;
            this.setBundleActivationPolicyUsed(activationPolicyUsed);
        }
    }

    private boolean hasStartLevelValidForStart() {
        if (this.startLevelPlugin == null) {
            return true;
        }
        return this.getStartLevel() <= this.startLevelPlugin.getStartLevel();
    }

    private void transitionToStarting(int options) throws BundleException {
        if (this.getState() == 8) {
            return;
        }
        this.changeState(8, 512);
    }

    private void transitionToActive(int options) throws BundleException {
        block9: {
            try {
                this.changeState(8);
            }
            catch (LifecycleInterceptorException ex) {
                throw new BundleException("Cannot transition to STARTING: " + this, (Throwable)ex);
            }
            XModule resModule = this.getResolverModule();
            String bundleActivatorClassName = resModule.getModuleActivator();
            if (bundleActivatorClassName != null) {
                try {
                    Object result = this.loadClass(bundleActivatorClassName).newInstance();
                    if (result instanceof ModuleActivator) {
                        this.bundleActivator = new ModuleActivatorBridge((ModuleActivator)result);
                        this.bundleActivator.start(this.getBundleContext());
                        break block9;
                    }
                    if (result instanceof BundleActivator) {
                        this.bundleActivator = (BundleActivator)result;
                        this.bundleActivator.start(this.getBundleContext());
                        break block9;
                    }
                    throw new BundleException(bundleActivatorClassName + " is not an implementation of " + BundleActivator.class.getName());
                }
                catch (Throwable th) {
                    this.changeState(16);
                    this.removeServicesAndListeners();
                    this.destroyBundleContext();
                    this.changeState(4);
                    if (th instanceof BundleException) {
                        throw (BundleException)th;
                    }
                    throw new BundleException("Cannot start bundle: " + this, th);
                }
            }
        }
        if (this.getState() == 1) {
            throw new BundleException("Bundle was uninstalled while activator was running: " + this);
        }
        this.changeState(32);
        log.infof("Bundle started: %s", (Object)this);
    }

    @Override
    public boolean isActivationLazy() {
        ActivationPolicyMetaData activationPolicy = this.getActivationPolicy();
        String policyType = activationPolicy != null ? activationPolicy.getType() : null;
        return "lazy".equals(policyType);
    }

    public ActivationPolicyMetaData getActivationPolicy() {
        return this.getOSGiMetaData().getBundleActivationPolicy();
    }

    public void activateOnClassLoad(Class<?> definedClass) throws BundleException {
        if (this.awaitLazyActivation.getAndSet(false) && this.hasStartLevelValidForStart()) {
            int options = 1;
            if (this.isBundleActivationPolicyUsed()) {
                options |= 2;
            }
            this.startInternal(options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void stopInternal(int options) throws BundleException {
        if (this.getState() == 1) {
            throw new IllegalStateException("Bundle already uninstalled: " + this);
        }
        try {
            this.aquireActivationLock();
            if ((options & 1) == 0) {
                this.setPersistentlyStarted(false);
                this.setBundleActivationPolicyUsed(false);
            }
            if (this.getState() != 8 && this.getState() != 32) {
                return;
            }
            int priorState = this.getState();
            this.changeState(16);
            Throwable rethrow = null;
            if (priorState == 32 && this.bundleActivator != null) {
                try {
                    if (this.bundleActivator instanceof ModuleActivatorBridge) {
                        this.bundleActivator.stop(this.getBundleContext());
                    } else {
                        this.bundleActivator.stop(this.getBundleContext());
                    }
                }
                catch (Throwable t) {
                    rethrow = t;
                }
            }
            this.removeServicesAndListeners();
            if (this.getState() == 1) {
                throw new BundleException("Bundle uninstalled during activator stop: " + this);
            }
            this.destroyBundleContext();
            this.changeState(4, 4);
            log.infof("Bundle stopped: %s", (Object)this);
            if (rethrow != null) {
                throw new BundleException("Error during stop of bundle: " + this, rethrow);
            }
        }
        finally {
            this.activationSemaphore.release();
        }
    }

    private void removeServicesAndListeners() {
        for (ServiceState serviceState : this.getRegisteredServicesInternal()) {
            serviceState.unregister();
        }
        this.getFrameworkEventsPlugin().removeBundleListeners(this);
    }

    @Override
    protected void beforeUninstall() throws BundleException {
        BundleManager bundleManager = this.getBundleManager();
        int state = this.getState();
        if (state == 32 || state == 8 || state == 16) {
            try {
                this.stopInternal(0);
            }
            catch (Exception ex) {
                bundleManager.fireError(this, "Error stopping bundle: " + this, ex);
            }
        }
    }
}

