/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.util.Comparator;
import org.jboss.osgi.framework.bundle.ServiceState;
import org.osgi.framework.ServiceReference;

public class ServiceReferenceComparator
implements Comparator<ServiceReference> {
    private static final Comparator<ServiceReference> INSTANCE = new ServiceReferenceComparator();

    public static Comparator<ServiceReference> getInstance() {
        return INSTANCE;
    }

    private ServiceReferenceComparator() {
    }

    @Override
    public int compare(ServiceReference ref1, ServiceReference ref2) {
        long otherId;
        int otherRanking;
        ServiceState s1 = ServiceState.assertServiceState(ref1);
        ServiceState s2 = ServiceState.assertServiceState(ref2);
        if (s1.getServiceId() == s2.getServiceId()) {
            return 0;
        }
        int thisRanking = s1.getServiceRanking();
        if (thisRanking != (otherRanking = s2.getServiceRanking())) {
            return thisRanking < otherRanking ? -1 : 1;
        }
        long thisId = s1.getServiceId();
        return thisId > (otherId = s2.getServiceId()) ? -1 : 1;
    }
}

