/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.osgi.framework.bundle.AbstractRevision;
import org.jboss.osgi.framework.bundle.SystemBundle;
import org.jboss.osgi.framework.plugin.SystemModuleProviderPlugin;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XModule;
import org.osgi.framework.BundleException;

public class SystemBundleRevision
extends AbstractRevision {
    static final Logger log = Logger.getLogger(SystemBundleRevision.class);
    private ClassLoader classLoader;

    SystemBundleRevision(SystemBundle bundleState, OSGiMetaData metadata) throws BundleException {
        super(bundleState, metadata, null, 0);
    }

    @Override
    public SystemBundle getBundleState() {
        return (SystemBundle)super.getBundleState();
    }

    @Override
    void refreshRevisionInternal(XModule resModule) {
        resModule.addAttachment(SystemBundle.class, (Object)this.getBundleState());
    }

    @Override
    public String getLocation() {
        return "System Bundle";
    }

    @Override
    Enumeration<String> getEntryPaths(String path) {
        return null;
    }

    @Override
    URL getEntry(String path) {
        return null;
    }

    @Override
    Enumeration<URL> findEntries(String path, String pattern, boolean recurse) {
        return null;
    }

    @Override
    Class<?> loadClass(String className) throws ClassNotFoundException {
        ClassLoader classLoader = this.getFrameworkClassLoader();
        return classLoader.loadClass(className);
    }

    @Override
    URL getResource(String name) {
        ClassLoader classLoader = this.getFrameworkClassLoader();
        return classLoader.getResource(name);
    }

    @Override
    Enumeration<URL> getResources(String name) throws IOException {
        ClassLoader classLoader = this.getFrameworkClassLoader();
        return classLoader.getResources(name);
    }

    @Override
    URL getLocalizationEntry(String path) {
        return null;
    }

    private ClassLoader getFrameworkClassLoader() {
        if (this.classLoader == null) {
            SystemModuleProviderPlugin plugin = this.getBundleManager().getPlugin(SystemModuleProviderPlugin.class);
            Module frameworkModule = plugin.getFrameworkModule();
            if (frameworkModule == null) {
                throw new IllegalStateException("Framework module not created");
            }
            this.classLoader = frameworkModule.getClassLoader();
        }
        return this.classLoader;
    }
}

