/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.plugin;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.plugin.AbstractPlugin;
import org.jboss.osgi.framework.plugin.ExecutorServicePlugin;

public abstract class AbstractExecutorServicePlugin
extends AbstractPlugin
implements ExecutorServicePlugin {
    private ExecutorService executorService;
    private AtomicInteger threadCount = new AtomicInteger();
    private String typeName;

    public AbstractExecutorServicePlugin(BundleManager bundleManager, String executorType) {
        super(bundleManager);
        this.typeName = executorType;
    }

    @Override
    public void initPlugin() {
        this.executorService = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable run) {
                Thread thread = new Thread(run);
                thread.setName(String.format("OSGi " + AbstractExecutorServicePlugin.this.typeName + " Thread-%d", AbstractExecutorServicePlugin.this.threadCount.incrementAndGet()));
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    @Override
    public void destroyPlugin() {
        this.executorService.shutdown();
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }
}

