/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.plugin.internal;

import org.jboss.logging.Logger;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.osgi.framework.bundle.AbstractRevision;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.bundle.OSGiModuleLoader;
import org.jboss.osgi.framework.bundle.SystemBundle;
import org.jboss.osgi.framework.plugin.AbstractPlugin;
import org.jboss.osgi.framework.plugin.SystemModuleProviderPlugin;
import org.jboss.osgi.framework.plugin.SystemPackagesPlugin;

public abstract class AbstractSystemModuleProviderPlugin
extends AbstractPlugin
implements SystemModuleProviderPlugin {
    final Logger log = Logger.getLogger(AbstractSystemModuleProviderPlugin.class);
    private Module systemModule;

    public AbstractSystemModuleProviderPlugin(BundleManager bundleManager) {
        super(bundleManager);
    }

    @Override
    public void destroyPlugin() {
        this.systemModule = null;
    }

    @Override
    public Module getSystemModule() {
        return this.systemModule;
    }

    @Override
    public Module createSystemModule(OSGiModuleLoader moduleLoader, SystemBundle systemBundle) {
        if (this.systemModule != null) {
            throw new IllegalStateException("System module already created");
        }
        ModuleSpec.Builder specBuilder = ModuleSpec.build((ModuleIdentifier)ModuleIdentifier.create((String)"jbosgi.system"));
        ModuleLoader systemLoader = Module.getBootModuleLoader();
        ModuleIdentifier identifier = Module.getSystemModule().getIdentifier();
        PathFilter systemFilter = this.getBundleManager().getPlugin(SystemPackagesPlugin.class).getSystemPackageFilter();
        specBuilder.addDependency(DependencySpec.createModuleDependencySpec((PathFilter)systemFilter, (PathFilter)PathFilters.acceptAll(), (ModuleLoader)systemLoader, (ModuleIdentifier)identifier, (boolean)false));
        ModuleSpec moduleSpec = specBuilder.create();
        moduleLoader.addModule((AbstractRevision)systemBundle.getCurrentRevision(), moduleSpec);
        try {
            this.systemModule = moduleLoader.loadModule(specBuilder.getIdentifier());
            return this.systemModule;
        }
        catch (ModuleLoadException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

