/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.plugin.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.jar.Manifest;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentFactory;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.bundle.BundleStorageState;
import org.jboss.osgi.framework.plugin.AbstractPlugin;
import org.jboss.osgi.framework.plugin.BundleDeploymentPlugin;
import org.jboss.osgi.framework.plugin.BundleStoragePlugin;
import org.jboss.osgi.framework.plugin.ResolverPlugin;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.resolver.XModuleBuilder;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VFSUtils;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class BundleDeploymentPluginImpl
extends AbstractPlugin
implements BundleDeploymentPlugin {
    private static final Logger log = Logger.getLogger(BundleDeploymentPluginImpl.class);

    public BundleDeploymentPluginImpl(BundleManager bundleManager) {
        super(bundleManager);
    }

    @Override
    public Deployment createDeployment(BundleStorageState storageState) throws BundleException {
        if (storageState == null) {
            throw new IllegalArgumentException("Null storageState");
        }
        try {
            String location = storageState.getLocation();
            VirtualFile rootFile = storageState.getRootFile();
            Deployment dep = this.createDeployment(location, rootFile);
            dep.addAttachment(BundleStorageState.class, (Object)storageState);
            return dep;
        }
        catch (BundleException ex) {
            storageState.deleteBundleStorage();
            throw ex;
        }
        catch (RuntimeException ex) {
            storageState.deleteBundleStorage();
            throw ex;
        }
    }

    @Override
    public Deployment createDeployment(Module module) throws BundleException {
        BundleStorageState storageState;
        Version version;
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        ModuleIdentifier identifier = module.getIdentifier();
        String location = "module:" + identifier.getName();
        if (!"main".equals(identifier.getSlot())) {
            location = location + ":" + identifier.getSlot();
        }
        BundleStoragePlugin storagePlugin = this.getPlugin(BundleStoragePlugin.class);
        File repoFile = this.getModuleRepositoryEntry(identifier);
        long bundleId = this.getBundleManager().getNextBundleId();
        if (repoFile != null) {
            BundleStorageState storageState2;
            try {
                BundleStoragePlugin plugin = this.getPlugin(BundleStoragePlugin.class);
                VirtualFile rootFile = AbstractVFS.toVirtualFile((URI)repoFile.toURI());
                storageState2 = plugin.createStorageState(bundleId, location, rootFile);
            }
            catch (IOException ex) {
                throw new BundleException("Cannot setup storage for: " + location, (Throwable)ex);
            }
            try {
                return this.createDeployment(storageState2);
            }
            catch (Exception ex) {
                log.debugf("Cannot process '%s' as OSGi deployment: %s", (Object)location, (Object)ex.toString());
            }
        }
        String symbolicName = identifier.getName();
        try {
            version = Version.parseVersion((String)identifier.getSlot());
        }
        catch (IllegalArgumentException ex) {
            version = Version.emptyVersion;
        }
        ResolverPlugin resolverPlugin = this.getPlugin(ResolverPlugin.class);
        XModuleBuilder builder = resolverPlugin.getModuleBuilder();
        builder.createModule(symbolicName, version, 0);
        builder.addBundleCapability(symbolicName, version);
        for (String path : module.getExportedPaths()) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.startsWith("META-INF")) continue;
            String packageName = path.replace('/', '.');
            builder.addPackageCapability(packageName, null, null);
        }
        XModule resModule = builder.getModule();
        resModule.addAttachment(Module.class, (Object)module);
        try {
            storageState = storagePlugin.createStorageState(bundleId, location, null);
        }
        catch (IOException ex) {
            throw new BundleException("Cannot create bundle storage for: " + location, (Throwable)ex);
        }
        Deployment dep = DeploymentFactory.createDeployment((String)location, (String)symbolicName, (Version)version);
        dep.addAttachment(BundleStorageState.class, (Object)storageState);
        dep.addAttachment(XModule.class, (Object)resModule);
        dep.addAttachment(Module.class, (Object)module);
        return dep;
    }

    @Override
    public OSGiMetaData createOSGiMetaData(Deployment dep) throws BundleException {
        VirtualFile rootFile;
        OSGiMetaData metadata = (OSGiMetaData)dep.getAttachment(OSGiMetaData.class);
        if (metadata != null) {
            return metadata;
        }
        BundleInfo info = (BundleInfo)dep.getAttachment(BundleInfo.class);
        if (info != null) {
            metadata = this.toOSGiMetaData(info);
        }
        XModule resModule = (XModule)dep.getAttachment(XModule.class);
        if (metadata == null && resModule != null) {
            metadata = this.toOSGiMetaData(dep, resModule);
        }
        if (metadata == null) {
            rootFile = dep.getRoot();
            String location = dep.getLocation();
            try {
                info = BundleInfo.createBundleInfo((VirtualFile)rootFile, (String)location);
                metadata = this.toOSGiMetaData(info);
            }
            catch (BundleException ex) {
                // empty catch block
            }
        }
        if (metadata == null) {
            rootFile = dep.getRoot();
            metadata = this.getXServiceMetaData(rootFile);
        }
        if (metadata == null) {
            throw new BundleException("Not a valid OSGi deployment: " + dep);
        }
        dep.addAttachment(OSGiMetaData.class, (Object)metadata);
        return metadata;
    }

    private File getModuleRepositoryEntry(ModuleIdentifier identifier) {
        File rootPath = new File(this.getBundleManager().getProperty("module.path").toString());
        String identifierPath = identifier.getName().replace('.', '/') + "/" + identifier.getSlot();
        File moduleDir = new File(rootPath + "/" + identifierPath);
        if (!moduleDir.isDirectory()) {
            log.warnf("Cannot obtain module directory: %s", (Object)moduleDir);
            return null;
        }
        String[] files = moduleDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (files.length == 0) {
            log.warnf("Cannot find module jar in: %s", (Object)moduleDir);
            return null;
        }
        if (files.length > 1) {
            log.warnf("Multiple module jars in: %s", (Object)moduleDir);
            return null;
        }
        File moduleFile = new File(moduleDir + "/" + files[0]);
        if (!moduleFile.exists()) {
            log.warnf("Module file does not exist: %s", (Object)moduleFile);
            return null;
        }
        return moduleFile;
    }

    private Deployment createDeployment(String location, VirtualFile rootFile) throws BundleException {
        try {
            BundleInfo info = BundleInfo.createBundleInfo((VirtualFile)rootFile, (String)location);
            Deployment dep = DeploymentFactory.createDeployment((BundleInfo)info);
            OSGiMetaData metadata = this.toOSGiMetaData(info);
            dep.addAttachment(BundleInfo.class, (Object)info);
            dep.addAttachment(OSGiMetaData.class, (Object)metadata);
            return dep;
        }
        catch (NumberFormatException nfe) {
            throw new BundleException("Invalid number format: " + nfe.getMessage(), (Throwable)nfe);
        }
        catch (BundleException ex) {
            OSGiMetaData metadata = this.getXServiceMetaData(rootFile);
            if (metadata != null) {
                String symbolicName = metadata.getBundleSymbolicName();
                Version version = metadata.getBundleVersion();
                Deployment dep = DeploymentFactory.createDeployment((VirtualFile)rootFile, (String)location, (String)symbolicName, (Version)version);
                dep.addAttachment(OSGiMetaData.class, (Object)metadata);
                return dep;
            }
            Manifest manifest = null;
            try {
                manifest = VFSUtils.getManifest((VirtualFile)rootFile);
            }
            catch (IOException ex2) {
                // empty catch block
            }
            if (manifest != null && manifest.getMainAttributes().keySet().size() < 2) {
                Deployment dep = DeploymentFactory.createDeployment((VirtualFile)rootFile, (String)location, null, (Version)Version.emptyVersion);
                metadata = OSGiMetaDataBuilder.load((Manifest)manifest);
                dep.addAttachment(OSGiMetaData.class, (Object)metadata);
                return dep;
            }
            throw new BundleException("Cannot create deployment from: " + rootFile);
        }
    }

    private OSGiMetaData getXServiceMetaData(VirtualFile rootFile) {
        try {
            VirtualFile child = rootFile.getChild("META-INF/jbosgi-xservice.properties");
            if (child != null) {
                OSGiMetaData metadata = OSGiMetaDataBuilder.load((InputStream)child.openStream());
                return metadata;
            }
            VirtualFile parentFile = rootFile.getParent();
            if (parentFile != null && (child = parentFile.getChild("jbosgi-xservice.properties")) != null) {
                OSGiMetaData metadata = OSGiMetaDataBuilder.load((InputStream)child.openStream());
                return metadata;
            }
        }
        catch (IOException ex) {
            log.warnf((Throwable)ex, "Cannot process XService metadata: %s", (Object)rootFile);
        }
        return null;
    }

    private OSGiMetaData toOSGiMetaData(BundleInfo info) {
        Manifest manifest = info.getManifest();
        return OSGiMetaDataBuilder.load((Manifest)manifest);
    }

    private OSGiMetaData toOSGiMetaData(Deployment dep, XModule resModule) {
        String symbolicName = dep.getSymbolicName();
        Version version = Version.parseVersion((String)dep.getVersion());
        if (!symbolicName.equals(resModule.getName()) || !version.equals((Object)resModule.getVersion())) {
            throw new IllegalArgumentException("Inconsistent bundle metadata: " + resModule);
        }
        OSGiMetaDataBuilder builder = OSGiMetaDataBuilder.createBuilder((String)symbolicName, (Version)version);
        return builder.getOSGiMetaData();
    }
}

