/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.plugin.internal;

import java.util.Collections;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoaderFactory;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.Resource;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.osgi.framework.bundle.AbstractRevision;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.bundle.OSGiModuleLoader;
import org.jboss.osgi.framework.bundle.SystemBundle;
import org.jboss.osgi.framework.loading.SystemBundleModuleClassLoader;
import org.jboss.osgi.framework.plugin.SystemPackagesPlugin;
import org.jboss.osgi.framework.plugin.internal.AbstractSystemModuleProviderPlugin;

public class DefaultFrameworkModuleProvider
extends AbstractSystemModuleProviderPlugin {
    final Logger log = Logger.getLogger(DefaultFrameworkModuleProvider.class);
    private Module frameworkModule;

    public DefaultFrameworkModuleProvider(BundleManager bundleManager) {
        super(bundleManager);
    }

    @Override
    public void destroyPlugin() {
        super.destroyPlugin();
        this.frameworkModule = null;
    }

    @Override
    public Module getFrameworkModule() {
        return this.frameworkModule;
    }

    @Override
    public Module createFrameworkModule(OSGiModuleLoader moduleLoader, SystemBundle systemBundle) {
        if (this.frameworkModule != null) {
            throw new IllegalStateException("Framework module already created");
        }
        ModuleIdentifier systemIdentifier = this.getSystemModule().getIdentifier();
        ModuleSpec.Builder specBuilder = ModuleSpec.build((ModuleIdentifier)ModuleIdentifier.create((String)"jbosgi.framework"));
        specBuilder.addDependency(DependencySpec.createModuleDependencySpec((PathFilter)PathFilters.acceptAll(), (PathFilter)PathFilters.acceptAll(), (ModuleLoader)moduleLoader, (ModuleIdentifier)systemIdentifier, (boolean)false));
        SystemPackagesPlugin plugin = this.getBundleManager().getPlugin(SystemPackagesPlugin.class);
        PathFilter frameworkFilter = plugin.getFrameworkPackageFilter();
        final ClassLoader classLoader = BundleManager.class.getClassLoader();
        LocalLoader localLoader = new LocalLoader(){

            public Class<?> loadClassLocal(String name, boolean resolve) {
                try {
                    return classLoader.loadClass(name);
                }
                catch (ClassNotFoundException ex) {
                    return null;
                }
            }

            public List<Resource> loadResourceLocal(String name) {
                return Collections.emptyList();
            }
        };
        specBuilder.addDependency(DependencySpec.createLocalDependencySpec((PathFilter)frameworkFilter, (PathFilter)PathFilters.acceptAll(), (LocalLoader)localLoader, plugin.getFrameworkPackagePaths()));
        specBuilder.setModuleClassLoaderFactory((ModuleClassLoaderFactory)new SystemBundleModuleClassLoader.Factory(this.getBundleManager().getSystemBundle()));
        ModuleSpec moduleSpec = specBuilder.create();
        moduleLoader.addModule((AbstractRevision)systemBundle.getCurrentRevision(), moduleSpec);
        try {
            this.frameworkModule = moduleLoader.loadModule(specBuilder.getIdentifier());
            return this.frameworkModule;
        }
        catch (ModuleLoadException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

