/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.plugin.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.osgi.framework.bundle.AbstractBundle;
import org.jboss.osgi.framework.bundle.AbstractRevision;
import org.jboss.osgi.framework.bundle.AbstractUserBundle;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.bundle.FragmentBundle;
import org.jboss.osgi.framework.bundle.FragmentRevision;
import org.jboss.osgi.framework.bundle.HostBundle;
import org.jboss.osgi.framework.bundle.HostRevision;
import org.jboss.osgi.framework.plugin.AbstractExecutorServicePlugin;
import org.jboss.osgi.framework.plugin.FrameworkEventsPlugin;
import org.jboss.osgi.framework.plugin.ModuleManagerPlugin;
import org.jboss.osgi.framework.plugin.PackageAdminPlugin;
import org.jboss.osgi.framework.plugin.ResolverPlugin;
import org.jboss.osgi.framework.plugin.StartLevelPlugin;
import org.jboss.osgi.resolver.XBundleCapability;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.resolver.XModuleIdentity;
import org.jboss.osgi.resolver.XPackageCapability;
import org.jboss.osgi.resolver.XRequireBundleRequirement;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XWire;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;
import org.osgi.service.startlevel.StartLevel;

public class PackageAdminPluginImpl
extends AbstractExecutorServicePlugin
implements PackageAdminPlugin {
    final Logger log = Logger.getLogger(PackageAdminPluginImpl.class);
    private ResolverPlugin resolverPlugin;
    private ServiceRegistration registration;

    public PackageAdminPluginImpl(BundleManager bundleManager) {
        super(bundleManager, "PackageAdmin");
    }

    @Override
    public void initPlugin() {
        super.initPlugin();
        BundleContext sysContext = this.getBundleManager().getSystemContext();
        this.registration = sysContext.registerService(PackageAdmin.class.getName(), (Object)this, null);
        this.resolverPlugin = this.getPlugin(ResolverPlugin.class);
    }

    @Override
    public void stopPlugin() {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
    }

    public ExportedPackage[] getExportedPackages(Bundle bundle) {
        if (bundle == null) {
            return this.getAllExportedPackages();
        }
        AbstractBundle ab = AbstractBundle.assertBundleState(bundle);
        if (ab instanceof HostBundle && ((HostBundle)ab).isDestroyed()) {
            return null;
        }
        ArrayList<ExportedPackageImpl> result = new ArrayList<ExportedPackageImpl>();
        for (XModule resModule : ab.getAllResolverModules()) {
            if (!resModule.isResolved()) continue;
            for (XPackageCapability cap : resModule.getPackageCapabilities()) {
                result.add(new ExportedPackageImpl(cap));
            }
        }
        if (result.size() == 0) {
            return null;
        }
        return result.toArray(new ExportedPackage[result.size()]);
    }

    private ExportedPackage[] getAllExportedPackages() {
        ArrayList<ExportedPackage> result = new ArrayList<ExportedPackage>();
        for (AbstractBundle ab : this.getBundleManager().getBundles()) {
            ExportedPackage[] pkgs = this.getExportedPackages(ab);
            if (pkgs == null) continue;
            result.addAll(Arrays.asList(pkgs));
        }
        return result.toArray(new ExportedPackage[result.size()]);
    }

    public ExportedPackage[] getExportedPackages(String name) {
        ExportedPackage[] pkgs = this.getExportedPackagesInternal(name);
        if (pkgs.length == 0) {
            return null;
        }
        return pkgs;
    }

    private ExportedPackage[] getExportedPackagesInternal(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        HashSet<ExportedPackageImpl> result = new HashSet<ExportedPackageImpl>();
        ResolverPlugin plugin = this.getBundleManager().getPlugin(ResolverPlugin.class);
        for (XModule mod : plugin.getResolver().getModules()) {
            if (!mod.isResolved() || mod.isFragment()) continue;
            for (XCapability cap : mod.getCapabilities()) {
                if (!(cap instanceof XPackageCapability) || !name.equals(cap.getName())) continue;
                result.add(new ExportedPackageImpl((XPackageCapability)cap));
            }
        }
        return result.toArray(new ExportedPackage[result.size()]);
    }

    public ExportedPackage getExportedPackage(String name) {
        ExportedPackage[] exported = this.getExportedPackagesInternal(name);
        ArrayList<ExportedPackage> wired = new ArrayList<ExportedPackage>();
        ArrayList<ExportedPackage> notWired = new ArrayList<ExportedPackage>();
        for (ExportedPackage ep : exported) {
            XPackageCapability capability = ((ExportedPackageImpl)ep).getCapability();
            if (this.isWired(capability)) {
                wired.add(ep);
                continue;
            }
            notWired.add(ep);
        }
        ExportedPackageComparator comparator = new ExportedPackageComparator();
        Collections.sort(wired, comparator);
        Collections.sort(notWired, comparator);
        if (wired.size() > 0) {
            return (ExportedPackage)wired.get(0);
        }
        if (notWired.size() > 0) {
            return (ExportedPackage)notWired.get(0);
        }
        return null;
    }

    private boolean isWired(XPackageCapability capability) {
        for (AbstractBundle ab : this.getBundleManager().getBundles()) {
            for (XModule module : ab.getAllResolverModules()) {
                for (XWire wire : module.getWires()) {
                    if (!wire.getCapability().equals(capability)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void refreshPackages(final Bundle[] bundlesToRefresh) {
        Runnable runner = new Runnable(){
            FrameworkEventsPlugin eventsPlugin;
            {
                this.eventsPlugin = PackageAdminPluginImpl.this.getPlugin(FrameworkEventsPlugin.class);
            }

            @Override
            public void run() {
                Bundle[] bundles = bundlesToRefresh;
                if (bundles == null) {
                    ArrayList<AbstractBundle> bundlesToRefresh2 = new ArrayList<AbstractBundle>();
                    for (AbstractBundle aux : PackageAdminPluginImpl.this.getBundleManager().getBundles(null)) {
                        if (aux.getRevisions().size() <= 1 && aux.getState() != 1) continue;
                        bundlesToRefresh2.add(aux);
                    }
                    bundles = bundlesToRefresh2.toArray(new Bundle[bundlesToRefresh2.size()]);
                }
                HashMap<XModule, AbstractUserBundle> refreshMap = new HashMap<XModule, AbstractUserBundle>();
                for (Bundle aux : bundles) {
                    AbstractBundle bundleState = AbstractBundle.assertBundleState(aux);
                    if (!(bundleState instanceof AbstractUserBundle)) continue;
                    for (XModule resModule : bundleState.getAllResolverModules()) {
                        refreshMap.put(resModule, (AbstractUserBundle)bundleState);
                    }
                }
                HashSet<HostBundle> stopBundles = new HashSet<HostBundle>();
                HashSet<AbstractBundle> refreshBundles = new HashSet<AbstractBundle>();
                HashSet<AbstractUserBundle> uninstallBundles = new HashSet<AbstractUserBundle>();
                for (AbstractBundle aux : refreshMap.values()) {
                    if (aux.getState() == 1) {
                        uninstallBundles.add((AbstractUserBundle)aux);
                        continue;
                    }
                    if (!aux.isResolved()) continue;
                    refreshBundles.add(aux);
                }
                block10: for (AbstractBundle aux : PackageAdminPluginImpl.this.getBundleManager().getBundles()) {
                    HostBundle hostBundle;
                    XModule resModule;
                    if (!(aux instanceof HostBundle) || !(resModule = (hostBundle = (HostBundle)aux).getResolverModule()).isResolved()) continue;
                    for (XWire wire : resModule.getWires()) {
                        if (!refreshMap.containsKey(wire.getExporter())) continue;
                        int state = hostBundle.getState();
                        if (state == 32 || state == 8) {
                            stopBundles.add(hostBundle);
                        }
                        refreshBundles.add(hostBundle);
                        continue block10;
                    }
                }
                for (AbstractBundle aux : new HashSet(refreshMap.values())) {
                    int state;
                    if (!(aux instanceof HostBundle) || (state = aux.getState()) != 32 && state != 8) continue;
                    stopBundles.add((HostBundle)aux);
                }
                ArrayList stopList = new ArrayList(stopBundles);
                ArrayList refreshList = new ArrayList(refreshBundles);
                StartLevelPlugin startLevel = PackageAdminPluginImpl.this.getOptionalPlugin(StartLevelPlugin.class);
                BundleStartLevelComparator startLevelComparator = new BundleStartLevelComparator(startLevel);
                Collections.sort(stopList, startLevelComparator);
                ListIterator it = stopList.listIterator(stopList.size());
                while (it.hasPrevious()) {
                    HostBundle hostBundle = (HostBundle)it.previous();
                    try {
                        hostBundle.stop(1);
                    }
                    catch (Exception th) {
                        this.eventsPlugin.fireFrameworkEvent(hostBundle, 2, th);
                    }
                }
                for (AbstractUserBundle userBundle : uninstallBundles) {
                    userBundle.remove();
                }
                for (AbstractUserBundle userBundle : refreshList) {
                    try {
                        userBundle.refresh();
                    }
                    catch (Exception th) {
                        this.eventsPlugin.fireFrameworkEvent(userBundle, 2, th);
                    }
                }
                for (HostBundle hostBundle : stopList) {
                    try {
                        hostBundle.start(1);
                    }
                    catch (Exception th) {
                        this.eventsPlugin.fireFrameworkEvent(hostBundle, 2, th);
                    }
                }
                this.eventsPlugin.fireFrameworkEvent(PackageAdminPluginImpl.this.getBundleManager().getSystemBundle(), 4, null);
            }
        };
        this.getExecutorService().execute(runner);
    }

    public boolean resolveBundles(Bundle[] bundles) {
        LinkedHashSet<XModule> unresolved = null;
        if (bundles != null) {
            unresolved = new LinkedHashSet<XModule>();
            for (Bundle aux : bundles) {
                AbstractBundle bundleState = AbstractBundle.assertBundleState(aux);
                XModuleIdentity moduleId = bundleState.getResolverModule().getModuleId();
                if (bundleState.getState() != 2 || this.resolverPlugin.getModuleById(moduleId) == null) continue;
                unresolved.add(bundleState.getResolverModule());
            }
        }
        this.log.debugf("Resolve bundles: %s", unresolved);
        return this.resolverPlugin.resolveAll(unresolved);
    }

    public RequiredBundle[] getRequiredBundles(String symbolicName) {
        HashMap matchingBundles = new HashMap();
        ArrayList<AbstractBundle> bundles = new ArrayList<AbstractBundle>(this.getBundleManager().getBundles());
        if (symbolicName != null) {
            for (AbstractBundle aux : bundles) {
                if (!symbolicName.equals(aux.getSymbolicName())) continue;
                matchingBundles.put(aux, new ArrayList());
            }
        } else {
            for (AbstractBundle aux : bundles) {
                if (aux.isFragment()) continue;
                matchingBundles.put(aux, new ArrayList());
            }
        }
        if (matchingBundles.size() == 0) {
            return null;
        }
        for (AbstractBundle aux : bundles) {
            XModule resModule = aux.getResolverModule();
            for (XRequireBundleRequirement req : resModule.getBundleRequirements()) {
                if (!req.getName().equals(symbolicName)) continue;
                for (XWire wire : req.getModule().getWires()) {
                    XCapability wiredCap;
                    XModule module;
                    Bundle bundle;
                    AbstractBundle bundleState;
                    Collection requiring;
                    if (!wire.getRequirement().equals(req) || (requiring = (Collection)matchingBundles.get(bundleState = AbstractBundle.assertBundleState(bundle = (Bundle)(module = (wiredCap = wire.getCapability()).getModule()).getAttachment(Bundle.class)))) == null) continue;
                    requiring.add(aux);
                }
            }
        }
        ArrayList<RequiredBundleImpl> result = new ArrayList<RequiredBundleImpl>(matchingBundles.size());
        for (Map.Entry entry : matchingBundles.entrySet()) {
            result.add(new RequiredBundleImpl((AbstractBundle)entry.getKey(), (Collection)entry.getValue()));
        }
        return result.toArray(new RequiredBundle[matchingBundles.size()]);
    }

    public Bundle[] getBundles(String symbolicName, String versionRange) {
        ArrayList<Bundle> result = new ArrayList<Bundle>();
        for (AbstractBundle bundleState : this.getBundleManager().getBundles(symbolicName, versionRange)) {
            if (bundleState.getState() == 1) continue;
            result.add(bundleState.getBundleWrapper());
        }
        return result.isEmpty() ? null : result.toArray(new Bundle[result.size()]);
    }

    public Bundle[] getFragments(Bundle bundle) {
        AbstractBundle bundleState = AbstractBundle.assertBundleState(bundle);
        if (bundle.getBundleId() == 0L || bundleState.isFragment() || !bundleState.isResolved()) {
            return null;
        }
        HostBundle hostBundle = HostBundle.assertBundleState(bundleState);
        HostRevision curRevision = hostBundle.getCurrentRevision();
        ArrayList<Bundle> result = new ArrayList<Bundle>();
        for (FragmentRevision aux : curRevision.getAttachedFragments()) {
            result.add(aux.getBundleState().getBundleWrapper());
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new Bundle[result.size()]);
    }

    public Bundle[] getHosts(Bundle bundle) {
        AbstractBundle bundleState = AbstractBundle.assertBundleState(bundle);
        if (!bundleState.isFragment()) {
            return null;
        }
        FragmentBundle fragBundle = FragmentBundle.assertBundleState(bundleState);
        FragmentRevision curRevision = fragBundle.getCurrentRevision();
        ArrayList<Bundle> result = new ArrayList<Bundle>();
        for (HostRevision aux : curRevision.getAttachedHosts()) {
            result.add(aux.getBundleState().getBundleWrapper());
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new Bundle[result.size()]);
    }

    public Bundle getBundle(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null clazz");
        }
        Bundle result = null;
        ClassLoader loader = clazz.getClassLoader();
        if (loader instanceof BundleReference) {
            BundleReference bundleRef = (BundleReference)loader;
            result = bundleRef.getBundle();
        } else if (loader instanceof ModuleClassLoader) {
            ModuleClassLoader moduleCL = (ModuleClassLoader)loader;
            ModuleManagerPlugin moduleManager = this.getBundleManager().getPlugin(ModuleManagerPlugin.class);
            AbstractBundle bundleState = moduleManager.getBundleState(moduleCL.getModule().getIdentifier());
            Bundle bundle = result = bundleState != null ? bundleState.getBundleWrapper() : null;
        }
        if (result == null) {
            this.log.debugf("Cannot obtain bundle for: %s", (Object)clazz.getName());
        }
        return result;
    }

    public int getBundleType(Bundle bundle) {
        AbstractBundle bundleState = AbstractBundle.assertBundleState(bundle);
        return bundleState.isFragment() ? 1 : 0;
    }

    private static class ExportedPackageComparator
    implements Comparator<ExportedPackage> {
        private ExportedPackageComparator() {
        }

        @Override
        public int compare(ExportedPackage ep1, ExportedPackage ep2) {
            return ep2.getVersion().compareTo((Object)ep1.getVersion());
        }
    }

    private static class BundleStartLevelComparator
    implements Comparator<HostBundle> {
        private final StartLevel startLevel;

        private BundleStartLevelComparator(StartLevel startLevelService) {
            this.startLevel = startLevelService;
        }

        @Override
        public int compare(HostBundle o1, HostBundle o2) {
            int sl2;
            if (this.startLevel == null) {
                return 0;
            }
            int sl1 = o1.getStartLevel();
            return sl1 < (sl2 = o2.getStartLevel()) ? -1 : (sl1 == sl2 ? 0 : 1);
        }
    }

    static class RequiredBundleImpl
    implements RequiredBundle {
        private final Bundle requiredBundle;
        private final Bundle[] requiringBundles;
        private final AbstractRevision bundleRevision;

        public RequiredBundleImpl(AbstractBundle requiredBundle, Collection<AbstractBundle> requiringBundles) {
            this.requiredBundle = AbstractBundle.assertBundleState(requiredBundle).getBundleWrapper();
            this.bundleRevision = requiredBundle.getCurrentRevision();
            ArrayList<Bundle> bundles = new ArrayList<Bundle>(requiringBundles.size());
            for (AbstractBundle ab : requiringBundles) {
                bundles.add(AbstractBundle.assertBundleState(ab).getBundleWrapper());
            }
            this.requiringBundles = bundles.toArray(new Bundle[bundles.size()]);
        }

        public String getSymbolicName() {
            return this.requiredBundle.getSymbolicName();
        }

        public Bundle getBundle() {
            if (this.isRemovalPending()) {
                return null;
            }
            return this.requiredBundle;
        }

        public Bundle[] getRequiringBundles() {
            if (this.isRemovalPending()) {
                return null;
            }
            return this.requiringBundles;
        }

        public Version getVersion() {
            return this.requiredBundle.getVersion();
        }

        public boolean isRemovalPending() {
            if (this.requiredBundle.getState() == 1) {
                return true;
            }
            return !this.bundleRevision.equals(this.bundleRevision.getBundleState().getCurrentRevision());
        }
    }

    static class ExportedPackageImpl
    implements ExportedPackage {
        private final XPackageCapability capability;

        ExportedPackageImpl(XPackageCapability cap) {
            this.capability = cap;
        }

        public String getName() {
            return this.capability.getName();
        }

        public Bundle getExportingBundle() {
            Bundle bundle = (Bundle)this.capability.getModule().getAttachment(Bundle.class);
            AbstractBundle bundleState = AbstractBundle.assertBundleState(bundle);
            return bundleState.getBundleWrapper();
        }

        public Bundle[] getImportingBundles() {
            XBundleCapability bundleCap;
            Set bundleReqSet;
            if (this.isRemovalPending()) {
                return null;
            }
            XModule capModule = this.capability.getModule();
            if (!capModule.isResolved()) {
                return null;
            }
            HashSet reqset = new HashSet();
            Set pkgReqSet = this.capability.getWiredRequirements();
            if (pkgReqSet != null) {
                reqset.addAll(pkgReqSet);
            }
            if ((bundleReqSet = (bundleCap = capModule.getBundleCapability()).getWiredRequirements()) != null) {
                reqset.addAll(bundleReqSet);
            }
            HashSet<Bundle> bundles = new HashSet<Bundle>();
            for (XRequirement req : reqset) {
                XModule reqmod = req.getModule();
                Bundle bundle = (Bundle)reqmod.getAttachment(Bundle.class);
                AbstractBundle bundleState = AbstractBundle.assertBundleState(bundle);
                bundles.add(bundleState.getBundleWrapper());
            }
            Bundle capBundle = (Bundle)capModule.getAttachment(Bundle.class);
            AbstractBundle capAbstractBundle = AbstractBundle.assertBundleState(capBundle);
            bundles.remove(capAbstractBundle.getBundleWrapper());
            return bundles.toArray(new Bundle[bundles.size()]);
        }

        public String getSpecificationVersion() {
            return this.capability.getVersion().toString();
        }

        public Version getVersion() {
            return this.capability.getVersion();
        }

        public boolean isRemovalPending() {
            XModule module = this.capability.getModule();
            AbstractRevision rev = (AbstractRevision)module.getAttachment(AbstractRevision.class);
            Bundle b = (Bundle)module.getAttachment(Bundle.class);
            AbstractBundle ab = AbstractBundle.assertBundleState(b);
            return !ab.getCurrentRevision().equals(rev) || ab.getState() == 1;
        }

        private XPackageCapability getCapability() {
            return this.capability;
        }
    }
}

