/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.plugin.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.modules.filter.MultiplePathFilterBuilder;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.plugin.AbstractPlugin;
import org.jboss.osgi.framework.plugin.SystemPackagesPlugin;

public class SystemPackagesPluginImpl
extends AbstractPlugin
implements SystemPackagesPlugin {
    final Logger log = Logger.getLogger(SystemPackagesPluginImpl.class);
    private Set<String> systemPackages = new LinkedHashSet<String>();
    private Set<String> bootDelegationPackages = new LinkedHashSet<String>();
    private Set<String> frameworkPackages = new LinkedHashSet<String>();

    public SystemPackagesPluginImpl(BundleManager bundleManager) {
        super(bundleManager);
        String bootDelegationProp;
        String systemPackagesProp = (String)bundleManager.getProperty("org.osgi.framework.system.packages");
        if (systemPackagesProp != null) {
            this.systemPackages.addAll(this.packagesAsList(systemPackagesProp));
        } else {
            this.systemPackages.add("javax.imageio");
            this.systemPackages.add("javax.imageio.stream");
            this.systemPackages.add("javax.management");
            this.systemPackages.add("javax.management.loading");
            this.systemPackages.add("javax.management.modelmbean");
            this.systemPackages.add("javax.management.monitor");
            this.systemPackages.add("javax.management.openmbean");
            this.systemPackages.add("javax.management.relation");
            this.systemPackages.add("javax.management.remote");
            this.systemPackages.add("javax.management.remote.rmi");
            this.systemPackages.add("javax.management.timer");
            this.systemPackages.add("javax.naming");
            this.systemPackages.add("javax.naming.event");
            this.systemPackages.add("javax.naming.spi");
            this.systemPackages.add("javax.net");
            this.systemPackages.add("javax.net.ssl");
            this.systemPackages.add("javax.security.cert");
            this.systemPackages.add("javax.xml.datatype");
            this.systemPackages.add("javax.xml.namespace");
            this.systemPackages.add("javax.xml.parsers");
            this.systemPackages.add("javax.xml.validation");
            this.systemPackages.add("javax.xml.transform");
            this.systemPackages.add("javax.xml.transform.dom");
            this.systemPackages.add("javax.xml.transform.sax");
            this.systemPackages.add("javax.xml.transform.stream");
            this.systemPackages.add("org.jboss.modules");
            this.systemPackages.add("org.w3c.dom");
            this.systemPackages.add("org.w3c.dom.bootstrap");
            this.systemPackages.add("org.w3c.dom.ls");
            this.systemPackages.add("org.w3c.dom.events");
            this.systemPackages.add("org.w3c.dom.ranges");
            this.systemPackages.add("org.w3c.dom.views");
            this.systemPackages.add("org.w3c.dom.traversal");
            this.systemPackages.add("org.xml.sax");
            this.systemPackages.add("org.xml.sax.ext");
            this.systemPackages.add("org.xml.sax.helpers");
            this.systemPackages.add("com.sun.org.apache.xerces.internal.jaxp.validation");
            String asString = this.packagesAsString(this.systemPackages);
            bundleManager.setProperty("org.osgi.framework.system.packages", asString);
        }
        String extraPackages = (String)bundleManager.getProperty("org.osgi.framework.system.packages.extra");
        if (extraPackages != null) {
            this.systemPackages.addAll(this.packagesAsList(extraPackages));
        }
        if ((bootDelegationProp = (String)bundleManager.getProperty("org.osgi.framework.bootdelegation")) != null) {
            String[] packageNames;
            for (String packageName : packageNames = bootDelegationProp.split(",")) {
                this.bootDelegationPackages.add(packageName);
            }
        } else {
            this.bootDelegationPackages.add("sun.reflect");
        }
        this.frameworkPackages.add("org.jboss.msc.service");
        this.frameworkPackages.add("org.jboss.osgi.deployment.deployer");
        this.frameworkPackages.add("org.jboss.osgi.deployment.interceptor");
        this.frameworkPackages.add("org.jboss.osgi.framework.url");
        this.frameworkPackages.add("org.jboss.osgi.modules");
        this.frameworkPackages.add("org.osgi.framework;version=1.5");
        this.frameworkPackages.add("org.osgi.framework.hooks;version=1.0");
        this.frameworkPackages.add("org.osgi.framework.hooks.service;version=1.0");
        this.frameworkPackages.add("org.osgi.framework.launch;version=1.0");
        this.frameworkPackages.add("org.osgi.service.condpermadmin;version=1.1");
        this.frameworkPackages.add("org.osgi.service.packageadmin;version=1.2");
        this.frameworkPackages.add("org.osgi.service.permissionadmin;version=1.2");
        this.frameworkPackages.add("org.osgi.service.startlevel;version=1.1");
        this.frameworkPackages.add("org.osgi.service.url;version=1.0");
        this.frameworkPackages.add("org.osgi.util.tracker;version=1.4");
    }

    @Override
    public Set<String> getFrameworkPackages() {
        return Collections.unmodifiableSet(this.frameworkPackages);
    }

    @Override
    public Set<String> getFrameworkPackagePaths() {
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        for (String packageSpec : this.getFrameworkPackages()) {
            int index = packageSpec.indexOf(59);
            if (index > 0) {
                packageSpec = packageSpec.substring(0, index);
            }
            paths.add(packageSpec.replace('.', '/'));
        }
        return Collections.unmodifiableSet(paths);
    }

    @Override
    public boolean isFrameworkPackage(String name) {
        this.assertInitialized();
        return this.isPackageNameInSet(this.getFrameworkPackages(), name);
    }

    @Override
    public PathFilter getFrameworkPackageFilter() {
        this.assertInitialized();
        return PathFilters.in(this.getFrameworkPackagePaths());
    }

    @Override
    public Set<String> getBootDelegationPackages() {
        this.assertInitialized();
        return Collections.unmodifiableSet(this.bootDelegationPackages);
    }

    @Override
    public PathFilter getBootDelegationPackageFilter() {
        this.assertInitialized();
        MultiplePathFilterBuilder builder = PathFilters.multiplePathFilterBuilder((boolean)false);
        for (String packageName : this.getBootDelegationPackages()) {
            if (packageName.equals("*")) {
                if (this.doFrameworkPackageDelegation()) {
                    builder.addFilter(PathFilters.acceptAll(), true);
                    continue;
                }
                builder.addFilter(PathFilters.all((PathFilter[])new PathFilter[]{PathFilters.acceptAll(), PathFilters.not((PathFilter)this.getFrameworkPackageFilter())}), true);
                continue;
            }
            if (packageName.endsWith(".*")) {
                packageName = packageName.substring(0, packageName.length() - 2);
                builder.addFilter(PathFilters.isChildOf((String)packageName.replace('.', '/')), true);
                continue;
            }
            builder.addFilter(PathFilters.is((String)packageName.replace('.', '/')), true);
        }
        return builder.create();
    }

    @Override
    public boolean isBootDelegationPackage(String name) {
        this.assertInitialized();
        if (name == null) {
            throw new IllegalArgumentException("Null package name");
        }
        if (name.startsWith("java.")) {
            return true;
        }
        if (this.bootDelegationPackages.contains(name)) {
            return true;
        }
        for (String aux : this.bootDelegationPackages) {
            if (!aux.endsWith(".*") || !name.startsWith(aux.substring(0, aux.length() - 2))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getSystemPackages() {
        this.assertInitialized();
        return Collections.unmodifiableSet(this.systemPackages);
    }

    @Override
    public boolean isSystemPackage(String name) {
        this.assertInitialized();
        return this.isPackageNameInSet(this.systemPackages, name);
    }

    @Override
    public PathFilter getSystemPackageFilter() {
        this.assertInitialized();
        MultiplePathFilterBuilder builder = PathFilters.multiplePathFilterBuilder((boolean)false);
        builder.addFilter(this.getBootDelegationPackageFilter(), true);
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        for (String packageSpec : this.getSystemPackages()) {
            int index = packageSpec.indexOf(59);
            if (index > 0) {
                packageSpec = packageSpec.substring(0, index);
            }
            String path = packageSpec.replace('.', '/');
            paths.add(path);
        }
        builder.addFilter(PathFilters.in(paths), true);
        return builder.create();
    }

    private boolean doFrameworkPackageDelegation() {
        boolean allBootDelegation;
        String property = (String)this.getBundleManager().getProperty("org.osgi.framework.bundle.parent");
        if (property == null) {
            property = "boot";
        }
        return !(allBootDelegation = this.getBootDelegationPackages().contains("*")) || !"boot".equals(property) && !"ext".equals(property);
    }

    private boolean isPackageNameInSet(Set<String> packages, String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null package name");
        }
        int index = name.indexOf(59);
        if (index > 0) {
            name = name.substring(0, index);
        }
        if (packages.contains(name)) {
            return true;
        }
        for (String aux : packages) {
            if (!aux.startsWith(name + ";")) continue;
            return true;
        }
        return false;
    }

    private String packagesAsString(Set<String> sysPackages) {
        int i = 0;
        StringBuffer result = new StringBuffer();
        for (String packageName : sysPackages) {
            if (i++ > 0) {
                result.append(",");
            }
            result.append(packageName);
        }
        return result.toString();
    }

    private List<String> packagesAsList(String sysPackages) {
        ArrayList<String> result = new ArrayList<String>();
        for (String name : sysPackages.split(",")) {
            if ((name = name.trim()).length() <= 0) continue;
            result.add(name);
        }
        return result;
    }

    private void assertInitialized() {
        if (this.systemPackages.isEmpty()) {
            throw new IllegalStateException("SystemPackagesPlugin not initialized");
        }
    }
}

