/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.plugin.internal;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ContentHandler;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.plugin.AbstractPlugin;
import org.jboss.osgi.framework.plugin.URLHandlerPlugin;
import org.jboss.osgi.framework.plugin.internal.BundleProtocolHandler;
import org.jboss.osgi.framework.plugin.internal.OSGiContentHandlerFactory;
import org.jboss.osgi.framework.plugin.internal.OSGiContentHandlerFactoryDelegate;
import org.jboss.osgi.framework.plugin.internal.OSGiStreamHandlerFactoryDelegate;
import org.jboss.osgi.framework.url.OSGiStreamHandlerFactory;
import org.jboss.osgi.framework.url.OSGiStreamHandlerFactoryService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerSetter;
import org.osgi.util.tracker.ServiceTracker;

public class URLHandlerPluginImpl
extends AbstractPlugin
implements URLHandlerPlugin {
    private final Logger log = Logger.getLogger(URLHandlerPluginImpl.class);
    private ServiceTracker streamServiceTracker;
    private ServiceTracker contentServiceTracker;
    private ServiceRegistration protocolRegistration;
    private static OSGiContentHandlerFactoryDelegate contentHandlerDelegate;
    private static OSGiStreamHandlerFactoryDelegate streamHandlerDelegate;

    public URLHandlerPluginImpl(final BundleManager bundleManager) {
        super(bundleManager);
        if (streamHandlerDelegate == null) {
            streamHandlerDelegate = new OSGiStreamHandlerFactoryDelegate();
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    block2: {
                        try {
                            URL.setURLStreamHandlerFactory(streamHandlerDelegate);
                        }
                        catch (Throwable th) {
                            if (bundleManager.getIntegrationMode() != BundleManager.IntegrationMode.STANDALONE) break block2;
                            URLHandlerPluginImpl.this.log.warn((Object)"Unable to set the URLStreamHandlerFactory", th);
                        }
                    }
                    return null;
                }
            });
        }
        if (contentHandlerDelegate == null) {
            contentHandlerDelegate = new OSGiContentHandlerFactoryDelegate();
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    block2: {
                        try {
                            URLConnection.setContentHandlerFactory(contentHandlerDelegate);
                        }
                        catch (Throwable th) {
                            if (bundleManager.getIntegrationMode() != BundleManager.IntegrationMode.STANDALONE) break block2;
                            URLHandlerPluginImpl.this.log.warn((Object)"Unable to set the ContentHandlerFactory", th);
                        }
                    }
                    return null;
                }
            });
        }
    }

    @Override
    public void initPlugin() {
        OSGiStreamHandlerFactoryService.initStreamHandlerFactory(this);
        streamHandlerDelegate.setDelegate(new OSGiStreamHandlerFactory(this));
        contentHandlerDelegate.setDelegate(new OSGiContentHandlerFactory(this));
    }

    @Override
    public void startPlugin() {
        BundleContext sysContext = this.getBundleManager().getSystemContext();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("url.handler.protocol", "bundle");
        BundleProtocolHandler service = new BundleProtocolHandler(this.getBundleManager());
        this.protocolRegistration = sysContext.registerService(URLStreamHandlerService.class.getName(), (Object)service, props);
        this.streamServiceTracker = new ServiceTracker(sysContext, URLStreamHandlerService.class.getName(), null){

            @Override
            public Object addingService(ServiceReference reference) {
                Object svc = super.addingService(reference);
                String[] protocols = URLHandlerPluginImpl.this.parseServiceProperty(reference.getProperty("url.handler.protocol"));
                if (protocols != null && svc instanceof URLStreamHandlerService) {
                    for (String protocol : protocols) {
                        streamHandlerDelegate.addHandler(protocol, reference);
                    }
                } else {
                    URLHandlerPluginImpl.this.log.errorf("A non-compliant instance of %s has been registered for protocols %s for: %s", (Object)URLStreamHandlerService.class.getName(), Arrays.asList(protocols), svc);
                }
                return svc;
            }

            @Override
            public void modifiedService(ServiceReference reference, Object service) {
                this.removedService(reference, service);
                this.addingService(reference);
            }

            @Override
            public void removedService(ServiceReference reference, Object service) {
                super.removedService(reference, service);
                streamHandlerDelegate.removeHandler(reference);
            }
        };
        this.streamServiceTracker.open();
        this.contentServiceTracker = new ServiceTracker(sysContext, ContentHandler.class.getName(), null){

            @Override
            public Object addingService(ServiceReference reference) {
                Object svc = super.addingService(reference);
                Object[] mimeTypes = URLHandlerPluginImpl.this.parseServiceProperty(reference.getProperty("url.content.mimetype"));
                if (mimeTypes != null && svc instanceof ContentHandler) {
                    for (Object mimeType : mimeTypes) {
                        contentHandlerDelegate.addHandler((String)mimeType, reference);
                    }
                } else {
                    URLHandlerPluginImpl.this.log.errorf("A non-compliant instance of %s has been registered for mime types %s for %s", (Object)ContentHandler.class.getName(), (Object)Arrays.toString(mimeTypes), svc);
                }
                return svc;
            }

            @Override
            public void modifiedService(ServiceReference reference, Object service) {
                this.removedService(reference, service);
                this.addingService(reference);
            }

            @Override
            public void removedService(ServiceReference reference, Object service) {
                super.removedService(reference, service);
                contentHandlerDelegate.removeHandler(reference);
            }
        };
        this.contentServiceTracker.open();
    }

    @Override
    public void stopPlugin() {
        this.protocolRegistration.unregister();
        this.streamServiceTracker.close();
        streamHandlerDelegate.clearHandlers();
        this.contentServiceTracker.close();
        contentHandlerDelegate.clearHandlers();
    }

    @Override
    public void destroyPlugin() {
        streamHandlerDelegate.setDelegate(null);
        contentHandlerDelegate.setDelegate(null);
        OSGiStreamHandlerFactoryService.destroyStreamHandlerFactory();
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        List<ServiceReference> refList = streamHandlerDelegate.getStreamHandlers(protocol);
        if (refList == null || refList.isEmpty()) {
            return null;
        }
        return new URLStreamHandlerProxy(protocol, refList);
    }

    @Override
    public ContentHandler createContentHandler(String mimetype) {
        List<ServiceReference> refList = contentHandlerDelegate.getContentHandlers(mimetype);
        if (refList == null || refList.isEmpty()) {
            return null;
        }
        ServiceReference ref = refList.get(0);
        Object service = ref.getBundle().getBundleContext().getService(ref);
        if (service instanceof ContentHandler) {
            return (ContentHandler)service;
        }
        return null;
    }

    private String[] parseServiceProperty(Object prop) {
        if (prop == null) {
            return null;
        }
        if (prop instanceof String) {
            return new String[]{(String)prop};
        }
        if (prop instanceof String[]) {
            return (String[])prop;
        }
        return null;
    }

    private static final class URLStreamHandlerProxy
    extends URLStreamHandler
    implements URLStreamHandlerSetter {
        private final List<ServiceReference> serviceReferences;
        private final String protocol;

        public URLStreamHandlerProxy(String protocol, List<ServiceReference> refList) {
            this.protocol = protocol;
            this.serviceReferences = refList;
        }

        @Override
        public void setURL(URL u, String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
            super.setURL(u, protocol, host, port, authority, userInfo, path, query, ref);
        }

        @Override
        public void setURL(URL u, String protocol, String host, int port, String file, String ref) {
            super.setURL(u, protocol, host, port, file, ref);
        }

        @Override
        protected void parseURL(URL u, String spec, int start, int limit) {
            this.getHandlerService().parseURL((URLStreamHandlerSetter)this, u, spec, start, limit);
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return this.getHandlerService().openConnection(u);
        }

        @Override
        protected String toExternalForm(URL u) {
            return this.getHandlerService().toExternalForm(u);
        }

        @Override
        protected URLConnection openConnection(URL u, Proxy p) throws IOException {
            URLStreamHandlerService handler = this.getHandlerService();
            try {
                Method method = handler.getClass().getDeclaredMethod("openConnection", URL.class, Proxy.class);
                return (URLConnection)method.invoke((Object)handler, u, p);
            }
            catch (NoSuchMethodException e) {
                throw new IOException("openConnection(URL,Proxy) not found on " + handler, e);
            }
            catch (IllegalAccessException e) {
                throw new IOException("openConnection(URL,Proxy) not accessible on " + handler, e);
            }
            catch (InvocationTargetException e) {
                throw new IOException("Problem invoking openConnection(URL,Proxy) on " + handler, e);
            }
        }

        @Override
        protected int getDefaultPort() {
            return this.getHandlerService().getDefaultPort();
        }

        @Override
        protected boolean equals(URL u1, URL u2) {
            return this.getHandlerService().equals(u1, u2);
        }

        @Override
        protected int hashCode(URL u) {
            return this.getHandlerService().hashCode(u);
        }

        @Override
        protected boolean sameFile(URL u1, URL u2) {
            return this.getHandlerService().sameFile(u1, u2);
        }

        @Override
        protected synchronized InetAddress getHostAddress(URL u) {
            return this.getHandlerService().getHostAddress(u);
        }

        @Override
        protected boolean hostsEqual(URL u1, URL u2) {
            return this.getHandlerService().hostsEqual(u1, u2);
        }

        private URLStreamHandlerService getHandlerService() {
            if (this.serviceReferences.isEmpty()) {
                throw new IllegalStateException("No handlers in the OSGi Service registry for protocol: " + this.protocol);
            }
            ServiceReference ref = this.serviceReferences.get(0);
            Object service = ref.getBundle().getBundleContext().getService(ref);
            if (service instanceof URLStreamHandlerService) {
                return (URLStreamHandlerService)service;
            }
            throw new IllegalStateException("Problem with OSGi URL handler service " + service + " for url:" + this.protocol);
        }
    }
}

