/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.arquillian.spi.Configuration;
import org.jboss.arquillian.spi.ContainerMethodExecutor;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.DeployableContainer;
import org.jboss.arquillian.spi.DeploymentException;
import org.jboss.as.arquillian.container.JBossAsContainerConfiguration;
import org.jboss.as.arquillian.protocol.servlet.ServletMethodExecutor;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.standalone.DeploymentAction;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentActionResult;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;
import org.jboss.modules.management.ObjectProperties;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.management.ServiceContainerMXBean;
import org.jboss.osgi.jmx.MBeanProxy;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;

public abstract class AbstractDeployableContainer
implements DeployableContainer {
    static final ObjectName OBJECT_NAME;
    private static final Logger log;
    private JBossAsContainerConfiguration containerConfig;
    private ServerDeploymentManager deploymentManager;
    private final Map<Archive<?>, String> registry = new HashMap();

    public void setup(Context context, Configuration configuration) {
        this.containerConfig = (JBossAsContainerConfiguration)configuration.getContainerConfig(JBossAsContainerConfiguration.class);
        ModelControllerClient client = ModelControllerClient.Factory.create((InetAddress)this.containerConfig.getBindAddress(), (int)this.containerConfig.getManagementPort());
        this.deploymentManager = ServerDeploymentManager.Factory.create((ModelControllerClient)client);
    }

    protected JBossAsContainerConfiguration getContainerConfiguration() {
        return this.containerConfig;
    }

    public ContainerMethodExecutor deploy(Context context, Archive<?> archive) throws DeploymentException {
        try {
            InputStream input = ((ZipExporter)archive.as(ZipExporter.class)).exportZip();
            DeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan().withRollback();
            builder = builder.add(archive.getName(), input).andDeploy();
            DeploymentPlan plan = builder.build();
            DeploymentAction deployAction = builder.getLastAction();
            this.executeDeploymentPlan(plan, deployAction, archive);
            return this.getContainerMethodExecutor(context);
        }
        catch (Exception e) {
            throw new DeploymentException("Could not deploy to container", (Throwable)e);
        }
    }

    public void undeploy(Context context, Archive<?> archive) throws DeploymentException {
        String runtimeName = this.registry.remove(archive);
        if (runtimeName != null) {
            try {
                DeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan().withRollback();
                DeploymentPlan plan = builder.undeploy(runtimeName).remove(runtimeName).build();
                Future future = this.deploymentManager.execute(plan);
                future.get();
            }
            catch (Exception ex) {
                log.warning("Cannot undeploy: " + runtimeName + ":" + ex.getMessage());
            }
        }
    }

    protected void waitForMBean(ObjectName objectName, long timeout) throws IOException, InterruptedException {
        boolean mbeanAvailable = false;
        MBeanServerConnection mbeanServer = null;
        while (timeout > 0L && !mbeanAvailable) {
            if (mbeanServer == null) {
                try {
                    mbeanServer = this.getMBeanServerConnection();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            mbeanAvailable = mbeanServer != null && mbeanServer.isRegistered(objectName);
            Thread.sleep(100L);
            timeout -= 100L;
        }
        if (!mbeanAvailable) {
            throw new IllegalStateException("MBean not available: " + objectName);
        }
    }

    protected void waitForServiceState(ServiceName serviceName, ServiceController.State expectedState, long timeout) throws IOException, InterruptedException {
        ObjectName objectName = OBJECT_NAME;
        MBeanServerConnection mbeanServer = this.getMBeanServerConnection();
        ServiceContainerMXBean proxy = (ServiceContainerMXBean)MBeanProxy.get((MBeanServerConnection)mbeanServer, (ObjectName)objectName, ServiceContainerMXBean.class);
        ServiceController.State currentState = ServiceController.State.valueOf((String)proxy.getServiceStatus(serviceName.getCanonicalName()).getStateName());
        while (timeout > 0L && currentState != expectedState) {
            Thread.sleep(100L);
            timeout -= 100L;
            currentState = ServiceController.State.valueOf((String)proxy.getServiceStatus(serviceName.getCanonicalName()).getStateName());
        }
        if (currentState != expectedState) {
            throw new IllegalStateException("Unexpected state for [" + serviceName + "] - " + currentState);
        }
    }

    protected ContainerMethodExecutor getContainerMethodExecutor(Context context) {
        JBossAsContainerConfiguration config = (JBossAsContainerConfiguration)((Configuration)context.get(Configuration.class)).getContainerConfig(JBossAsContainerConfiguration.class);
        if (config.isExecuteWithServlet()) {
            try {
                return new ServletMethodExecutor(new URL("http", config.getBindAddress().getHostName(), config.getHttpPort(), "/"));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return this.getContainerMethodExecutor();
    }

    protected abstract MBeanServerConnection getMBeanServerConnection();

    protected abstract ContainerMethodExecutor getContainerMethodExecutor();

    private String executeDeploymentPlan(DeploymentPlan plan, DeploymentAction deployAction, Archive<?> archive) throws Exception {
        Exception deploymentException;
        Future future = this.deploymentManager.execute(plan);
        this.registry.put(archive, deployAction.getDeploymentUnitUniqueName());
        ServerDeploymentPlanResult planResult = (ServerDeploymentPlanResult)future.get();
        ServerDeploymentActionResult actionResult = planResult.getDeploymentActionResult(deployAction.getId());
        if (actionResult != null && (deploymentException = (Exception)actionResult.getDeploymentException()) != null) {
            throw deploymentException;
        }
        return deployAction.getDeploymentUnitUniqueName();
    }

    static {
        try {
            OBJECT_NAME = new ObjectName("jboss.msc", (Hashtable<String, String>)ObjectProperties.properties((ObjectProperties.Property[])new ObjectProperties.Property[]{ObjectProperties.property((String)"type", (String)"container"), ObjectProperties.property((String)"name", (String)"jbossas")}));
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException(e);
        }
        log = Logger.getLogger(AbstractDeployableContainer.class.getName());
    }
}

