/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelRemoveOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.server.deployment.scanner.DeploymentScannerService;
import org.jboss.as.server.deployment.scanner.DeploymentSubsystemDescriptions;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

class DeploymentScannerRemove
implements ModelRemoveOperationHandler,
DescriptionProvider {
    static final String OPERATION_NAME = "remove";
    static final DeploymentScannerRemove INSTANCE = new DeploymentScannerRemove();

    private DeploymentScannerRemove() {
    }

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        final String name = address.getLastElement().getValue();
        ModelNode subModel = new ModelNode();
        ModelNode compensatingOperation = new ModelNode();
        compensatingOperation.get("operation").set("add");
        compensatingOperation.get("address").set(operation.require("address"));
        compensatingOperation.get("path").set(subModel.get("path"));
        if (subModel.hasDefined("scan-enabled")) {
            compensatingOperation.get("scan-enabled").set(subModel.get("scan-enabled"));
        }
        if (subModel.hasDefined("scan-interval")) {
            compensatingOperation.get("scan-interval").set(subModel.get("scan-interval"));
        }
        if (subModel.hasDefined("relative-to")) {
            compensatingOperation.get("relative-to").set(subModel.get("relative-to"));
        }
        if (subModel.hasDefined("auto-deploy-zipped")) {
            compensatingOperation.get("auto-deploy-zipped").set(subModel.get("auto-deploy-zipped"));
        }
        if (subModel.hasDefined("auto-deploy-exploded")) {
            compensatingOperation.get("auto-deploy-exploded").set(subModel.get("auto-deploy-exploded"));
        }
        if (subModel.hasDefined("deployment-timeout")) {
            compensatingOperation.get("deployment-timeout").set(subModel.get("deployment-timeout"));
        }
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceController controller = context.getServiceRegistry().getService(DeploymentScannerService.getServiceName(name));
                    if (controller != null) {
                        controller.addListener((ServiceListener)new ResultHandler.ServiceRemoveListener(resultHandler));
                    } else {
                        resultHandler.handleResultComplete();
                    }
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }

    public ModelNode getModelDescription(Locale locale) {
        return DeploymentSubsystemDescriptions.getScannerRemove(locale);
    }
}

