/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.util.HashMap;
import java.util.Map;

enum Element {
    UNKNOWN(null),
    SUBSYSTEM("subsystem"),
    CONFIGURATION("configuration"),
    WEBSERVICE_HOST("webServiceHost"),
    MODIFY_SOAP_ADDRESS("modifySOAPAddress"),
    WEBSERVICE_SECURE_PORT("webServiceSecurePort"),
    WEBSERVICE_PORT("webServicePort");

    private final String name;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
    }

    static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    String getLocalName() {
        return this.name;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

