/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.webservices.dmr.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class WSSubsystemProviders {
    static final String RESOURCE_NAME = WSSubsystemProviders.class.getPackage().getName() + ".LocalDescriptions";
    static final DescriptionProvider SUBSYSTEM = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSubsystem(locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSubsystemAdd(locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_DESCRIBE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    };

    WSSubsystemProviders() {
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }

    private static class Descriptions {
        private Descriptions() {
        }

        static ModelNode getSubsystem(Locale locale) {
            ResourceBundle bundle = WSSubsystemProviders.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            subsystem.get("description").set(bundle.getString("ws"));
            subsystem.get("head-comment-allowed").set(true);
            subsystem.get("tail-comment-allowed").set(true);
            subsystem.get("namespace").set(Namespace.WEBSERVICES_1_0.getUriString());
            subsystem.get(new String[]{"attributes", "configuration", "description"}).set(bundle.getString("configuration"));
            subsystem.get(new String[]{"attributes", "configuration", "type"}).set(ModelType.OBJECT);
            subsystem.get(new String[]{"attributes", "configuration", "required"}).set(true);
            subsystem.get(new String[]{"attributes", "configuration", "value-type", "modify-soap-address", "description"}).set(bundle.getString("modify-soap-address"));
            subsystem.get(new String[]{"attributes", "configuration", "value-type", "modify-soap-address", "type"}).set(ModelType.BOOLEAN);
            subsystem.get(new String[]{"attributes", "configuration", "value-type", "modify-soap-address", "required"}).set(true);
            subsystem.get(new String[]{"attributes", "configuration", "value-type", "webservice-host", "description"}).set(bundle.getString("web-service-host"));
            subsystem.get(new String[]{"attributes", "configuration", "value-type", "webservice-host", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "configuration", "value-type", "webservice-host", "required"}).set(true);
            subsystem.get(new String[]{"attributes", "configuration", "value-type", "webservice-port", "description"}).set(bundle.getString("web-service-port"));
            subsystem.get(new String[]{"attributes", "configuration", "value-type", "webservice-port", "type"}).set(ModelType.INT);
            subsystem.get(new String[]{"attributes", "configuration", "value-type", "webservice-port", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "configuration", "value-type", "webservice-secure-port", "description"}).set(bundle.getString("web-service-secure-port"));
            subsystem.get(new String[]{"attributes", "configuration", "value-type", "webservice-secure-port", "type"}).set(ModelType.INT);
            subsystem.get(new String[]{"attributes", "configuration", "value-type", "webservice-secure-port", "required"}).set(false);
            return subsystem;
        }

        static ModelNode getSubsystemAdd(Locale locale) {
            ResourceBundle bundle = WSSubsystemProviders.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("operation-name").set("add");
            op.get("description").set(bundle.getString("ws.add"));
            op.get(new String[]{"request-properties", "configuration", "description"}).set(bundle.getString("configuration"));
            op.get(new String[]{"request-properties", "configuration", "type"}).set(ModelType.OBJECT);
            op.get(new String[]{"request-properties", "configuration", "required"}).set(true);
            op.get(new String[]{"request-properties", "configuration", "value-type", "modify-soap-address", "description"}).set(bundle.getString("modify-soap-address"));
            op.get(new String[]{"request-properties", "configuration", "value-type", "modify-soap-address", "type"}).set(ModelType.BOOLEAN);
            op.get(new String[]{"request-properties", "configuration", "value-type", "modify-soap-address", "required"}).set(true);
            op.get(new String[]{"request-properties", "configuration", "value-type", "webservice-host", "description"}).set(bundle.getString("web-service-host"));
            op.get(new String[]{"request-properties", "configuration", "value-type", "webservice-host", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "configuration", "value-type", "webservice-host", "required"}).set(true);
            op.get(new String[]{"request-properties", "configuration", "value-type", "webservice-port", "description"}).set(bundle.getString("web-service-port"));
            op.get(new String[]{"request-properties", "configuration", "value-type", "webservice-port", "type"}).set(ModelType.INT);
            op.get(new String[]{"request-properties", "configuration", "value-type", "webservice-port", "required"}).set(false);
            op.get(new String[]{"request-properties", "configuration", "value-type", "webservice-secure-port", "description"}).set(bundle.getString("web-service-secure-port"));
            op.get(new String[]{"request-properties", "configuration", "value-type", "webservice-secure-port", "type"}).set(ModelType.INT);
            op.get(new String[]{"request-properties", "configuration", "value-type", "webservice-secure-port", "required"}).set(false);
            op.get("reply-properties").setEmptyObject();
            return op;
        }
    }
}

